/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.osgi.container.ModuleContainer;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.Version;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.FrameworkWiring;

public final class BundleUtils {
    private static final String REFERENCE_PREFIX = "reference:";

    private BundleUtils() {
    }

    public static void loadBundles(Collection<String> bundleLocations) throws CoreException {
        if (bundleLocations == null || bundleLocations.isEmpty()) {
            return;
        }
        BundleContext context = JavaLanguageServerPlugin.getBundleContext();
        MultiStatus status = new MultiStatus(context.getBundle().getSymbolicName(), 0, "Load bundle list", null);
        HashSet<Bundle> bundlesToStart = new HashSet<Bundle>();
        HashSet<Bundle> toRefresh = new HashSet<Bundle>();
        FrameworkWiring frameworkWiring = BundleUtils.getFrameworkWiring();
        for (String bundleLocation : bundleLocations) {
            try {
                if (StringUtils.isEmpty((CharSequence)bundleLocation)) {
                    JavaLanguageServerPlugin.logError("Empty bundle location");
                    continue;
                }
                String location = BundleUtils.getBundleLocation(bundleLocation, true);
                BundleInfo bundleInfo = BundleUtils.getBundleInfo(bundleLocation);
                if (bundleInfo == null) {
                    status.add((IStatus)new Status(4, context.getBundle().getSymbolicName(), "Failed to get bundleInfo for bundle from " + bundleLocation, null));
                    continue;
                }
                Bundle[] bundles = BundleUtils.getBundles(bundleInfo.getSymbolicName(), frameworkWiring);
                if (bundles != null) {
                    Version currentBundleVersion = Version.parseVersion((String)bundleInfo.getVersion());
                    if (bundleInfo.isSingleton()) {
                        if (bundles.length > 1) {
                            status.add((IStatus)new Status(4, context.getBundle().getSymbolicName(), "Multiple singleton bundles are installed: " + bundleInfo.getSymbolicName()));
                            continue;
                        }
                        if (bundles[0].getLocation().equals(location) && bundles[0].getVersion().equals((Object)currentBundleVersion)) continue;
                        BundleUtils.uninstallBundle(bundlesToStart, toRefresh, bundles[0]);
                    } else {
                        boolean shouldSkip = false;
                        Bundle[] bundleArray = bundles;
                        int n = bundles.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Bundle bundle = bundleArray[n2];
                            if (bundle.getVersion().equals((Object)currentBundleVersion)) {
                                if (bundle.getLocation().equals(location)) {
                                    shouldSkip = true;
                                    break;
                                }
                                BundleUtils.uninstallBundle(bundlesToStart, toRefresh, bundle);
                                break;
                            }
                            ++n2;
                        }
                        if (shouldSkip) continue;
                    }
                }
                BundleUtils.installBundle(context, bundlesToStart, location);
            }
            catch (BundleException e) {
                status.add((IStatus)new Status(4, context.getBundle().getSymbolicName(), "Install bundle failure " + bundleLocation, (Throwable)e));
            }
            catch (MalformedURLException ex) {
                status.add((IStatus)new Status(4, context.getBundle().getSymbolicName(), "Bundle location format is not correct " + bundleLocation, (Throwable)ex));
            }
            catch (IOException e) {
                status.add((IStatus)new Status(4, context.getBundle().getSymbolicName(), "Cannot extract bundle symbolicName or version " + bundleLocation, (Throwable)e));
            }
        }
        BundleUtils.refreshBundles(toRefresh, frameworkWiring);
        status.addAll(BundleUtils.startBundles(bundlesToStart));
        if (status.getChildren().length > 0) {
            throw new CoreException((IStatus)status);
        }
    }

    private static void installBundle(BundleContext context, Set<Bundle> bundlesToStart, String location) throws BundleException {
        Bundle newlyInstalledBundle = context.installBundle(location);
        JavaLanguageServerPlugin.logInfo("Installed " + newlyInstalledBundle.getLocation());
        bundlesToStart.add(newlyInstalledBundle);
    }

    private static void uninstallBundle(Set<Bundle> bundlesToStart, Set<Bundle> toRefresh, Bundle bundle) throws BundleException {
        if (BundleUtils.selfExcludedFromDependencyClosure(bundle)) {
            bundle.uninstall();
            JavaLanguageServerPlugin.logInfo("Uninstalled " + bundle.getLocation());
            toRefresh.add(bundle);
            bundlesToStart.remove(bundle);
        }
    }

    private static boolean selfExcludedFromDependencyClosure(Bundle bundle) throws BundleException {
        Collection bundles = BundleUtils.getFrameworkWiring().getDependencyClosure(Collections.singletonList(bundle));
        for (Bundle b : bundles) {
            if (!"org.eclipse.jdt.ls.core".equals(b.getSymbolicName())) continue;
            JavaLanguageServerPlugin.logError("Cannot refresh bundle " + b.getSymbolicName() + " because its dependency closure includes the org.eclipse.jdt.ls.core bundle.");
            return false;
        }
        return true;
    }

    private static FrameworkWiring getFrameworkWiring() {
        BundleContext context = JavaLanguageServerPlugin.getBundleContext();
        FrameworkWiring frameworkWiring = (FrameworkWiring)context.getBundle(0L).adapt(FrameworkWiring.class);
        return frameworkWiring;
    }

    private static Bundle[] getBundles(String symbolicName, FrameworkWiring fwkWiring) {
        BundleContext context = fwkWiring.getBundle().getBundleContext();
        if ("system.bundle".equals(symbolicName)) {
            symbolicName = context.getBundle("System Bundle").getSymbolicName();
        }
        StringBuilder filter = new StringBuilder();
        filter.append('(').append("osgi.identity").append('=').append(symbolicName).append(')');
        Map<String, String> directives = Collections.singletonMap("filter", filter.toString());
        Collection matchingBundleCapabilities = fwkWiring.findProviders(ModuleContainer.createRequirement((String)"osgi.identity", directives, Collections.emptyMap()));
        if (matchingBundleCapabilities.isEmpty()) {
            return null;
        }
        Bundle[] results = (Bundle[])matchingBundleCapabilities.stream().map(c -> c.getRevision().getBundle()).filter(bundle -> (bundle.getState() & 1) == 0).sorted((b1, b2) -> b2.getVersion().compareTo(b1.getVersion())).toArray(Bundle[]::new);
        return results.length > 0 ? results : null;
    }

    private static void refreshBundles(Set<Bundle> toRefresh, FrameworkWiring frameworkWiring) {
        if (!toRefresh.isEmpty()) {
            JavaLanguageServerPlugin.logInfo("Refresh the bundles");
            final CountDownLatch latch = new CountDownLatch(1);
            frameworkWiring.refreshBundles(toRefresh, new FrameworkListener[]{new FrameworkListener(){

                public void frameworkEvent(FrameworkEvent event) {
                    if (event.getType() == 4) {
                        latch.countDown();
                    } else if (event.getType() == 2) {
                        JavaLanguageServerPlugin.logException("Error happens when refreshing the bundles", event.getThrowable());
                        latch.countDown();
                    }
                }
            }});
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                JavaLanguageServerPlugin.logException("InterruptedException happened when refreshing", e);
            }
            JavaLanguageServerPlugin.logInfo("Finished Refreshing bundles");
        }
    }

    private static IStatus startBundles(Collection<Bundle> bundles) {
        BundleContext context = JavaLanguageServerPlugin.getBundleContext();
        MultiStatus status = new MultiStatus(context.getBundle().getSymbolicName(), 0, "Starting added bundles", null);
        for (Bundle bundle : bundles) {
            if (bundle.getState() == 1) {
                status.add((IStatus)new Status(4, context.getBundle().getSymbolicName(), "Could not start: " + bundle.getSymbolicName() + "(" + bundle.getLocation() + ":" + bundle.getBundleId() + "). It's state is uninstalled."));
                continue;
            }
            if ((((BundleRevision)bundle.adapt(BundleRevision.class)).getTypes() & 1) != 0) {
                JavaLanguageServerPlugin.debugTrace(String.format("Fragment bundle '%s' (%s) cannot be started. Skipping.", bundle.getSymbolicName(), bundle.getLocation()));
                continue;
            }
            if (bundle.getState() == 8 || bundle.getBundleId() == 0L) continue;
            try {
                ((BundleStartLevel)bundle.adapt(BundleStartLevel.class)).setStartLevel(4);
                bundle.start(2);
                JavaLanguageServerPlugin.logInfo("Started " + bundle.getLocation());
            }
            catch (BundleException e) {
                status.add((IStatus)new Status(4, context.getBundle().getSymbolicName(), "Bundle startup failed " + bundle.getLocation(), (Throwable)e));
            }
        }
        return status;
    }

    private static String getBundleLocation(String location, boolean useReference) throws MalformedURLException {
        File f = new File(location);
        Object bundleLocation = f.toURI().toString();
        if (useReference) {
            bundleLocation = REFERENCE_PREFIX + (String)bundleLocation;
        }
        return bundleLocation;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static BundleInfo getBundleInfo(String bundleLocation) throws IOException, BundleException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (JarFile jarFile = new JarFile(bundleLocation);){
            Manifest manifest = jarFile.getManifest();
            if (manifest == null) return null;
            Attributes mainAttributes = manifest.getMainAttributes();
            if (mainAttributes == null) return null;
            String bundleVersion = mainAttributes.getValue("Bundle-Version");
            if (StringUtils.isBlank((CharSequence)bundleVersion)) {
                return null;
            }
            String symbolicName = mainAttributes.getValue("Bundle-SymbolicName");
            boolean isSingleton = false;
            if (!StringUtils.isNotBlank((CharSequence)symbolicName)) return new BundleInfo(bundleVersion, symbolicName, isSingleton);
            ManifestElement[] symbolicNameElements = ManifestElement.parseHeader((String)"Bundle-SymbolicName", (String)symbolicName);
            if (symbolicNameElements.length <= 0) return new BundleInfo(bundleVersion, symbolicName, isSingleton);
            symbolicName = symbolicNameElements[0].getValue();
            String singleton = symbolicNameElements[0].getDirective("singleton");
            isSingleton = "true".equals(singleton);
            return new BundleInfo(bundleVersion, symbolicName, isSingleton);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    private static final class BundleInfo {
        private String version;
        private String symbolicName;
        private boolean isSingleton;

        private BundleInfo(String bundleVersion, String symbolicName, boolean isSingleton) {
            this.version = bundleVersion;
            this.symbolicName = symbolicName;
            this.isSingleton = isSingleton;
        }

        private String getVersion() {
            return this.version;
        }

        private String getSymbolicName() {
            return this.symbolicName;
        }

        private boolean isSingleton() {
            return this.isSingleton;
        }
    }
}

