/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corrections.proposals;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.manipulation.ChangeCorrectionProposalCore;
import org.eclipse.jdt.internal.corext.refactoring.sef.SelfEncapsulateFieldRefactoring;
import org.eclipse.jdt.internal.ui.text.correction.GetterSetterCorrectionBaseSubProcessor;
import org.eclipse.jdt.internal.ui.text.correction.IInvocationContextCore;
import org.eclipse.jdt.internal.ui.text.correction.IProblemLocationCore;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.corrections.ProposalKindWrapper;
import org.eclipse.jdt.ls.core.internal.handlers.CodeActionHandler;
import org.eclipse.jdt.ls.core.internal.preferences.Preferences;
import org.eclipse.jdt.ui.text.java.correction.ASTRewriteCorrectionProposalCore;
import org.eclipse.ltk.core.refactoring.Change;

public class GetterSetterCorrectionSubProcessor
extends GetterSetterCorrectionBaseSubProcessor<ProposalKindWrapper> {
    public static boolean addGetterSetterProposal(IInvocationContextCore context, ASTNode coveringNode, IProblemLocationCore[] locations, ArrayList<ProposalKindWrapper> resultingCollections) {
        return new GetterSetterCorrectionSubProcessor().addGetterSetterProposals(context, coveringNode, locations, resultingCollections);
    }

    public static void addGetterSetterProposal(IInvocationContextCore context, IProblemLocationCore location, Collection<ProposalKindWrapper> proposals, int relevance) {
        new GetterSetterCorrectionSubProcessor().addGetterSetterProposals(context, location.getCoveringNode(context.getASTRoot()), proposals, relevance);
    }

    protected ProposalKindWrapper createNonNullMethodGetterProposal(String label, ICompilationUnit compilationUnit, ASTRewrite astRewrite, int relevance) {
        ASTRewriteCorrectionProposalCore proposal = new ASTRewriteCorrectionProposalCore(label, compilationUnit, astRewrite, relevance);
        return CodeActionHandler.wrap((ChangeCorrectionProposalCore)proposal, "quickfix");
    }

    protected ProposalKindWrapper createFieldGetterProposal(int relevance, IField field) {
        return CodeActionHandler.wrap((ChangeCorrectionProposalCore)new SelfEncapsulateFieldProposal(relevance, field), "refactor");
    }

    protected ProposalKindWrapper createMethodSetterProposal(String label, ICompilationUnit compilationUnit, ASTRewrite astRewrite, int relevance) {
        ASTRewriteCorrectionProposalCore proposal = new ASTRewriteCorrectionProposalCore(label, compilationUnit, astRewrite, relevance);
        return CodeActionHandler.wrap((ChangeCorrectionProposalCore)proposal, "quickfix");
    }

    protected ProposalKindWrapper createFieldSetterProposal(int relevance, IField field) {
        return CodeActionHandler.wrap((ChangeCorrectionProposalCore)new SelfEncapsulateFieldProposal(relevance, field), "refactor");
    }

    public static class SelfEncapsulateFieldProposal
    extends GetterSetterCorrectionBaseSubProcessor.SelfEncapsulateFieldProposalCore {
        public SelfEncapsulateFieldProposal(int relevance, IField field) {
            super(relevance, SelfEncapsulateFieldProposal.getRefactoringChange(field), field);
        }

        public static Change getRefactoringChange(IField field) {
            Preferences preferences = JavaLanguageServerPlugin.getPreferencesManager().getPreferences();
            try {
                SelfEncapsulateFieldRefactoring refactoring = GetterSetterCorrectionBaseSubProcessor.SelfEncapsulateFieldProposalCore.getChangeRefactoring((IField)field);
                refactoring.setGenerateJavadoc(preferences.isCodeGenerationTemplateGenerateComments());
                return refactoring.createChange((IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.log(e);
                return null;
            }
        }
    }
}

