/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import java.util.concurrent.ForkJoinPool;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.manipulation.ChangeCorrectionProposalCore;
import org.eclipse.jdt.core.manipulation.CoreASTProvider;
import org.eclipse.jdt.internal.ui.text.correction.IInvocationContextCore;
import org.eclipse.jdt.internal.ui.text.correction.IProblemLocationCore;
import org.eclipse.jdt.internal.ui.text.correction.ProblemLocationCore;
import org.eclipse.jdt.internal.ui.text.correction.proposals.NewAnnotationMemberProposalCore;
import org.eclipse.jdt.internal.ui.text.correction.proposals.NewMethodCorrectionProposalCore;
import org.eclipse.jdt.internal.ui.text.correction.proposals.NewVariableCorrectionProposalCore;
import org.eclipse.jdt.ls.core.internal.ChangeUtil;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.corrections.DiagnosticsHelper;
import org.eclipse.jdt.ls.core.internal.corrections.InnovationContext;
import org.eclipse.jdt.ls.core.internal.corrections.ProposalKindWrapper;
import org.eclipse.jdt.ls.core.internal.corrections.QuickFixProcessor;
import org.eclipse.jdt.ls.core.internal.corrections.RefactorProcessor;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.NewCUProposal;
import org.eclipse.jdt.ls.core.internal.handlers.CodeActionProposal;
import org.eclipse.jdt.ls.core.internal.handlers.ConfigurationHandler;
import org.eclipse.jdt.ls.core.internal.handlers.ResponseStore;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.jdt.ls.core.internal.text.correction.AssignToVariableAssistCommandProposal;
import org.eclipse.jdt.ls.core.internal.text.correction.CUCorrectionCommandProposal;
import org.eclipse.jdt.ls.core.internal.text.correction.CodeActionComparator;
import org.eclipse.jdt.ls.core.internal.text.correction.NonProjectFixProcessor;
import org.eclipse.jdt.ls.core.internal.text.correction.QuickAssistProcessor;
import org.eclipse.jdt.ls.core.internal.text.correction.RefactoringCorrectionCommandProposal;
import org.eclipse.jdt.ls.core.internal.text.correction.SourceAssistProcessor;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionContext;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class CodeActionHandler {
    public static final ResponseStore<Either<ChangeCorrectionProposalCore, CodeActionProposal>> codeActionStore = new ResponseStore(ForkJoinPool.commonPool().getParallelism());
    public static final String COMMAND_ID_APPLY_EDIT = "java.apply.workspaceEdit";
    private QuickFixProcessor quickFixProcessor;
    private RefactorProcessor refactorProcessor;
    private QuickAssistProcessor quickAssistProcessor;
    private SourceAssistProcessor sourceAssistProcessor;
    private NonProjectFixProcessor nonProjectFixProcessor;
    private PreferenceManager preferenceManager;

    public CodeActionHandler(PreferenceManager preferenceManager) {
        this.preferenceManager = preferenceManager;
        this.quickFixProcessor = new QuickFixProcessor();
        this.sourceAssistProcessor = new SourceAssistProcessor(preferenceManager);
        this.quickAssistProcessor = new QuickAssistProcessor(preferenceManager);
        this.refactorProcessor = new RefactorProcessor(preferenceManager);
        this.nonProjectFixProcessor = new NonProjectFixProcessor(preferenceManager);
    }

    public static ProposalKindWrapper wrap(ChangeCorrectionProposalCore proposal, String kind) {
        return new ProposalKindWrapper(proposal, kind);
    }

    public List<Either<Command, CodeAction>> getCodeActionCommands(CodeActionParams params, IProgressMonitor monitor) {
        CompilationUnit astRoot;
        if (monitor.isCanceled()) {
            return Collections.emptyList();
        }
        ICompilationUnit unit = JDTUtils.resolveCompilationUnit(params.getTextDocument().getUri());
        if (unit == null || monitor.isCanceled()) {
            return Collections.emptyList();
        }
        Map<String, Object> formattingOptions = ConfigurationHandler.getFormattingOptions(params.getTextDocument().getUri());
        if (formattingOptions != null && !formattingOptions.isEmpty()) {
            Object tabSizeValue = formattingOptions.get("java.format.tabSize");
            Object insertSpacesValue = formattingOptions.get("java.format.insertSpaces");
            HashMap<String, String> customOptions = new HashMap<String, String>();
            if (tabSizeValue != null) {
                try {
                    int tabSize = Integer.parseInt(String.valueOf(tabSizeValue));
                    if (tabSize > 0) {
                        customOptions.put("org.eclipse.jdt.core.formatter.tabulation.size", Integer.toString(tabSize));
                    }
                }
                catch (Exception tabSize) {
                    // empty catch block
                }
            }
            if (insertSpacesValue != null) {
                boolean insertSpaces = Boolean.parseBoolean(String.valueOf(insertSpacesValue));
                customOptions.put("org.eclipse.jdt.core.formatter.tabulation.char", insertSpaces ? "space" : "tab");
            }
            if (!customOptions.isEmpty()) {
                unit.setOptions(customOptions);
            }
        }
        if ((astRoot = CodeActionHandler.getASTRoot(unit, monitor)) == null || monitor.isCanceled()) {
            return Collections.emptyList();
        }
        IInvocationContextCore context = CodeActionHandler.getContext(unit, astRoot, params.getRange());
        List<Diagnostic> diagnostics = params.getContext().getDiagnostics().stream().filter(d -> "Java".equals(d.getSource())).collect(Collectors.toList());
        IProblemLocationCore[] locations = CodeActionHandler.getProblemLocationCores(unit, diagnostics);
        if (monitor.isCanceled()) {
            return Collections.emptyList();
        }
        ArrayList<String> codeActionKinds = new ArrayList<String>();
        if (params.getContext().getOnly() != null && !params.getContext().getOnly().isEmpty()) {
            codeActionKinds.addAll(params.getContext().getOnly());
        } else {
            List<String> defaultCodeActionKinds = Arrays.asList("quickfix", "refactor", "quickassist", "source");
            codeActionKinds.addAll(defaultCodeActionKinds);
        }
        ArrayList<Either<Command, CodeAction>> codeActions = new ArrayList<Either<Command, CodeAction>>();
        ArrayList<ProposalKindWrapper> proposals = new ArrayList<ProposalKindWrapper>();
        ChangeCorrectionProposalComparator comparator = new ChangeCorrectionProposalComparator();
        if (CodeActionHandler.containsKind(codeActionKinds, "quickfix")) {
            try {
                codeActions.addAll(this.nonProjectFixProcessor.getCorrections(params, context, locations));
                List<ProposalKindWrapper> quickfixProposals = this.quickFixProcessor.getCorrections(params, context, locations);
                this.quickFixProcessor.addAddAllMissingImportsProposal(context, quickfixProposals);
                TreeSet<ProposalKindWrapper> quickSet = new TreeSet<ProposalKindWrapper>(comparator);
                quickSet.addAll(quickfixProposals);
                proposals.addAll(quickSet);
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.logException("Problem resolving quick fix code actions", e);
            }
        }
        if (monitor.isCanceled()) {
            return Collections.emptyList();
        }
        if (CodeActionHandler.containsKind(codeActionKinds, "refactor")) {
            try {
                List<ProposalKindWrapper> refactorProposals = this.refactorProcessor.getProposals(params, context, locations);
                refactorProposals.sort(comparator);
                proposals.addAll(refactorProposals);
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.logException("Problem resolving refactor code actions", e);
            }
        }
        if (monitor.isCanceled()) {
            return Collections.emptyList();
        }
        if (CodeActionHandler.containsKind(codeActionKinds, "quickassist")) {
            try {
                List<ProposalKindWrapper> quickassistProposals = this.quickAssistProcessor.getAssists(params, context, locations);
                quickassistProposals.sort(comparator);
                proposals.addAll(quickassistProposals);
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.logException("Problem resolving quick assist code actions", e);
            }
        }
        if (monitor.isCanceled()) {
            return Collections.emptyList();
        }
        try {
            for (ProposalKindWrapper proposal : proposals) {
                Optional<Either<Command, CodeAction>> codeActionFromProposal = this.getCodeActionFromProposal(params.getTextDocument().getUri(), proposal, params.getContext());
                if (!codeActionFromProposal.isPresent() || codeActions.contains(codeActionFromProposal.get())) continue;
                codeActions.add(codeActionFromProposal.get());
            }
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.logException("Problem converting proposal to code actions", e);
        }
        if (monitor.isCanceled()) {
            return Collections.emptyList();
        }
        if (CodeActionHandler.containsKind(codeActionKinds, "source")) {
            codeActions.addAll(this.sourceAssistProcessor.getSourceActionCommands(params, context, locations, monitor));
        }
        if (monitor.isCanceled()) {
            return Collections.emptyList();
        }
        codeActions.sort(new CodeActionComparator());
        this.populateDataFields(codeActions);
        return codeActions;
    }

    private void populateDataFields(List<Either<Command, CodeAction>> codeActions) {
        ResponseStore.ResponseItem<Either<ChangeCorrectionProposalCore, CodeActionProposal>> response = codeActionStore.createResponse();
        ArrayList proposals = new ArrayList();
        codeActions.forEach(action -> {
            if (action.isRight()) {
                void codeActionData;
                Object originalProposal;
                Either proposal = null;
                Object originalData = ((CodeAction)action.getRight()).getData();
                Object object = originalData;
                if (!(object instanceof CodeActionData)) {
                    ((CodeAction)action.getRight()).setData(null);
                    return;
                }
                CodeActionData codeActionData2 = (CodeActionData)object;
                CodeActionData cfr_ignored_0 = (CodeActionData)object;
                Object object2 = originalProposal = codeActionData.getProposal();
                if (object2 instanceof ChangeCorrectionProposalCore) {
                    void changeCorrectionProposal;
                    ChangeCorrectionProposalCore changeCorrectionProposalCore = (ChangeCorrectionProposalCore)object2;
                    ChangeCorrectionProposalCore cfr_ignored_1 = (ChangeCorrectionProposalCore)object2;
                    proposal = Either.forLeft((Object)changeCorrectionProposal);
                } else {
                    void codeActionProposal;
                    Object object3 = originalProposal;
                    if (!(object3 instanceof CodeActionProposal)) {
                        ((CodeAction)action.getRight()).setData(null);
                        return;
                    }
                    CodeActionProposal codeActionProposal2 = (CodeActionProposal)object3;
                    CodeActionProposal cfr_ignored_2 = (CodeActionProposal)object3;
                    proposal = Either.forRight((Object)codeActionProposal);
                }
                HashMap<String, String> data = new HashMap<String, String>();
                data.put("rid", String.valueOf(response.getId()));
                data.put("pid", String.valueOf(proposals.size()));
                ((CodeAction)action.getRight()).setData(data);
                proposals.add(proposal);
            }
        });
        if (!proposals.isEmpty()) {
            response.setProposals(proposals);
            codeActionStore.store(response);
        }
    }

    /*
     * WARNING - void declaration
     */
    private Optional<Either<Command, CodeAction>> getCodeActionFromProposal(String uri, ProposalKindWrapper pk, CodeActionContext context) throws CoreException {
        ChangeCorrectionProposalCore proposal = pk.getProposal();
        String name = proposal.getName();
        Command command = null;
        ChangeCorrectionProposalCore changeCorrectionProposalCore = proposal;
        if (changeCorrectionProposalCore instanceof CUCorrectionCommandProposal) {
            void commandProposal;
            CUCorrectionCommandProposal cUCorrectionCommandProposal = (CUCorrectionCommandProposal)changeCorrectionProposalCore;
            CUCorrectionCommandProposal cfr_ignored_0 = (CUCorrectionCommandProposal)changeCorrectionProposalCore;
            command = new Command(name, commandProposal.getCommand(), commandProposal.getCommandArguments());
        } else {
            ChangeCorrectionProposalCore changeCorrectionProposalCore2 = proposal;
            if (changeCorrectionProposalCore2 instanceof RefactoringCorrectionCommandProposal) {
                void commandProposal;
                RefactoringCorrectionCommandProposal refactoringCorrectionCommandProposal = (RefactoringCorrectionCommandProposal)changeCorrectionProposalCore2;
                RefactoringCorrectionCommandProposal cfr_ignored_1 = (RefactoringCorrectionCommandProposal)changeCorrectionProposalCore2;
                command = new Command(name, commandProposal.getCommand(), commandProposal.getCommandArguments());
            } else {
                ChangeCorrectionProposalCore changeCorrectionProposalCore3 = proposal;
                if (changeCorrectionProposalCore3 instanceof AssignToVariableAssistCommandProposal) {
                    void commandProposal;
                    AssignToVariableAssistCommandProposal assignToVariableAssistCommandProposal = (AssignToVariableAssistCommandProposal)changeCorrectionProposalCore3;
                    AssignToVariableAssistCommandProposal cfr_ignored_2 = (AssignToVariableAssistCommandProposal)changeCorrectionProposalCore3;
                    command = new Command(name, commandProposal.getCommand(), commandProposal.getCommandArguments());
                } else if (!this.preferenceManager.getClientPreferences().isResolveCodeActionSupported()) {
                    WorkspaceEdit edit = ChangeUtil.convertToWorkspaceEdit(proposal.getChange());
                    if (!ChangeUtil.hasChanges(edit)) {
                        return Optional.empty();
                    }
                    command = new Command(name, COMMAND_ID_APPLY_EDIT, Collections.singletonList(edit));
                }
            }
        }
        if (this.preferenceManager.getClientPreferences().isSupportedCodeActionKind(pk.getKind())) {
            CodeAction codeAction = new CodeAction(name);
            codeAction.setKind(pk.getKind());
            if (command == null) {
                if (!this.preferenceManager.getPreferences().isValidateAllOpenBuffersOnChanges() && (proposal instanceof NewCUProposal || proposal instanceof NewMethodCorrectionProposalCore || proposal instanceof NewAnnotationMemberProposalCore || proposal instanceof NewVariableCorrectionProposalCore)) {
                    codeAction.setCommand(new Command("refresh Diagnostics", "java.project.refreshDiagnostics", Arrays.asList(uri, "thisFile", false, true)));
                }
                codeAction.setData((Object)new CodeActionData(proposal, -proposal.getRelevance()));
            } else {
                codeAction.setCommand(command);
                codeAction.setData((Object)new CodeActionData(null, -proposal.getRelevance()));
            }
            if (pk.getKind() != "quickassist") {
                codeAction.setDiagnostics(context.getDiagnostics());
            }
            return Optional.of(Either.forRight((Object)codeAction));
        }
        return Optional.ofNullable(command != null ? Either.forLeft((Object)command) : null);
    }

    /*
     * WARNING - void declaration
     */
    public static IProblemLocationCore[] getProblemLocationCores(ICompilationUnit unit, List<Diagnostic> diagnostics) {
        IProblemLocationCore[] locations = new IProblemLocationCore[diagnostics.size()];
        int i = 0;
        while (i < diagnostics.size()) {
            Object object;
            Diagnostic diagnostic = diagnostics.get(i);
            int start = DiagnosticsHelper.getStartOffset(unit, diagnostic.getRange());
            int end = DiagnosticsHelper.getEndOffset(unit, diagnostic.getRange());
            boolean isError = diagnostic.getSeverity() == DiagnosticSeverity.Error;
            int problemId = CodeActionHandler.getProblemId(diagnostic);
            ArrayList<Object> arguments = new ArrayList<Object>();
            Object object2 = diagnostic.getData();
            if (object2 instanceof JsonArray) {
                void data;
                JsonArray cfr_ignored_0 = (JsonArray)object2;
                JsonArray cfr_ignored_1 = (JsonArray)object2;
                object = data.iterator();
                while (object.hasNext()) {
                    JsonElement e = (JsonElement)object.next();
                    arguments.add(e.getAsString());
                }
            }
            if ((object = diagnostic.getData()) instanceof String[]) {
                void data;
                JsonElement cfr_ignored_2 = (JsonElement)object;
                String[] cfr_ignored_3 = (String[])object;
                void var17_17 = data;
                int n = ((void)var17_17).length;
                int n2 = 0;
                while (n2 < n) {
                    void s = var17_17[n2];
                    arguments.add(s);
                    ++n2;
                }
            }
            locations[i] = new ProblemLocationCore(start, end - start, problemId, arguments.toArray(new String[0]), isError, "org.eclipse.jdt.core.problem");
            ++i;
        }
        return locations;
    }

    private static int getProblemId(Diagnostic diagnostic) {
        int $ = 0;
        try {
            Either code = diagnostic.getCode();
            if (code != null) {
                if (code.getLeft() != null) {
                    $ = Integer.parseInt((String)code.getLeft());
                } else if (code.getRight() != null) {
                    $ = (Integer)code.getRight();
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return $;
    }

    public static CompilationUnit getASTRoot(ICompilationUnit unit) {
        return CodeActionHandler.getASTRoot(unit, (IProgressMonitor)new NullProgressMonitor());
    }

    public static CompilationUnit getASTRoot(ICompilationUnit unit, IProgressMonitor monitor) {
        return CoreASTProvider.getInstance().getAST((ITypeRoot)unit, CoreASTProvider.WAIT_YES, monitor);
    }

    public static IInvocationContextCore getContext(ICompilationUnit unit, CompilationUnit astRoot, Range range) {
        int start = DiagnosticsHelper.getStartOffset(unit, range);
        int end = DiagnosticsHelper.getEndOffset(unit, range);
        InnovationContext context = new InnovationContext(unit, start, end - start);
        context.setASTRoot(astRoot);
        return context;
    }

    private static boolean containsKind(List<String> codeActionKinds, String baseKind) {
        return codeActionKinds.stream().anyMatch(kind -> kind.startsWith(baseKind));
    }

    private static class ChangeCorrectionProposalComparator
    implements Comparator<ProposalKindWrapper> {
        private ChangeCorrectionProposalComparator() {
        }

        @Override
        public int compare(ProposalKindWrapper p1, ProposalKindWrapper p2) {
            String k1 = p1.getKind();
            String k2 = p2.getKind();
            if (!(StringUtils.isBlank((CharSequence)k1) || StringUtils.isBlank((CharSequence)k2) || k1.equals(k2))) {
                return k1.compareTo(k2);
            }
            int r1 = p1.getProposal().getRelevance();
            int r2 = p2.getProposal().getRelevance();
            int relevanceDif = r2 - r1;
            if (relevanceDif != 0) {
                return relevanceDif;
            }
            return p1.getProposal().getName().compareToIgnoreCase(p2.getProposal().getName());
        }
    }

    public static class CodeActionData {
        private final Object proposal;
        private final int priority;

        public CodeActionData(Object proposal) {
            this.proposal = proposal;
            this.priority = CodeActionComparator.LOWEST_PRIORITY;
        }

        public CodeActionData(Object proposal, int priority) {
            this.proposal = proposal;
            this.priority = priority;
        }

        public Object getProposal() {
            return this.proposal;
        }

        public int getPriority() {
            return this.priority;
        }
    }
}

