/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenamePackageProcessor;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IReorgDestination;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgDestinationFactory;
import org.eclipse.jdt.ls.core.internal.ChangeUtil;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.ResourceUtils;
import org.eclipse.jdt.ls.core.internal.commands.BuildPathCommand;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.rename.RenameSupport;
import org.eclipse.jdt.ls.core.internal.handlers.MoveHandler;
import org.eclipse.lsp4j.FileRename;
import org.eclipse.lsp4j.RenameFilesParams;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CheckConditionsOperation;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringTickProvider;
import org.eclipse.ltk.core.refactoring.participants.RenameRefactoring;
import org.eclipse.ltk.internal.core.refactoring.NotCancelableProgressMonitor;

public class FileEventHandler {
    public static WorkspaceEdit handleWillRenameFiles(RenameFilesParams params, IProgressMonitor monitor) {
        WorkspaceEdit edit;
        List files = params.getFiles();
        if (files == null || files.isEmpty()) {
            return null;
        }
        FileRename[] renameFiles = new FileRename[]{};
        FileRename[] renameFolders = new FileRename[]{};
        FileRename[] moveFiles = new FileRename[]{};
        if (files.size() == 1) {
            FileRename renameEvent = (FileRename)files.get(0);
            if (FileEventHandler.isFileNameRenameEvent(renameEvent)) {
                renameFiles = new FileRename[]{renameEvent};
            } else if (FileEventHandler.isFolderRenameEvent(renameEvent)) {
                renameFolders = new FileRename[]{renameEvent};
            } else if (FileEventHandler.isMoveEvent(renameEvent)) {
                moveFiles = new FileRename[]{renameEvent};
            }
        } else {
            moveFiles = (FileRename[])files.stream().filter(event -> FileEventHandler.isMoveEvent(event)).toArray(FileRename[]::new);
        }
        if (renameFiles.length == 0 && renameFolders.length == 0 && moveFiles.length == 0) {
            return null;
        }
        BuildPathCommand.SourcePath[] sourcePaths = FileEventHandler.getSourcePaths();
        if (sourcePaths == null || sourcePaths.length == 0) {
            return null;
        }
        WorkspaceEdit root = null;
        SubMonitor submonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Computing rename updates...", (int)(renameFiles.length + renameFolders.length + moveFiles.length));
        if (renameFiles.length > 0) {
            edit = FileEventHandler.computeFileRenameEdit(renameFiles, (IProgressMonitor)submonitor.split(renameFiles.length));
            root = ChangeUtil.mergeChanges(root, edit, true);
        }
        if (renameFolders.length > 0) {
            edit = FileEventHandler.computePackageRenameEdit(renameFolders, sourcePaths, (IProgressMonitor)submonitor.split(renameFolders.length));
            root = ChangeUtil.mergeChanges(root, edit, true);
        }
        if (moveFiles.length > 0) {
            edit = FileEventHandler.computeMoveEdit(moveFiles, sourcePaths, (IProgressMonitor)submonitor.split(moveFiles.length));
            root = ChangeUtil.mergeChanges(root, edit, true);
        }
        submonitor.done();
        return ChangeUtil.hasChanges(root) ? root : null;
    }

    private static WorkspaceEdit computeFileRenameEdit(FileRename[] renameEvents, IProgressMonitor monitor) {
        SubMonitor submonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Computing file rename updates...", (int)(100 * renameEvents.length));
        WorkspaceEdit root = null;
        FileRename[] fileRenameArray = renameEvents;
        int n = renameEvents.length;
        int n2 = 0;
        while (n2 < n) {
            block8: {
                SubMonitor splitedMonitor;
                block7: {
                    ICompilationUnit unit;
                    String newUri;
                    String oldUri;
                    block6: {
                        FileRename event = fileRenameArray[n2];
                        oldUri = event.getOldUri();
                        newUri = event.getNewUri();
                        unit = JDTUtils.resolveCompilationUnit(oldUri);
                        splitedMonitor = submonitor.split(100);
                        if (unit != null && unit.exists()) break block6;
                        JavaLanguageServerPlugin.logError("Failed to compute the file rename edit because the file '" + oldUri + "' doesn't exist.");
                        splitedMonitor.done();
                        break block8;
                    }
                    try {
                        try {
                            if (unit == null) break block7;
                            String oldPrimaryType = FileEventHandler.getPrimaryTypeName(oldUri);
                            String newPrimaryType = FileEventHandler.getPrimaryTypeName(newUri);
                            if (unit.getType(newPrimaryType).exists() || !unit.getType(oldPrimaryType).exists()) break block7;
                            WorkspaceEdit edit = FileEventHandler.getRenameEdit((IJavaElement)unit.getType(oldPrimaryType), newPrimaryType, (IProgressMonitor)splitedMonitor);
                            root = ChangeUtil.mergeChanges(root, edit, true);
                        }
                        catch (CoreException e) {
                            JavaLanguageServerPlugin.logException("Computing the file rename edit: ", e);
                            splitedMonitor.done();
                        }
                    }
                    catch (Throwable throwable) {
                        splitedMonitor.done();
                        throw throwable;
                    }
                }
                splitedMonitor.done();
            }
            ++n2;
        }
        submonitor.done();
        return root;
    }

    private static WorkspaceEdit computePackageRenameEdit(FileRename[] renameEvents, BuildPathCommand.SourcePath[] sourcePaths, IProgressMonitor monitor) {
        WorkspaceEdit[] root = new WorkspaceEdit[1];
        SubMonitor submonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Computing package rename updates...", (int)(100 * renameEvents.length));
        FileRename[] fileRenameArray = renameEvents;
        int n = renameEvents.length;
        int n2 = 0;
        while (n2 < n) {
            block9: {
                SubMonitor renameMonitor;
                block7: {
                    String newPackageName;
                    IPackageFragment oldPackageFragment;
                    block8: {
                        FileRename event = fileRenameArray[n2];
                        IPath oldLocation = ResourceUtils.filePathFromURI(event.getOldUri());
                        IPath newLocation = ResourceUtils.filePathFromURI(event.getNewUri());
                        oldPackageFragment = FileEventHandler.resolvePackageFragment(oldLocation, sourcePaths);
                        renameMonitor = submonitor.split(100);
                        if (oldPackageFragment == null || oldPackageFragment.isDefaultPackage() || oldPackageFragment.getResource() == null) break block7;
                        newPackageName = FileEventHandler.resolvePackageName(newLocation, sourcePaths);
                        if (newPackageName != null) break block8;
                        renameMonitor.done();
                        break block9;
                    }
                    try {
                        try {
                            oldPackageFragment.getResource().refreshLocal(2, null);
                            if (oldPackageFragment.exists()) {
                                ResourcesPlugin.getWorkspace().run(pm -> {
                                    WorkspaceEdit edit = FileEventHandler.getRenameEdit((IJavaElement)oldPackageFragment, newPackageName, pm);
                                    workspaceEditArray[0] = ChangeUtil.mergeChanges(root[0], edit, true);
                                }, oldPackageFragment.getSchedulingRule(), 0, (IProgressMonitor)renameMonitor);
                            }
                        }
                        catch (CoreException e) {
                            JavaLanguageServerPlugin.logException("Failed to compute the package rename update", e);
                            renameMonitor.done();
                            break block9;
                        }
                    }
                    catch (Throwable throwable) {
                        renameMonitor.done();
                        throw throwable;
                    }
                }
                renameMonitor.done();
            }
            ++n2;
        }
        submonitor.done();
        return ChangeUtil.hasChanges(root[0]) ? root[0] : null;
    }

    /*
     * Unable to fully structure code
     */
    private static WorkspaceEdit computeMoveEdit(FileRename[] moveEvents, BuildPathCommand.SourcePath[] sourcePaths, IProgressMonitor monitor) {
        block22: {
            newPaths = (IPath[])Stream.of(moveEvents).map((Function<FileRename, IPath>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$3(org.eclipse.lsp4j.FileRename ), (Lorg/eclipse/lsp4j/FileRename;)Lorg/eclipse/core/runtime/IPath;)()).toArray((IntFunction<IPath[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$4(int ), (I)[Lorg/eclipse/core/runtime/IPath;)());
            destinationPath = ResourceUtils.getLongestCommonPath(newPaths);
            if (destinationPath == null) {
                return null;
            }
            var8_5 = moveEvents;
            var7_6 = moveEvents.length;
            var6_8 = 0;
            while (var6_8 < var7_6) {
                event = var8_5[var6_8];
                oldPath = ResourceUtils.filePathFromURI(event.getOldUri());
                expectedNewPath = destinationPath.append(oldPath.lastSegment());
                if (!Objects.equals(expectedNewPath, actualNewPath = ResourceUtils.filePathFromURI(event.getNewUri()))) {
                    JavaLanguageServerPlugin.logError("Failed to compute move refactoring because the files are not moving to the same destination " + destinationPath.toOSString());
                    return null;
                }
                ++var6_8;
            }
            destinationPackage = FileEventHandler.resolvePackageFragment(destinationPath, sourcePaths);
            if (destinationPackage == null) {
                return null;
            }
            cus = (ICompilationUnit[])Stream.of(moveEvents).filter((Predicate<FileRename>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$5(org.eclipse.lsp4j.FileRename ), (Lorg/eclipse/lsp4j/FileRename;)Z)()).map((Function<FileRename, ICompilationUnit>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$6(org.eclipse.lsp4j.FileRename ), (Lorg/eclipse/lsp4j/FileRename;)Lorg/eclipse/jdt/core/ICompilationUnit;)()).filter((Predicate<ICompilationUnit>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$7(org.eclipse.jdt.core.ICompilationUnit ), (Lorg/eclipse/jdt/core/ICompilationUnit;)Z)()).toArray((IntFunction<ICompilationUnit[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$8(int ), (I)[Lorg/eclipse/jdt/core/ICompilationUnit;)());
            nonClasspathCus = new ArrayList<ICompilationUnit>();
            var11_19 = cus;
            var10_17 = cus.length;
            oldPath = 0;
            while (oldPath < var10_17) {
                unit = var11_19[oldPath];
                if (!unit.getJavaProject().isOnClasspath((IJavaElement)unit)) {
                    nonClasspathCus.add(unit);
                }
                ++oldPath;
            }
            root = new WorkspaceEdit[1];
            if (cus.length > 0) {
                block21: {
                    try {
                        try {
                            for (ICompilationUnit cu : nonClasspathCus) {
                                cu.becomeWorkingCopy(monitor);
                            }
                            packageDestination = ReorgDestinationFactory.createDestination((Object)destinationPackage);
                            ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)LambdaMetafactory.metafactory(null, null, null, (Lorg/eclipse/core/runtime/IProgressMonitor;)V, lambda$9(org.eclipse.lsp4j.WorkspaceEdit[] org.eclipse.jdt.core.ICompilationUnit[] org.eclipse.jdt.internal.corext.refactoring.reorg.IReorgDestination org.eclipse.core.runtime.IProgressMonitor ), (Lorg/eclipse/core/runtime/IProgressMonitor;)V)((WorkspaceEdit[])root, (ICompilationUnit[])cus, (IReorgDestination)packageDestination), monitor);
                            break block21;
                        }
                        catch (CoreException e) {
                            JavaLanguageServerPlugin.logException("Failed to compute the move update", e);
                            ** for (cu : nonClasspathCus)
                        }
                    }
                    catch (Throwable var11_20) {
                        ** for (cu : nonClasspathCus)
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            cu.discardWorkingCopy();
                        }
                        catch (JavaModelException var14_27) {
                            // empty catch block
                        }
                        continue;
lbl51:
                        // 1 sources

                        break block22;
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            cu.discardWorkingCopy();
                        }
                        catch (JavaModelException var14_28) {
                            // empty catch block
                        }
                        continue;
                    }
lbl60:
                    // 1 sources

                    throw var11_20;
                }
                for (ICompilationUnit cu : nonClasspathCus) {
                    try {
                        cu.discardWorkingCopy();
                    }
                    catch (JavaModelException var14_29) {
                        // empty catch block
                    }
                }
            }
        }
        return ChangeUtil.hasChanges(root[0]) != false ? root[0] : null;
    }

    private static String resolvePackageName(IPath javaElementLocation, BuildPathCommand.SourcePath[] sourcePaths) {
        return (String)FileEventHandler.resolvePackage(javaElementLocation, sourcePaths, false);
    }

    private static IPackageFragment resolvePackageFragment(IPath javaElementLocation, BuildPathCommand.SourcePath[] sourcePaths) {
        return (IPackageFragment)FileEventHandler.resolvePackage(javaElementLocation, sourcePaths, true);
    }

    private static Object resolvePackage(IPath javaElementLocation, BuildPathCommand.SourcePath[] sourcePaths, boolean returnModel) {
        BuildPathCommand.SourcePath[] sourcePathArray = sourcePaths;
        int n = sourcePaths.length;
        int n2 = 0;
        while (n2 < n) {
            BuildPathCommand.SourcePath sourcePath = sourcePathArray[n2];
            IPath sourceLocation = Path.fromOSString((String)sourcePath.path);
            IPath sourceEntry = Path.fromOSString((String)sourcePath.classpathEntry);
            if (sourceLocation.isPrefixOf(javaElementLocation)) {
                IPackageFragmentRoot packageRoot;
                block8: {
                    IJavaProject javaProject;
                    block7: {
                        try {
                            javaProject = ProjectUtils.getJavaProject(sourcePath.projectName);
                            if (javaProject != null) break block7;
                            return null;
                        }
                        catch (CoreException e) {
                            JavaLanguageServerPlugin.logException("Failed to resolve the package fragment", e);
                            return null;
                        }
                    }
                    packageRoot = javaProject.findPackageFragmentRoot(sourceEntry);
                    if (packageRoot != null) break block8;
                    return null;
                }
                String packageName = String.join((CharSequence)".", javaElementLocation.makeRelativeTo(sourceLocation).segments());
                if (returnModel) {
                    return packageRoot.getPackageFragment(packageName);
                }
                return packageName;
            }
            ++n2;
        }
        return null;
    }

    private static BuildPathCommand.SourcePath[] getSourcePaths() {
        BuildPathCommand.SourcePath[] sourcePaths = new BuildPathCommand.SourcePath[]{};
        BuildPathCommand.ListCommandResult result = (BuildPathCommand.ListCommandResult)BuildPathCommand.listSourcePaths();
        if (result.status && result.data != null && result.data.length > 0) {
            sourcePaths = result.data;
        }
        Arrays.sort(sourcePaths, (a, b) -> b.path.length() - a.path.length());
        return sourcePaths;
    }

    private static boolean isFileNameRenameEvent(FileRename event) {
        IPath oldPath = ResourceUtils.filePathFromURI(event.getOldUri());
        IPath newPath = ResourceUtils.filePathFromURI(event.getNewUri());
        if (oldPath == null || newPath == null) {
            return false;
        }
        return (oldPath.toFile().isFile() || newPath.toFile().isFile()) && oldPath.lastSegment().endsWith(".java") && newPath.lastSegment().endsWith(".java") && Objects.equals(oldPath.removeLastSegments(1), newPath.removeLastSegments(1));
    }

    private static boolean isFolderRenameEvent(FileRename event) {
        IPath oldPath = ResourceUtils.filePathFromURI(event.getOldUri());
        IPath newPath = ResourceUtils.filePathFromURI(event.getNewUri());
        if (oldPath == null || newPath == null) {
            return false;
        }
        return oldPath.toFile().isDirectory() || newPath.toFile().isDirectory();
    }

    private static boolean isMoveEvent(FileRename event) {
        IPath oldPath = ResourceUtils.filePathFromURI(event.getOldUri());
        IPath newPath = ResourceUtils.filePathFromURI(event.getNewUri());
        if (oldPath == null || newPath == null) {
            return false;
        }
        return oldPath.toFile().isFile() && oldPath.lastSegment().endsWith(".java") && Objects.equals(oldPath.lastSegment(), newPath.lastSegment());
    }

    private static String getPrimaryTypeName(String uri) {
        String fileName = ResourceUtils.filePathFromURI(uri).lastSegment();
        int idx = fileName.lastIndexOf(".");
        if (idx >= 0) {
            return fileName.substring(0, idx);
        }
        return fileName;
    }

    private static WorkspaceEdit getRenameEdit(IJavaElement targetElement, String newName, IProgressMonitor monitor) throws CoreException {
        RenameSupport renameSupport = RenameSupport.create(targetElement, newName, 1);
        if (renameSupport == null) {
            return null;
        }
        if (targetElement instanceof IPackageFragment) {
            ((RenamePackageProcessor)renameSupport.getJavaRenameProcessor()).setRenameSubpackages(true);
        }
        RenameRefactoring renameRefactoring = renameSupport.getRenameRefactoring();
        RefactoringTickProvider rtp = renameRefactoring.getRefactoringTickProvider();
        SubMonitor submonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Creating rename changes...", (int)rtp.getAllTicks());
        CheckConditionsOperation checkConditionOperation = new CheckConditionsOperation((Refactoring)renameRefactoring, 6);
        checkConditionOperation.run((IProgressMonitor)submonitor.split(rtp.getCheckAllConditionsTicks()));
        if (checkConditionOperation.getStatus().getSeverity() >= 4) {
            JavaLanguageServerPlugin.logError(checkConditionOperation.getStatus().getMessageMatchingSeverity(3));
        }
        Change change = renameRefactoring.createChange((IProgressMonitor)submonitor.split(rtp.getCreateChangeTicks()));
        change.initializeValidationData((IProgressMonitor)new NotCancelableProgressMonitor((IProgressMonitor)submonitor.split(rtp.getInitializeChangeTicks())));
        return ChangeUtil.convertToWorkspaceEdit(change);
    }

    private static /* synthetic */ IPath lambda$3(FileRename event) {
        return ResourceUtils.filePathFromURI(event.getNewUri());
    }

    private static /* synthetic */ IPath[] lambda$4(int n) {
        return new IPath[n];
    }

    private static /* synthetic */ boolean lambda$5(FileRename event) {
        IPath oldPath = ResourceUtils.filePathFromURI(event.getOldUri());
        return oldPath != null && oldPath.toFile().isFile();
    }

    private static /* synthetic */ ICompilationUnit lambda$6(FileRename event) {
        return JDTUtils.resolveCompilationUnit(event.getOldUri());
    }

    private static /* synthetic */ boolean lambda$7(ICompilationUnit cu) {
        return cu != null && cu.getJavaProject() != null;
    }

    private static /* synthetic */ ICompilationUnit[] lambda$8(int n) {
        return new ICompilationUnit[n];
    }

    private static /* synthetic */ void lambda$9(WorkspaceEdit[] workspaceEditArray, ICompilationUnit[] iCompilationUnitArray, IReorgDestination iReorgDestination, IProgressMonitor pm) throws CoreException {
        workspaceEditArray[0] = MoveHandler.move(new IResource[0], (IJavaElement[])iCompilationUnitArray, iReorgDestination, true, pm);
    }
}

