/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.ui.fix.AbstractCleanUp;
import org.eclipse.jdt.internal.ui.fix.IMultiFix;
import org.eclipse.jdt.internal.ui.text.correction.IProblemLocationCore;
import org.eclipse.jdt.internal.ui.text.correction.ProblemLocation;
import org.eclipse.jdt.ui.cleanup.CleanUpContext;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;

public abstract class AbstractMultiFix
extends AbstractCleanUp
implements IMultiFix {
    protected AbstractMultiFix() {
    }

    protected AbstractMultiFix(Map<String, String> settings) {
        super(settings);
    }

    @Override
    public final ICleanUpFix createFix(CleanUpContext context) throws CoreException {
        CompilationUnit unit = context.getAST();
        if (unit == null) {
            return null;
        }
        if (context instanceof IMultiFix.MultiFixContext) {
            return this.createFix(unit, ((IMultiFix.MultiFixContext)context).getProblemLocations());
        }
        return this.createFix(unit);
    }

    protected abstract ICleanUpFix createFix(CompilationUnit var1) throws CoreException;

    protected abstract ICleanUpFix createFix(CompilationUnit var1, IProblemLocationCore[] var2) throws CoreException;

    @Override
    public int computeNumberOfFixes(CompilationUnit compilationUnit) {
        return -1;
    }

    protected static int getNumberOfProblems(IProblem[] problems, int problemId) {
        int result = 0;
        IProblem[] iProblemArray = problems;
        int n = problems.length;
        int n2 = 0;
        while (n2 < n) {
            IProblem problem = iProblemArray[n2];
            if (problem.getID() == problemId) {
                ++result;
            }
            ++n2;
        }
        return result;
    }

    protected static IProblemLocationCore[] convertProblems(IProblem[] problems) {
        IProblemLocationCore[] result = new IProblemLocationCore[problems.length];
        int i = 0;
        while (i < problems.length) {
            result[i] = new ProblemLocation(problems[i]);
            ++i;
        }
        return result;
    }

    protected static IProblemLocationCore[] filter(IProblemLocationCore[] problems, int[] problemIds) {
        ArrayList<IProblemLocationCore> result = new ArrayList<IProblemLocationCore>();
        IProblemLocationCore[] iProblemLocationCoreArray = problems;
        int n = problems.length;
        int n2 = 0;
        while (n2 < n) {
            IProblemLocationCore problem = iProblemLocationCoreArray[n2];
            if (AbstractMultiFix.contains(problemIds, problem.getProblemId()) && !AbstractMultiFix.contains(result, problem)) {
                result.add(problem);
            }
            ++n2;
        }
        return result.toArray(new IProblemLocationCore[result.size()]);
    }

    private static boolean contains(ArrayList<IProblemLocationCore> problems, IProblemLocationCore problem) {
        for (IProblemLocationCore existing : problems) {
            if (existing.getProblemId() != problem.getProblemId() || existing.getOffset() != problem.getOffset() || existing.getLength() != problem.getLength()) continue;
            return true;
        }
        return false;
    }

    private static boolean contains(int[] ids, int id) {
        int[] nArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            int id2 = nArray[n2];
            if (id2 == id) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

