/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.launch;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.buildship.core.internal.configuration.BaseRunConfiguration;
import org.eclipse.buildship.core.internal.console.ProcessDescription;
import org.eclipse.buildship.core.internal.gradle.GradleProgressAttributes;
import org.eclipse.buildship.core.internal.launch.BuildExecutionParticipants;
import org.eclipse.buildship.core.internal.launch.DefaultExecuteLaunchRequestEvent;
import org.eclipse.buildship.core.internal.operation.ToolingApiJob;
import org.eclipse.buildship.core.internal.workspace.InternalGradleBuild;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.gradle.tooling.CancellationTokenSource;
import org.gradle.tooling.LongRunningOperation;

public abstract class BaseLaunchRequestJob<T extends LongRunningOperation>
extends ToolingApiJob<Void> {
    protected BaseLaunchRequestJob(String name) {
        super(name);
    }

    @Override
    public Void runInToolingApi(CancellationTokenSource tokenSource, IProgressMonitor monitor) throws Exception {
        this.executeLaunch(tokenSource, monitor);
        return null;
    }

    protected final void executeLaunch(CancellationTokenSource tokenSource, IProgressMonitor monitor) throws Exception {
        BuildExecutionParticipants.activateParticipantPlugins();
        monitor.beginTask(this.getName(), -1);
        ProcessDescription processDescription = this.createProcessDescription();
        BaseRunConfiguration runConfig = this.getRunConfig();
        InternalGradleBuild gradleBuild = CorePlugin.internalGradleWorkspace().getGradleBuild(runConfig.getProjectConfiguration().getBuildConfiguration());
        GradleProgressAttributes attributes = GradleProgressAttributes.builder(tokenSource, monitor).forDedicatedProcess(processDescription).withFullProgress().build();
        T launcher = this.createLaunch(gradleBuild, attributes, processDescription);
        this.writeExtraConfigInfo(attributes);
        DefaultExecuteLaunchRequestEvent event = new DefaultExecuteLaunchRequestEvent(processDescription, (LongRunningOperation)launcher);
        CorePlugin.listenerRegistry().dispatch(event);
        this.executeLaunch(launcher);
    }

    protected abstract BaseRunConfiguration getRunConfig();

    protected abstract ProcessDescription createProcessDescription();

    protected abstract T createLaunch(InternalGradleBuild var1, GradleProgressAttributes var2, ProcessDescription var3);

    protected abstract void executeLaunch(T var1);

    protected abstract void writeExtraConfigInfo(GradleProgressAttributes var1);

    protected static abstract class BaseProcessDescription
    implements ProcessDescription {
        private final String name;
        private final Job job;
        private final BaseRunConfiguration runConfig;

        protected BaseProcessDescription(String name, Job job, BaseRunConfiguration runConfig) {
            this.name = (String)Preconditions.checkNotNull((Object)name);
            this.job = (Job)Preconditions.checkNotNull((Object)job);
            this.runConfig = (BaseRunConfiguration)Preconditions.checkNotNull((Object)runConfig);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Job getJob() {
            return this.job;
        }

        @Override
        public BaseRunConfiguration getRunConfig() {
            return this.runConfig;
        }

        public boolean equals(Object obj) {
            if (obj instanceof BaseProcessDescription) {
                BaseProcessDescription that = (BaseProcessDescription)obj;
                return Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.job, (Object)that.job) && Objects.equal((Object)this.runConfig, (Object)that.runConfig);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.name, this.job, this.runConfig});
        }
    }
}

