/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corrections.proposals;

import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.manipulation.CUCorrectionProposalCore;
import org.eclipse.jdt.core.manipulation.ChangeCorrectionProposalCore;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.fix.IProposableFix;
import org.eclipse.jdt.internal.corext.fix.UnusedCodeFixCore;
import org.eclipse.jdt.internal.corext.refactoring.changes.RenameCompilationUnitChange;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.fix.UnusedCodeCleanUp;
import org.eclipse.jdt.internal.ui.text.correction.ReorgCorrectionsBaseSubProcessor;
import org.eclipse.jdt.internal.ui.text.correction.UnresolvedElementsBaseSubProcessor;
import org.eclipse.jdt.internal.ui.text.correction.proposals.CorrectMainTypeNameProposalCore;
import org.eclipse.jdt.internal.ui.text.correction.proposals.CorrectPackageDeclarationProposalCore;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.corrections.CorrectionMessages;
import org.eclipse.jdt.ls.core.internal.corrections.ProposalKindWrapper;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.UnresolvedElementsSubProcessor;
import org.eclipse.jdt.ls.core.internal.handlers.CodeActionHandler;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.TextChange;

public class ReorgCorrectionsSubProcessor
extends ReorgCorrectionsBaseSubProcessor<ProposalKindWrapper> {
    public static void getWrongTypeNameProposals(IInvocationContext context, IProblemLocation problem, Collection<ProposalKindWrapper> proposals) {
        new ReorgCorrectionsSubProcessor().addWrongTypeNameProposals(context, problem, proposals);
    }

    public static void getWrongPackageDeclNameProposals(IInvocationContext context, IProblemLocation problem, Collection<ProposalKindWrapper> proposals) throws CoreException {
        new ReorgCorrectionsSubProcessor().addWrongPackageDeclNameProposals(context, problem, proposals);
    }

    public static void removeImportStatementProposals(IInvocationContext context, IProblemLocation problem, Collection<ProposalKindWrapper> proposals) throws CoreException {
        new ReorgCorrectionsSubProcessor().addRemoveImportStatementProposals(context, problem, proposals);
    }

    public ProposalKindWrapper createRenameCUProposal(String label, RenameCompilationUnitChange change, int relevance) {
        ChangeCorrectionProposalCore proposal = new ChangeCorrectionProposalCore(label, (Change)change, relevance);
        return CodeActionHandler.wrap(proposal, "quickfix");
    }

    public ProposalKindWrapper createCorrectMainTypeNameProposal(ICompilationUnit cu, IInvocationContext context, String currTypeName, String newTypeName, int relevance) {
        String title = Messages.format((String)CorrectionMessages.ReorgCorrectionsSubProcessor_renametype_description, (Object)BasicElementLabels.getJavaElementName((String)newTypeName));
        CorrectMainTypeNameProposalCore p = new CorrectMainTypeNameProposalCore(title, cu, null, context, currTypeName, newTypeName, relevance);
        return CodeActionHandler.wrap((ChangeCorrectionProposalCore)p, "quickfix");
    }

    protected ProposalKindWrapper createCorrectPackageDeclarationProposal(ICompilationUnit cu, IProblemLocation problem, int relevance) {
        return CodeActionHandler.wrap((ChangeCorrectionProposalCore)new CorrectPackageDeclarationProposalCore(cu, problem, relevance), "quickfix");
    }

    protected ProposalKindWrapper createMoveToNewPackageProposal(String label, CompositeChange composite, int relevance) {
        ChangeCorrectionProposalCore p = new ChangeCorrectionProposalCore(label, (Change)composite, 6);
        return CodeActionHandler.wrap(p, "quickfix");
    }

    protected ProposalKindWrapper createOrganizeImportsProposal(String name, Change change, ICompilationUnit cu, int relevance) {
        return null;
    }

    public void addRemoveImportStatementProposals(IInvocationContext context, IProblemLocation problem, Collection<ProposalKindWrapper> proposals) {
        super.addRemoveImportStatementProposals(context, problem, proposals);
        ICleanUpFix removeAllUnusedImportsFix = UnusedCodeFixCore.createCleanUp((CompilationUnit)context.getASTRoot(), (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)false, (boolean)true, (boolean)false, (boolean)false);
        if (removeAllUnusedImportsFix != null) {
            try {
                CompilationUnitChange change = removeAllUnusedImportsFix.createChange(null);
                CUCorrectionProposalCore proposal = new CUCorrectionProposalCore(CorrectionMessages.ReorgCorrectionsSubProcessor_remove_all_unused_imports, change.getCompilationUnit(), (TextChange)change, 6);
                proposals.add(CodeActionHandler.wrap((ChangeCorrectionProposalCore)proposal, "quickfix"));
            }
            catch (CoreException ce) {
                JavaLanguageServerPlugin.log(ce);
            }
        }
    }

    protected ProposalKindWrapper createRemoveUnusedImportProposal(IProposableFix fix, UnusedCodeCleanUp unusedCodeCleanUp, int relevance, IInvocationContext context) {
        if (fix != null) {
            try {
                CompilationUnitChange change = fix.createChange(null);
                CUCorrectionProposalCore proposal = new CUCorrectionProposalCore(change.getName(), change.getCompilationUnit(), (TextChange)change, relevance);
                return CodeActionHandler.wrap((ChangeCorrectionProposalCore)proposal, "quickfix");
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.log(e);
            }
        }
        return null;
    }

    public ProposalKindWrapper createProjectSetupFixProposal(IInvocationContext context, IProblemLocation problem, String missingType, Collection<ProposalKindWrapper> proposals) {
        return null;
    }

    public UnresolvedElementsBaseSubProcessor<ProposalKindWrapper> getUnresolvedElementsSubProcessor() {
        return new UnresolvedElementsSubProcessor();
    }

    protected ProposalKindWrapper createChangeToRequiredCompilerComplianceProposal(String label1, IJavaProject project, boolean changeOnWorkspace, String requiredVersion, int relevance) {
        return null;
    }

    protected ProposalKindWrapper createChangeToRequiredCompilerComplianceProposal(String label2, IJavaProject project, boolean changeOnWorkspace, String requiredVersion, boolean enablePreviews, int relevance) {
        return null;
    }

    protected ProposalKindWrapper createOpenBuildPathCorrectionProposal(IProject project, String label, int relevance, IBinding referencedElement) {
        return null;
    }
}

