/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ChildPropertyDescriptor;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.StringFragment;
import org.eclipse.jdt.internal.core.dom.util.DOMASTUtil;

public class StringTemplateComponent
extends Expression {
    private static final List PROPERTY_DESCRIPTORS;
    public static final ChildPropertyDescriptor EMBEDDED_EXPRESSION_PROPERTY;
    public static final ChildPropertyDescriptor STRING_FRAGMENT_PROPERTY;
    private volatile Expression expression;
    private volatile StringFragment fragment;

    static {
        EMBEDDED_EXPRESSION_PROPERTY = new ChildPropertyDescriptor(StringTemplateComponent.class, "expression", Expression.class, true, true);
        STRING_FRAGMENT_PROPERTY = new ChildPropertyDescriptor(StringTemplateComponent.class, "fragment", StringFragment.class, true, true);
        ArrayList propertyList = new ArrayList(2);
        StringTemplateComponent.createPropertyList(StringTemplateComponent.class, propertyList);
        StringTemplateComponent.addProperty(EMBEDDED_EXPRESSION_PROPERTY, propertyList);
        StringTemplateComponent.addProperty(STRING_FRAGMENT_PROPERTY, propertyList);
        PROPERTY_DESCRIPTORS = StringTemplateComponent.reapPropertyList(propertyList);
    }

    StringTemplateComponent(AST ast) {
        super(ast);
        this.supportedOnlyIn21();
    }

    public static List propertyDescriptors(int apiLevel) {
        return null;
    }

    public static List propertyDescriptors(int apiLevel, boolean previewEnabled) {
        if (DOMASTUtil.isStringTemplateSupported(apiLevel, previewEnabled)) {
            return PROPERTY_DESCRIPTORS;
        }
        return null;
    }

    @Override
    final List internalStructuralPropertiesForType(int apiLevel) {
        return StringTemplateComponent.propertyDescriptors(apiLevel);
    }

    @Override
    final List internalStructuralPropertiesForType(int apiLevel, boolean previewEnabled) {
        return StringTemplateComponent.propertyDescriptors(apiLevel, previewEnabled);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == STRING_FRAGMENT_PROPERTY) {
            if (get) {
                return this.getStringFragment();
            }
            this.setStringFragment((StringFragment)child);
            return null;
        }
        if (property == EMBEDDED_EXPRESSION_PROPERTY) {
            if (get) {
                return this.getEmbeddedExpression();
            }
            this.setEmbeddedExpression((Expression)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    public void setEmbeddedExpression(Expression processor) {
        this.supportedOnlyIn21();
        if (processor == null) {
            throw new IllegalArgumentException();
        }
        Expression oldChild = this.expression;
        this.preReplaceChild(oldChild, processor, EMBEDDED_EXPRESSION_PROPERTY);
        this.expression = processor;
        this.postReplaceChild(oldChild, processor, EMBEDDED_EXPRESSION_PROPERTY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Expression getEmbeddedExpression() {
        this.supportedOnlyIn21();
        if (this.expression == null) {
            StringTemplateComponent stringTemplateComponent = this;
            synchronized (stringTemplateComponent) {
                if (this.expression == null) {
                    this.preLazyInit();
                    this.expression = new SimpleName(this.ast);
                    this.postLazyInit(this.expression, EMBEDDED_EXPRESSION_PROPERTY);
                }
            }
        }
        return this.expression;
    }

    public void setStringFragment(StringFragment fragment) {
        this.supportedOnlyIn21();
        if (fragment == null) {
            throw new IllegalArgumentException();
        }
        StringFragment oldChild = this.fragment;
        this.preReplaceChild(oldChild, fragment, STRING_FRAGMENT_PROPERTY);
        this.fragment = fragment;
        this.postReplaceChild(oldChild, fragment, STRING_FRAGMENT_PROPERTY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringFragment getStringFragment() {
        this.supportedOnlyIn21();
        if (this.fragment == null) {
            StringTemplateComponent stringTemplateComponent = this;
            synchronized (stringTemplateComponent) {
                if (this.fragment == null) {
                    this.preLazyInit();
                    this.fragment = new StringFragment(this.ast);
                    this.postLazyInit(this.fragment, STRING_FRAGMENT_PROPERTY);
                }
            }
        }
        return this.fragment;
    }

    @Override
    int getNodeType0() {
        return 117;
    }

    @Override
    boolean subtreeMatch0(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    ASTNode clone0(AST target) {
        StringTemplateComponent result = new StringTemplateComponent(target);
        result.setStringFragment((StringFragment)this.getStringFragment().clone(target));
        result.setEmbeddedExpression((Expression)this.getEmbeddedExpression().clone(target));
        return result;
    }

    @Override
    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.acceptChild(visitor, this.getStringFragment());
            this.acceptChild(visitor, this.getEmbeddedExpression());
        }
        visitor.endVisit(this);
    }

    @Override
    int memSize() {
        return 48;
    }

    @Override
    int treeSize() {
        return this.memSize() + (this.fragment == null ? 0 : this.getStringFragment().treeSize()) + (this.expression == null ? 0 : this.getEmbeddedExpression().treeSize());
    }
}

