/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.index;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.internal.core.index.FileIndexLocation;
import org.eclipse.jdt.internal.core.index.JarIndexLocation;
import org.eclipse.jdt.internal.core.util.Util;

public abstract class IndexLocation {
    private final URL url;
    private final URI uri;
    protected boolean participantIndex;

    public static IndexLocation createIndexLocation(URL url) {
        URL localUrl;
        try {
            localUrl = FileLocator.resolve((URL)url);
        }
        catch (IOException e) {
            return null;
        }
        if (localUrl.getProtocol().equals("file")) {
            File localFile = null;
            try {
                URI localFileURI = new URI(localUrl.toExternalForm());
                localFile = new File(localFileURI);
            }
            catch (Exception ex) {
                localFile = new File(localUrl.getPath());
            }
            return new FileIndexLocation(url, localFile);
        }
        return new JarIndexLocation(url, localUrl);
    }

    protected IndexLocation(File file) {
        URL tempUrl = null;
        URI tempUri = null;
        try {
            tempUri = file.toURI();
            tempUrl = tempUri.toURL();
        }
        catch (MalformedURLException e) {
            Util.log(e, "Unexpected uri to url conversion failure");
        }
        this.url = tempUrl;
        this.uri = tempUri;
    }

    public IndexLocation(URL url) {
        URI tempUri;
        block2: {
            this.url = url;
            tempUri = null;
            try {
                tempUri = url.toURI();
            }
            catch (URISyntaxException e) {
                if (this instanceof JarIndexLocation) break block2;
                Util.log(e, "Unexpected uri to url conversion failure");
            }
        }
        this.uri = tempUri;
    }

    public void close() {
    }

    public abstract boolean createNewFile() throws IOException;

    public abstract boolean delete();

    public abstract boolean exists();

    public abstract String fileName();

    public abstract String getCanonicalFilePath();

    public abstract File getIndexFile();

    abstract InputStream getInputStream() throws IOException;

    public URL getUrl() {
        return this.url;
    }

    public int hashCode() {
        return this.uri != null ? this.uri.hashCode() : this.url.hashCode();
    }

    public boolean isParticipantIndex() {
        return this.participantIndex;
    }

    public abstract long lastModified();

    public abstract long length();

    public abstract boolean startsWith(IPath var1);

    public String toString() {
        return this.url.toString();
    }
}

