/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.plugin.internal;

import com.microsoft.java.debug.core.DebugUtility;
import com.microsoft.java.debug.core.LaunchException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.LaunchingConnector;
import com.sun.jdi.connect.VMStartException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.commons.io.IOUtils;
import org.eclipse.jdi.internal.VirtualMachineImpl;
import org.eclipse.jdi.internal.VirtualMachineManagerImpl;
import org.eclipse.jdi.internal.connect.SocketLaunchingConnectorImpl;
import org.eclipse.jdi.internal.connect.SocketListeningConnectorImpl;

public class AdvancedLaunchingConnector
extends SocketLaunchingConnectorImpl
implements LaunchingConnector {
    private static final int ACCEPT_TIMEOUT = 10000;

    public AdvancedLaunchingConnector(VirtualMachineManagerImpl virtualMachineManager) {
        super(virtualMachineManager);
    }

    @Override
    public Map<String, Connector.Argument> defaultArguments() {
        Map defaultArgs = super.defaultArguments();
        JDIStringArgumentImpl cwdArg = new JDIStringArgumentImpl("cwd", "Current working directory", "cwd", false);
        cwdArg.setValue(null);
        defaultArgs.put("cwd", cwdArg);
        JDIStringArgumentImpl envArg = new JDIStringArgumentImpl("env", "Environment variables", "env", false);
        envArg.setValue(null);
        defaultArgs.put("env", envArg);
        return defaultArgs;
    }

    @Override
    public String name() {
        return "com.microsoft.java.debug.AdvancedLaunchingConnector";
    }

    @Override
    public VirtualMachine launch(Map<String, ? extends Connector.Argument> connectionArgs) throws IOException, IllegalConnectorArgumentsException, VMStartException {
        String cwd = connectionArgs.get("cwd").value();
        File workingDir = null;
        if (cwd != null && Files.isDirectory(Paths.get(cwd, new String[0]), new LinkOption[0])) {
            workingDir = new File(cwd);
        }
        String[] envVars = null;
        try {
            envVars = DebugUtility.decodeArrayArgument((String)connectionArgs.get("env").value());
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        SocketListeningConnectorImpl listenConnector = new SocketListeningConnectorImpl(this.virtualMachineManager());
        Map args = listenConnector.defaultArguments();
        ((Connector.IntegerArgument)args.get("timeout")).setValue(10000);
        String address = listenConnector.startListening(args);
        String[] cmds = AdvancedLaunchingConnector.constructLaunchCommand(connectionArgs, address);
        Process process = Runtime.getRuntime().exec(cmds, envVars, workingDir);
        CompletableFuture result = new CompletableFuture();
        CompletableFuture.runAsync(() -> {
            try {
                VirtualMachineImpl vm = (VirtualMachineImpl)listenConnector.accept(args);
                vm.setLaunchedProcess(process);
                result.complete(vm);
            }
            catch (IllegalConnectorArgumentsException e) {
                result.completeExceptionally(e);
            }
            catch (IOException iOException) {
                if (result.isDone()) {
                    return;
                }
                String stdout = this.streamToString(process.getInputStream());
                String stderr = this.streamToString(process.getErrorStream());
                process.destroy();
                result.completeExceptionally((Throwable)new LaunchException(String.format("VM did not connect within given time: %d ms", 10000), process, false, -1, stdout, stderr));
            }
            catch (RuntimeException e) {
                result.completeExceptionally(e);
            }
        });
        process.onExit().thenAcceptAsync(theProcess -> {
            if (result.isDone()) {
                return;
            }
            int exitStatus = theProcess.exitValue();
            String stdout = this.streamToString(process.getInputStream());
            String stderr = this.streamToString(process.getErrorStream());
            result.completeExceptionally((Throwable)new LaunchException(String.format("VM exited with status %d", exitStatus), theProcess, true, exitStatus, stdout, stderr));
            try {
                listenConnector.stopListening(args);
            }
            catch (IOException iOException) {}
        });
        try {
            return (VirtualMachine)result.get();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            if (e.getCause() instanceof IllegalConnectorArgumentsException) {
                throw (IllegalConnectorArgumentsException)e.getCause();
            }
            if (e.getCause() instanceof VMStartException) {
                throw (VMStartException)e.getCause();
            }
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new IllegalStateException("Unexpected exception thrown when launching VM", e.getCause());
        }
        catch (InterruptedException interruptedException) {
            throw new VMStartException("VM start interrupted", process);
        }
    }

    private String streamToString(InputStream inputStream) {
        try {
            return IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static String[] constructLaunchCommand(Map<String, ? extends Connector.Argument> launchingOptions, String address) {
        String javaHome = launchingOptions.get("home").value();
        String javaExec = launchingOptions.get("vmexec").value();
        String slash = System.getProperty("file.separator");
        boolean suspend = Boolean.valueOf(launchingOptions.get("suspend").value());
        String javaOptions = launchingOptions.get("options").value();
        String main = launchingOptions.get("main").value();
        StringBuilder execString = new StringBuilder();
        execString.append("\"" + javaHome + slash + "bin" + slash + javaExec + "\"");
        execString.append(" -Xdebug -Xnoagent -Djava.compiler=NONE");
        execString.append(" -Xrunjdwp:transport=dt_socket,address=" + address + ",server=n,suspend=" + (suspend ? "y" : "n"));
        if (javaOptions != null) {
            execString.append(" " + javaOptions);
        }
        execString.append(" " + main);
        return DebugUtility.parseArguments((String)execString.toString()).toArray(new String[0]);
    }

    abstract class JDIArgumentImpl
    implements Connector.Argument {
        private static final long serialVersionUID = 8850533280769854833L;
        private String name;
        private String description;
        private String label;
        private boolean mustSpecify;

        protected JDIArgumentImpl(String name, String description, String label, boolean mustSpecify) {
            this.name = name;
            this.description = description;
            this.label = label;
            this.mustSpecify = mustSpecify;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public String description() {
            return this.description;
        }

        @Override
        public String label() {
            return this.label;
        }

        @Override
        public boolean mustSpecify() {
            return this.mustSpecify;
        }

        @Override
        public abstract String value();

        @Override
        public abstract void setValue(String var1);

        @Override
        public abstract boolean isValid(String var1);

        public abstract String toString();
    }

    class JDIStringArgumentImpl
    extends JDIArgumentImpl
    implements Connector.StringArgument {
        private static final long serialVersionUID = 6009335074727417445L;
        private String value;

        protected JDIStringArgumentImpl(String name, String description, String label, boolean mustSpecify) {
            super(name, description, label, mustSpecify);
        }

        @Override
        public String value() {
            return this.value;
        }

        @Override
        public void setValue(String value) {
            this.value = value;
        }

        @Override
        public boolean isValid(String value) {
            return true;
        }

        @Override
        public String toString() {
            return this.value;
        }
    }
}

