/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.bs.gradle.plugin;

import com.microsoft.java.bs.gradle.model.BuildTargetDependency;
import com.microsoft.java.bs.gradle.model.GradleSourceSet;
import com.microsoft.java.bs.gradle.model.GradleSourceSetsMetadata;
import com.microsoft.java.bs.gradle.model.LanguageExtension;
import com.microsoft.java.bs.gradle.model.impl.DefaultGradleSourceSet;
import com.microsoft.java.bs.gradle.model.impl.DefaultGradleSourceSetsMetadata;
import com.microsoft.java.bs.gradle.plugin.GradleBuildServerPlugin;
import com.microsoft.java.bs.gradle.plugin.LanguageModelBuilder;
import com.microsoft.java.bs.gradle.plugin.SourceSetCache;
import com.microsoft.java.bs.gradle.plugin.dependency.DependencyCollector;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.file.copy.DefaultCopySpec;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.SourceSetOutput;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.api.tasks.testing.Test;
import org.gradle.tooling.provider.model.ToolingModelBuilder;
import org.gradle.util.GradleVersion;

public class SourceSetsModelBuilder
implements ToolingModelBuilder {
    public boolean canBuild(String modelName) {
        return modelName.equals(GradleSourceSetsMetadata.class.getName());
    }

    public Object buildAll(String modelName, Project rootProject) {
        HashMap<GradleSourceSet, List<File>> sourceSetsToClasspath = new HashMap<GradleSourceSet, List<File>>();
        HashMap<File, GradleSourceSet> outputsToSourceSet = new HashMap<File, GradleSourceSet>();
        Set allProject = rootProject.getAllprojects();
        SourceSetCache cache = new SourceSetCache();
        HashSet<File> exclusionFromDependencies = new HashSet<File>();
        for (Project project : allProject) {
            SourceSetContainer sourceSets = this.getSourceSetContainer(project);
            if (sourceSets == null || sourceSets.isEmpty()) continue;
            sourceSets.forEach(sourceSet -> {
                DefaultGradleSourceSet gradleSourceSet = new DefaultGradleSourceSet();
                cache.addGradleSourceSet((SourceSet)sourceSet, gradleSourceSet);
                cache.addProject((SourceSet)sourceSet, project);
                gradleSourceSet.setBuildTargetDependencies(new HashSet<BuildTargetDependency>());
                gradleSourceSet.setGradleVersion(project.getGradle().getGradleVersion());
                gradleSourceSet.setProjectName(project.getName());
                String projectPath = project.getPath();
                gradleSourceSet.setProjectPath(projectPath);
                gradleSourceSet.setProjectDir(project.getProjectDir());
                gradleSourceSet.setRootDir(project.getRootDir());
                gradleSourceSet.setSourceSetName(sourceSet.getName());
                String classesTaskName = this.getFullTaskName(projectPath, sourceSet.getClassesTaskName());
                gradleSourceSet.setClassesTaskName(classesTaskName);
                String cleanTaskName = this.getFullTaskName(projectPath, "clean");
                gradleSourceSet.setCleanTaskName(cleanTaskName);
                HashSet<String> taskNames = new HashSet<String>();
                gradleSourceSet.setTaskNames(taskNames);
                String projectName = this.stripPathPrefix(projectPath);
                if (projectName == null || projectName.length() == 0) {
                    projectName = gradleSourceSet.getProjectName();
                }
                String displayName = projectName + " [" + gradleSourceSet.getSourceSetName() + ']';
                gradleSourceSet.setDisplayName(displayName);
                HashSet<File> srcDirs = new HashSet<File>();
                HashSet<File> generatedSrcDirs = new HashSet<File>();
                for (LanguageModelBuilder languageModelBuilder : GradleBuildServerPlugin.SUPPORTED_LANGUAGE_BUILDERS) {
                    if (!languageModelBuilder.appliesFor(project, (SourceSet)sourceSet)) continue;
                    Task compileTask = languageModelBuilder.getLanguageCompileTask(project, (SourceSet)sourceSet);
                    if (compileTask != null) {
                        String compileTaskName = this.getFullTaskName(projectPath, compileTask.getName());
                        taskNames.add(compileTaskName);
                    }
                    srcDirs.addAll(languageModelBuilder.getSourceFoldersFor(project, (SourceSet)sourceSet));
                    generatedSrcDirs.addAll(languageModelBuilder.getGeneratedSourceFoldersFor(project, (SourceSet)sourceSet));
                }
                gradleSourceSet.setSourceDirs(srcDirs);
                exclusionFromDependencies.addAll(srcDirs);
                gradleSourceSet.setGeneratedSourceDirs(generatedSrcDirs);
                exclusionFromDependencies.addAll(generatedSrcDirs);
                LinkedList<File> compileClasspath = new LinkedList<File>();
                try {
                    compileClasspath.addAll(sourceSet.getCompileClasspath().getFiles());
                }
                catch (GradleException languageModelBuilder) {
                    // empty catch block
                }
                gradleSourceSet.setCompileClasspath(compileClasspath);
                sourceSetsToClasspath.put(gradleSourceSet, compileClasspath);
                File sourceOutputDir = this.getSourceOutputDir((SourceSet)sourceSet);
                if (sourceOutputDir != null) {
                    gradleSourceSet.setSourceOutputDir(sourceOutputDir);
                    outputsToSourceSet.put(sourceOutputDir, gradleSourceSet);
                    exclusionFromDependencies.add(sourceOutputDir);
                }
                Set resourceDirs = sourceSet.getResources().getSrcDirs();
                gradleSourceSet.setResourceDirs(resourceDirs);
                exclusionFromDependencies.addAll(resourceDirs);
                File resourceOutputDir = sourceSet.getOutput().getResourcesDir();
                if (resourceOutputDir != null) {
                    gradleSourceSet.setResourceOutputDir(resourceOutputDir);
                    outputsToSourceSet.put(resourceOutputDir, gradleSourceSet);
                    exclusionFromDependencies.add(resourceOutputDir);
                }
                if (sourceOutputDir != null) {
                    TaskCollection testTasks = project.getTasks().withType(Test.class);
                    for (Test testTask : testTasks) {
                        if (GradleVersion.current().compareTo(GradleVersion.version((String)"4.0")) >= 0) {
                            FileCollection files = testTask.getTestClassesDirs();
                            if (!files.contains(sourceOutputDir)) continue;
                            gradleSourceSet.setHasTests(true);
                            break;
                        }
                        try {
                            Method getTestClassesDir = testTask.getClass().getMethod("getTestClassesDir", new Class[0]);
                            Object testClassesDir = getTestClassesDir.invoke((Object)testTask, new Object[0]);
                            if (!sourceOutputDir.equals(testClassesDir)) continue;
                            gradleSourceSet.setHasTests(true);
                            break;
                        }
                        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                        }
                    }
                }
            });
            if (sourceSets.isEmpty()) continue;
            this.gatherArchiveTasks(outputsToSourceSet, cache, project, sourceSets);
        }
        this.setModuleDependencies(cache, exclusionFromDependencies);
        for (SourceSet sourceSet2 : cache.getAllSourceSets()) {
            Project project;
            DefaultGradleSourceSet gradleSourceSet = cache.getGradleSourceSet(sourceSet2);
            if (gradleSourceSet == null || (project = cache.getProject(sourceSet2)) == null) continue;
            HashMap<String, LanguageExtension> extensions = new HashMap<String, LanguageExtension>();
            for (LanguageModelBuilder languageModelBuilder : GradleBuildServerPlugin.SUPPORTED_LANGUAGE_BUILDERS) {
                LanguageExtension extension;
                if (!languageModelBuilder.appliesFor(project, sourceSet2) || (extension = languageModelBuilder.getExtensionsFor(project, sourceSet2, gradleSourceSet.getModuleDependencies())) == null) continue;
                extensions.put(languageModelBuilder.getLanguageId(), extension);
            }
            gradleSourceSet.setExtensions(extensions);
        }
        return new DefaultGradleSourceSetsMetadata(sourceSetsToClasspath, outputsToSourceSet);
    }

    private void setModuleDependencies(SourceSetCache cache, Set<File> exclusionFromDependencies) {
        for (SourceSet sourceSet : cache.getAllSourceSets()) {
            DefaultGradleSourceSet gradleSourceSet = cache.getGradleSourceSet(sourceSet);
            if (gradleSourceSet == null) continue;
            DependencyCollector collector = new DependencyCollector(cache.getProject(sourceSet), exclusionFromDependencies);
            collector.collectByConfigurationNames(this.getClasspathConfigurationNames(sourceSet));
            gradleSourceSet.setModuleDependencies(collector.getModuleDependencies());
        }
    }

    private SourceSetContainer getSourceSetContainer(Project project) {
        SourceSetContainer sourceSetContainer;
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"5.0")) >= 0 && (sourceSetContainer = (SourceSetContainer)project.getExtensions().findByType(SourceSetContainer.class)) != null) {
            return sourceSetContainer;
        }
        try {
            Method getConvention = project.getClass().getMethod("getConvention", new Class[0]);
            Object convention = getConvention.invoke((Object)project, new Object[0]);
            Method getPlugins = convention.getClass().getMethod("getPlugins", new Class[0]);
            Object plugins = getPlugins.invoke(convention, new Object[0]);
            Method getGet = plugins.getClass().getMethod("get", Object.class);
            Object pluginConvention = getGet.invoke(plugins, "java");
            if (pluginConvention != null) {
                Method getSourceSetsMethod = pluginConvention.getClass().getMethod("getSourceSets", new Class[0]);
                return (SourceSetContainer)getSourceSetsMethod.invoke(pluginConvention, new Object[0]);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            // empty catch block
        }
        return null;
    }

    private String getFullTaskName(String modulePath, String taskName) {
        if (taskName == null) {
            return null;
        }
        if (taskName.isEmpty()) {
            return taskName;
        }
        if (modulePath == null || modulePath.equals(":")) {
            return ":" + taskName;
        }
        return modulePath + ":" + taskName;
    }

    private String stripPathPrefix(String projectPath) {
        if (projectPath.startsWith(":")) {
            return projectPath.substring(1);
        }
        return projectPath;
    }

    private File getSourceOutputDir(SourceSet sourceSet) {
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"6.1")) >= 0) {
            Directory sourceOutputDir = (Directory)sourceSet.getJava().getClassesDirectory().getOrNull();
            if (sourceOutputDir != null) {
                return sourceOutputDir.getAsFile();
            }
            return null;
        }
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"4.0")) >= 0) {
            try {
                Method getOutputDirMethod = SourceDirectorySet.class.getMethod("getOutputDir", new Class[0]);
                return (File)getOutputDirMethod.invoke((Object)sourceSet.getJava(), new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException getOutputDirMethod) {}
        } else {
            SourceSetOutput output = sourceSet.getOutput();
            Set allOutputDirs = output.getFiles();
            File resourceOutputDir = output.getResourcesDir();
            allOutputDirs.remove(resourceOutputDir);
            if (!allOutputDirs.isEmpty()) {
                return (File)allOutputDirs.iterator().next();
            }
        }
        return null;
    }

    private void gatherArchiveTasks(Map<File, GradleSourceSet> outputsToSourceSet, SourceSetCache cache, Project project, SourceSetContainer sourceSets) {
        TaskCollection archiveTasks = project.getTasks().withType(AbstractArchiveTask.class);
        for (AbstractArchiveTask archiveTask : archiveTasks) {
            Set<Object> archiveSourcePaths = this.getArchiveSourcePaths((CopySpec)archiveTask.getRootSpec());
            for (Object sourcePath : archiveSourcePaths) {
                sourceSets.forEach(sourceSet -> {
                    DefaultGradleSourceSet gradleSourceSet = cache.getGradleSourceSet((SourceSet)sourceSet);
                    if (gradleSourceSet == null) {
                        return;
                    }
                    if (sourceSet.getOutput().equals(sourcePath)) {
                        File archiveFile = GradleVersion.current().compareTo(GradleVersion.version((String)"5.1")) >= 0 ? ((RegularFile)archiveTask.getArchiveFile().get()).getAsFile() : archiveTask.getArchivePath();
                        outputsToSourceSet.put(archiveFile, gradleSourceSet);
                    }
                });
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Set<Object> getArchiveSourcePaths(CopySpec copySpec) {
        HashSet<Object> sourcePaths = new HashSet<Object>();
        if (!(copySpec instanceof DefaultCopySpec)) return sourcePaths;
        DefaultCopySpec defaultCopySpec = (DefaultCopySpec)copySpec;
        sourcePaths.addAll(defaultCopySpec.getSourcePaths());
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"6.2")) >= 0) {
            for (CopySpec child : defaultCopySpec.getChildren()) {
                sourcePaths.addAll(this.getArchiveSourcePaths(child));
            }
            return sourcePaths;
        } else {
            try {
                Method getChildren = defaultCopySpec.getClass().getMethod("getChildren", new Class[0]);
                Object children = getChildren.invoke((Object)defaultCopySpec, new Object[0]);
                if (!(children instanceof Iterable)) return sourcePaths;
                for (Object child : (Iterable)children) {
                    if (!(child instanceof CopySpec)) continue;
                    sourcePaths.addAll(this.getArchiveSourcePaths((CopySpec)child));
                }
                return sourcePaths;
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException exception) {
                // empty catch block
            }
        }
        return sourcePaths;
    }

    private Set<String> getClasspathConfigurationNames(SourceSet sourceSet) {
        HashSet<String> configurationNames = new HashSet<String>();
        configurationNames.add(sourceSet.getCompileClasspathConfigurationName());
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"3.4")) >= 0) {
            configurationNames.add(sourceSet.getRuntimeClasspathConfigurationName());
        }
        return configurationNames;
    }
}

