/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.refactoring.function;

import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.Activator;
import org.eclipse.titanium.refactoring.function.ExtractToFunctionRefactoring;
import org.eclipse.titanium.refactoring.function.IModelProvider;
import org.eclipse.titanium.refactoring.function.ParamTableItem;

public class ExtractToFunctionHeadless {
    private final IFile selectedFile;
    private final ITextSelection textSelection;
    private final String newFuncName;
    private final List<String> newParamNames;
    private RefactoringStatus refactoringStatus;
    private boolean selectionValid = true;

    public ExtractToFunctionHeadless(IFile selFile, ITextSelection textSel, String newFuncName, List<String> newParamNames) {
        this.selectedFile = selFile;
        this.textSelection = textSel;
        this.newFuncName = newFuncName;
        this.newParamNames = newParamNames;
    }

    public boolean isSelectionValid() {
        return this.selectionValid;
    }

    public RefactoringStatus getRefactoringStatus() {
        return this.refactoringStatus;
    }

    public void run() {
        ExtractToFunctionRefactoring refactoring = new ExtractToFunctionRefactoring();
        try {
            refactoring.findSelectionHeadless(this.selectedFile, this.textSelection);
            if (!refactoring.isSelectionValid()) {
                this.selectionValid = false;
                return;
            }
            Activator.getDefault().pauseHandlingResourceChanges();
            try {
                WorkspaceJob job1 = refactoring.createFunction();
                job1.join();
                if (!job1.getResult().isOK()) {
                    ErrorReporter.logError((String)"ExtractToFunctionHeadless: createFunction() job failed! ");
                    return;
                }
            }
            catch (InterruptedException ie) {
                ErrorReporter.logExceptionStackTrace((Exception)ie);
            }
            this.refactoringStatus = refactoring.checkFinalConditions((IProgressMonitor)new NullProgressMonitor());
            this.editFuncName(refactoring.getNewFunctionName());
            IModelProvider<ParamTableItem> modelProvider = refactoring.getWizardModelProvider();
            this.editParamNames(modelProvider.getItems());
            Activator.getDefault().resumeHandlingResourceChanges();
            Change change = refactoring.createChange(null);
            change.perform((IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
    }

    private void editFuncName(StringBuilder funcName) {
        if (this.newFuncName == null) {
            return;
        }
        funcName.setLength(0);
        funcName.append(this.newFuncName);
    }

    private void editParamNames(List<ParamTableItem> params) {
        if (this.newParamNames == null || this.newParamNames.isEmpty()) {
            return;
        }
        ListIterator<ParamTableItem> itPti = params.listIterator();
        ListIterator<String> itNewNames = this.newParamNames.listIterator();
        while (itPti.hasNext() && itNewNames.hasNext()) {
            itPti.next().setName(itNewNames.next());
        }
    }
}

