/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.refactoring.function;

import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusEntry;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.swt.widgets.Display;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titanium.refactoring.function.FunctionCreator;
import org.eclipse.titanium.refactoring.function.IModelProvider;
import org.eclipse.titanium.refactoring.function.Param;
import org.eclipse.titanium.refactoring.function.ParamCollector;
import org.eclipse.titanium.refactoring.function.ParamTableItem;
import org.eclipse.titanium.refactoring.function.ReturnVisitor;
import org.eclipse.titanium.refactoring.function.SelectionFinder;
import org.eclipse.titanium.refactoring.function.StatementList;

public class ExtractToFunctionRefactoring
extends Refactoring {
    public static final boolean DEBUG_MESSAGES_ON = false;
    private IProject project;
    private final StringBuilder newFuncName = new StringBuilder("newFunction");
    private IVisitableNode parentFunc;
    private List<StringBuilder> functionText;
    private List<StringBuilder> functionCallText;
    private String functionTextReady = "/* function body */";
    private String functionCallTextReady = "/* function call */";
    private SelectionFinder selectionFinder;
    private ParamCollector paramCollector;
    private FunctionCreator functionCreator;

    public StringBuilder getNewFunctionName() {
        return this.newFuncName;
    }

    public IModelProvider<ParamTableItem> getWizardModelProvider() {
        return this.functionCreator;
    }

    public String getNewFunctionText() {
        return this.functionTextReady;
    }

    public String getName() {
        return "Extract to function";
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus result = new RefactoringStatus();
        ListIterator<RefactoringStatusEntry> it = this.selectionFinder.getWarnings().listIterator();
        while (it.hasNext()) {
            result.addEntry(it.next());
        }
        it = this.paramCollector.getWarnings().listIterator();
        while (it.hasNext()) {
            result.addEntry(it.next());
        }
        it = this.functionCreator.getWarnings().listIterator();
        while (it.hasNext()) {
            result.addEntry(it.next());
        }
        return result;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        this.createFunctionText();
        this.createFunctionCallText();
        TextFileChange tfc = new TextFileChange(this.selectionFinder.getSelectedFile().getName(), this.selectionFinder.getSelectedFile());
        MultiTextEdit rootEdit = new MultiTextEdit();
        tfc.setEdit((TextEdit)rootEdit);
        int offset = this.selectionFinder.getSelectedStatements().getLocation().getOffset();
        int len = this.selectionFinder.getSelectedStatements().getLocation().getEndOffset() - offset;
        rootEdit.addChild((TextEdit)new ReplaceEdit(offset, len, this.functionCallTextReady));
        if (this.parentFunc != null && this.selectionFinder.getInsertLoc() >= 0) {
            rootEdit.addChild((TextEdit)new InsertEdit(this.selectionFinder.getInsertLoc(), this.functionTextReady));
        }
        return tfc;
    }

    public void findSelection() {
        this.selectionFinder = new SelectionFinder();
        this.selectionFinder.perform();
        this.project = this.selectionFinder.getProject();
    }

    public void findSelectionHeadless(IFile selFile, ITextSelection textSel) {
        this.selectionFinder = new SelectionFinder();
        this.selectionFinder.performHeadless(selFile, textSel);
        this.project = this.selectionFinder.getProject();
    }

    public boolean isSelectionValid() {
        return this.selectionFinder != null && this.selectionFinder.isSelectionValid() && this.selectionFinder.getParentFunc() != null;
    }

    public IFile getSelectedFile() {
        return this.selectionFinder.getSelectedFile();
    }

    public Module getSelectedModule() {
        return this.selectionFinder.getModule();
    }

    public WorkspaceJob createFunction() {
        WorkspaceJob job = new WorkspaceJob("ExtractToFunction: creating new function text"){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                ExtractToFunctionRefactoring.this.parentFunc = ExtractToFunctionRefactoring.this.selectionFinder.getParentFunc();
                if (ExtractToFunctionRefactoring.this.parentFunc == null) {
                    ErrorReporter.logError((String)"ExtractToFunctionRefactoring.createFunction(): Could not find the enclosing function of the selection! ");
                    return Status.CANCEL_STATUS;
                }
                if (ExtractToFunctionRefactoring.this.selectionFinder.getInsertLoc() < 0) {
                    ErrorReporter.logError((String)"ExtractToFunctionRefactoring.createFunction(): Could not calculate the insert location! ");
                    return Status.CANCEL_STATUS;
                }
                StatementList selectedStatements = ExtractToFunctionRefactoring.this.selectionFinder.getSelectedStatements();
                Module selectedModule = ExtractToFunctionRefactoring.this.getSelectedModule();
                if (selectedStatements == null || selectedStatements.isEmpty() || selectedModule == null) {
                    ErrorReporter.logError((String)"ExtractToFunctionRefactoring.createFunction(): No or invalid selection! ");
                    return Status.CANCEL_STATUS;
                }
                ExtractToFunctionRefactoring.this.paramCollector = new ParamCollector(ExtractToFunctionRefactoring.this.project, selectedStatements, selectedModule);
                ExtractToFunctionRefactoring.this.paramCollector.perform();
                List<Param> params = ExtractToFunctionRefactoring.this.paramCollector.getParams();
                if (params == null) {
                    ErrorReporter.logError((String)"ExtractToFunctionRefactoring.createFunction(): Unable to collect params! ");
                    return Status.CANCEL_STATUS;
                }
                IFile selectedFile = ExtractToFunctionRefactoring.this.getSelectedFile();
                Reference runsOnRef = ExtractToFunctionRefactoring.this.selectionFinder.getRunsOnRef();
                Type returnType = ExtractToFunctionRefactoring.this.selectionFinder.getReturnType();
                ReturnVisitor.ReturnCertainty retCertainty = ExtractToFunctionRefactoring.this.selectionFinder.getReturnCertainty();
                ExtractToFunctionRefactoring.this.functionCreator = new FunctionCreator(selectedStatements, selectedFile, ExtractToFunctionRefactoring.this.newFuncName, params, runsOnRef, returnType, retCertainty);
                ExtractToFunctionRefactoring.this.functionCreator.perform();
                ExtractToFunctionRefactoring.this.functionText = ExtractToFunctionRefactoring.this.functionCreator.getFunctionText();
                if (ExtractToFunctionRefactoring.this.functionText == null) {
                    ErrorReporter.logError((String)"ExtractToFunctionRefactoring.createFunction(): Unable to create function text! ");
                    return Status.CANCEL_STATUS;
                }
                ExtractToFunctionRefactoring.this.functionCallText = ExtractToFunctionRefactoring.this.functionCreator.getFunctionCallText();
                if (ExtractToFunctionRefactoring.this.functionCallText == null) {
                    ErrorReporter.logError((String)"ExtractToFunctionRefactoring.createFunction(): Unable to create function call text! ");
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        return job;
    }

    private void createFunctionText() {
        if (this.functionText == null) {
            this.functionTextReady = null;
            return;
        }
        StringBuilder ret = new StringBuilder();
        for (StringBuilder sb : this.functionText) {
            ret.append((CharSequence)sb);
        }
        this.functionTextReady = ret.toString();
    }

    private void createFunctionCallText() {
        if (this.functionCallText == null) {
            this.functionCallTextReady = null;
            return;
        }
        StringBuilder ret = new StringBuilder();
        for (StringBuilder sb : this.functionCallText) {
            ret.append((CharSequence)sb);
        }
        this.functionCallTextReady = ret.toString();
    }

    public static void setStatusLineMsg(final String msg, final IStatusLineManager toSet) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                toSet.setErrorMessage(msg);
            }
        });
    }
}

