/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.refactoring.insertfield;

import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titanium.refactoring.insertfield.ChangeCreator;
import org.eclipse.titanium.refactoring.insertfield.SelectionFinder;

public class InsertFieldRefactoring
extends Refactoring {
    public static final String PROJECTCONTAINSERRORS = "The project `{0}'' contains errors, which might corrupt the result of the refactoring";
    public static final String PROJECTCONTAINSTTCNPPFILES = "The project `{0}'' contains .ttcnpp files, which might corrupt the result of the refactoring";
    private static final String ONTHEFLYANALAYSISDISABLED = "The on-the-fly analysis is disabled, there is semantic information present to work on";
    private final Definition selection;
    private final Set<IProject> projects = new HashSet<IProject>();
    private final IStructuredSelection iselection;
    private final Settings settings;
    private Object[] affectedObjects;

    public InsertFieldRefactoring(IStructuredSelection selection, Settings settings) {
        this.iselection = selection;
        this.settings = settings == null ? new Settings() : settings;
        SelectionFinder sf = new SelectionFinder();
        sf.perform();
        this.selection = sf.getSelection();
    }

    public Definition getSelection() {
        return this.selection;
    }

    public Object[] getAffectedObjects() {
        return this.affectedObjects;
    }

    public String getName() {
        return "Insert field";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus result = new RefactoringStatus();
        try {
            pm.beginTask("Checking preconditions...", 2);
            IPreferencesService prefs = Platform.getPreferencesService();
            if (!prefs.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.useOnTheFlyParsing", false, null)) {
                result.addError(ONTHEFLYANALAYSISDISABLED);
            }
            for (IProject project : this.projects) {
                if (!GlobalParser.hasTtcnppFiles((IResource)project)) continue;
                result.addError(MessageFormat.format(PROJECTCONTAINSTTCNPPFILES, project));
            }
            pm.worked(1);
            block6: for (IProject project : this.projects) {
                IMarker[] markers;
                for (IMarker marker : markers = project.findMarkers(null, true, 2)) {
                    if (2 != marker.getAttribute("severity", 2)) continue;
                    result.addError(MessageFormat.format(PROJECTCONTAINSERRORS, project));
                    continue block6;
                }
            }
            pm.worked(1);
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            result.addFatalError(e.getMessage());
        }
        finally {
            pm.done();
        }
        return result;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    public Settings getSettings() {
        return this.settings;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (this.iselection == null) {
            return null;
        }
        CompositeChange cchange = new CompositeChange("InsertFieldRefactoring");
        for (Object o : this.iselection) {
            if (!(o instanceof IResource)) continue;
            IResource res = (IResource)o;
            ResourceVisitor vis = new ResourceVisitor();
            res.getProject().accept((IResourceVisitor)vis);
            cchange.add((Change)vis.getChange());
        }
        this.affectedObjects = cchange.getAffectedObjects();
        return cchange;
    }

    public static class Settings {
        private String type;
        private Identifier id;
        private String value;
        private int position;

        public Settings() {
        }

        public Settings(String type, Identifier id, String value, int position) {
            this.type = type;
            this.id = id;
            this.value = value;
            this.position = position;
        }

        public String getType() {
            return this.type;
        }

        public Identifier getId() {
            return this.id;
        }

        public String getValue() {
            return this.value;
        }

        public int getPosition() {
            return this.position;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setId(Identifier id) {
            this.id = id;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public void setPosition(int position) {
            this.position = position;
        }
    }

    private class ResourceVisitor
    implements IResourceVisitor {
        private final CompositeChange change = new CompositeChange("InsertFieldRefactoring");

        private CompositeChange getChange() {
            return this.change;
        }

        public boolean visit(IResource resource) throws CoreException {
            if (resource instanceof IFile) {
                ChangeCreator chCreator = new ChangeCreator((IFile)resource, InsertFieldRefactoring.this.selection, InsertFieldRefactoring.this.settings);
                chCreator.perform();
                Change ch = chCreator.getChange();
                if (ch != null) {
                    this.change.add(ch);
                }
                return false;
            }
            return true;
        }
    }
}

