/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.search;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.graphics.Image;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.utils.IOUtils;
import org.eclipse.titan.log.viewer.Activator;
import org.eclipse.titan.log.viewer.exceptions.TechnicalException;
import org.eclipse.titan.log.viewer.exceptions.TitanLogExceptionHandler;
import org.eclipse.titan.log.viewer.models.LogRecordIndex;
import org.eclipse.titan.log.viewer.utils.LogFileCacheHandler;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class SearchLabelProvider
extends LabelProvider {
    private static final int MAX_TEXT_LENGTH = 500;
    private final Image matchIcon = Activator.getImageDescriptor("icons/child_obj.gif").createImage();

    public Image getImage(Object element) {
        if (element instanceof Match) {
            return this.matchIcon;
        }
        return WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider().getImage(element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String getText(Object element) {
        block7: {
            if (element instanceof IResource) {
                return WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider().getText(element);
            }
            if (!(element instanceof Match)) break block7;
            Match match = (Match)element;
            IFile logFile = (IFile)match.getElement();
            RandomAccessFile file = null;
            String result = "";
            try {
                File indexFile = LogFileCacheHandler.getLogRecordIndexFileForLogFile(logFile);
                LogRecordIndex[] indexes = LogFileCacheHandler.readLogRecordIndexFile(indexFile, match.getOffset(), 1);
                file = new RandomAccessFile(new File(logFile.getLocationURI()), "r");
                int length = indexes[0].getRecordLength() > 500 ? 500 : indexes[0].getRecordLength();
                byte[] record = new byte[length];
                file.seek(indexes[0].getFileOffset());
                file.read(record);
                result = new String(record);
            }
            catch (FileNotFoundException e) {
                ErrorReporter.logExceptionStackTrace((Exception)e);
                TitanLogExceptionHandler.handleException(new TechnicalException(logFile.getName() + ": File not found " + e.getMessage()));
                String string = logFile.getName() + ": File not found";
                IOUtils.closeQuietly((Closeable)file);
                return string;
            }
            catch (IOException e2) {
                ErrorReporter.logExceptionStackTrace((Exception)e2);
                TitanLogExceptionHandler.handleException(new TechnicalException("Error while reading the log file." + e2.getMessage()));
                String string = "Error while reading the log file.";
                {
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(file);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((Closeable)file);
                return string;
            }
            IOUtils.closeQuietly((Closeable)file);
            return result;
        }
        return "Unexpected element";
    }
}

