/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.runtime.core;

import org.eclipse.titan.runtime.core.Base_Template;
import org.eclipse.titan.runtime.core.TTCN_Logger;

public class Lazy_Fuzzy_TemplateExpr<E extends Base_Template> {
    protected E expr_cache;
    protected boolean fuzzy;
    protected boolean expressionEvaluated;
    protected boolean oldExpressionEvaluated;

    public Lazy_Fuzzy_TemplateExpr(boolean fuzzy) {
        this.fuzzy = fuzzy;
    }

    public Lazy_Fuzzy_TemplateExpr(boolean fuzzy, E cache) {
        this.fuzzy = fuzzy;
        this.expressionEvaluated = true;
        this.oldExpressionEvaluated = true;
        this.expr_cache = cache;
    }

    protected void evaluate_expression() {
    }

    public E evaluate() {
        if (this.fuzzy || !this.expressionEvaluated) {
            this.evaluate_expression();
            this.expressionEvaluated = true;
        }
        return this.expr_cache;
    }

    public void log() {
        if (!this.expressionEvaluated) {
            TTCN_Logger.log_event_str("<not evaluated>");
        } else {
            ((Base_Template)this.expr_cache).log();
        }
    }

    public void change() {
        boolean bl = this.fuzzy = !this.fuzzy;
        if (!this.fuzzy) {
            this.oldExpressionEvaluated = this.expressionEvaluated;
            this.expressionEvaluated = false;
        }
    }

    public void revert() {
        boolean bl = this.fuzzy = !this.fuzzy;
        if (this.fuzzy) {
            this.expressionEvaluated = this.expressionEvaluated || this.oldExpressionEvaluated;
        }
    }
}

