/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.runtime.core;

public class Ttcn3Float {
    private static final long NEGATIVE_ZERO = Double.doubleToLongBits(-0.0);
    private double value;

    public Ttcn3Float(double d) {
        this.value = d;
    }

    double getValue() {
        return this.value;
    }

    Ttcn3Float operator_assign(double d) {
        this.value = d;
        return this;
    }

    Ttcn3Float operator_assign(Ttcn3Float d) {
        this.value = d.value;
        return this;
    }

    Ttcn3Float add(double d) {
        return new Ttcn3Float(this.value + d);
    }

    Ttcn3Float sub(double d) {
        return new Ttcn3Float(this.value - d);
    }

    Ttcn3Float mul(double d) {
        return new Ttcn3Float(this.value * d);
    }

    Ttcn3Float div(double d) {
        return new Ttcn3Float(this.value / d);
    }

    boolean is_less_than(double d) {
        if (Double.isNaN(this.value)) {
            return false;
        }
        if (Double.isNaN(d)) {
            return true;
        }
        if (this.value == 0.0 && d == 0.0) {
            return this.is_negative_zero(this.value) && !this.is_negative_zero(d);
        }
        return this.value < d;
    }

    boolean is_greater_than(double d) {
        if (Double.isNaN(this.value)) {
            return !Double.isNaN(d);
        }
        if (Double.isNaN(d)) {
            return false;
        }
        if (this.value == 0.0 && d == 0.0) {
            return !this.is_negative_zero(this.value) && this.is_negative_zero(d);
        }
        return this.value > d;
    }

    boolean operator_equals(double d) {
        if (Double.isNaN(this.value)) {
            return Double.isNaN(d);
        }
        if (Double.isNaN(d)) {
            return false;
        }
        if (this.value == 0.0 && d == 0.0) {
            return this.is_negative_zero(this.value) == this.is_negative_zero(d);
        }
        return this.value == d;
    }

    private boolean is_negative_zero(double d) {
        return Double.doubleToLongBits(d) == NEGATIVE_ZERO;
    }

    public String create_java_string_representation() {
        if (Double.isNaN(this.value)) {
            return "Double.NaN";
        }
        if (Double.isInfinite(this.value)) {
            if (Double.compare(this.value, 0.0) > 0) {
                return "Double.POSITIVE_INFINITY";
            }
            return "-Double.NEGATIVE_INFINITY";
        }
        return Double.toString(this.value);
    }

    public String create_ttcn3_string_representation() {
        if (Double.isNaN(this.value)) {
            return "not_a_number";
        }
        if (Double.isInfinite(this.value)) {
            if (Double.compare(this.value, 0.0) > 0) {
                return "infinity";
            }
            return "-infinity";
        }
        return Double.toString(this.value);
    }

    public String toString() {
        return this.create_ttcn3_string_representation();
    }
}

