/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.runtime.core;

import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;

public final class Usage_Stats {
    public static final boolean USAGE_STAT_SENDING = false;
    private static final String HOST = "ttcn.ericsson.se";
    private static final String PAGE = "/download/usage_stats/usage_stats.php";
    private static final int PORT = 80;

    private Usage_Stats() {
    }

    private static StringBuilder collectSystemData(String message) {
        StringBuilder urlparameters = new StringBuilder(400 + message.length());
        urlparameters.append("plugin_id=").append("org.eclipse.titan.runtime");
        urlparameters.append('&').append("plugin_version_qualifier=").append("11.1.0");
        urlparameters.append('&').append("plugin_version=").append("11.1.0");
        try {
            urlparameters.append('&').append("os_version=").append(System.getProperty("os.version"));
            urlparameters.append('&').append("os_arch=").append(System.getProperty("os.arch"));
            urlparameters.append('&').append("eclipse_version=").append("n/a");
            urlparameters.append('&').append("eclipse_version_qualifier=").append("n/a");
            urlparameters.append('&').append("java_vendor=").append(System.getProperty("java.vendor"));
            urlparameters.append('&').append("user_id=").append(System.getProperty("user.name"));
            urlparameters.append('&').append("java_version=").append(System.getProperty("java.version"));
            urlparameters.append('&').append("os_name=").append(System.getProperty("os.name"));
        }
        catch (SecurityException e) {
            return urlparameters;
        }
        try {
            urlparameters.append('&').append("hostname=").append(InetAddress.getLocalHost().getCanonicalHostName());
        }
        catch (Exception e) {
            urlparameters.append('&').append("hostname=").append("UNKNOWN");
        }
        urlparameters.append('&').append("info=").append(message);
        return urlparameters;
    }

    private static void post(String message) {
        int[] ports = new int[]{49555, 59555, 61555, 0};
        Socket socket = new Socket();
        for (int i = 0; i < ports.length; ++i) {
            try {
                socket.bind(new InetSocketAddress(InetAddress.getLocalHost(), ports[i]));
                break;
            }
            catch (IOException e) {
                if (!socket.isBound()) continue;
                try {
                    socket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                continue;
            }
        }
        try {
            socket.connect(new InetSocketAddress(HOST, 80));
            String urlParameters = Usage_Stats.collectSystemData(message).toString();
            DataOutputStream wr = new DataOutputStream(socket.getOutputStream());
            wr.writeBytes("POST /download/usage_stats/usage_stats.php HTTP/1.0\r\nHost: ttcn.ericsson.se\r\nContent-type: application/x-www-form-urlencoded\r\nContent-length: " + Integer.toString(urlParameters.length()) + "\r\n\r\n");
            wr.writeBytes(urlParameters);
            wr.flush();
            wr.close();
            socket.close();
            return;
        }
        catch (IOException iOException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (socket != null) {
            try {
                socket.close();
            }
            catch (IOException iOException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void sendAsync(final String message) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                Usage_Stats.post(message);
            }
        };
        thread.start();
    }
}

