/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.runtime.core.cfgparser;

import java.text.MessageFormat;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.eclipse.titan.runtime.core.TTCN_Logger;

public class CFGListener
extends BaseErrorListener {
    private String filename;
    private boolean encounteredError;

    public CFGListener(String filename) {
        this.filename = filename;
        this.encounteredError = false;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public boolean encounteredError() {
        return this.encounteredError;
    }

    public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
        this.encounteredError = true;
        TTCN_Logger.begin_event(TTCN_Logger.Severity.ERROR_UNQUALIFIED);
        if (this.filename == null) {
            TTCN_Logger.log_event_str(MessageFormat.format("Parse error while reading configuration information: in line {0}: {1}", line, msg));
        } else {
            TTCN_Logger.log_event_str(MessageFormat.format("Parse error in configuration file `{0}'': in line {1}: {2}", this.filename, line, msg));
        }
        TTCN_Logger.end_event();
    }
}

