/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.runtime.core.cfgparser;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.eclipse.titan.runtime.core.TtcnError;

public final class ConfigCharsetDetector {
    private byte[] char_bytes;
    private static byte[] UTF8_BOM = new byte[]{-17, -69, -65};
    private static byte[] UTF16_LE_BOM = new byte[]{-1, -2};
    private static byte[] UTF16_BE_BOM = new byte[]{-2, -1};

    public ConfigCharsetDetector(File p_file) {
        FileInputStream file_input = null;
        FileChannel file_channel = null;
        try {
            file_input = new FileInputStream(p_file);
            file_channel = file_input.getChannel();
            int file_size = (int)file_channel.size();
            MappedByteBuffer buffer = file_channel.map(FileChannel.MapMode.READ_ONLY, 0L, file_size);
            this.char_bytes = new byte[file_size];
            buffer.get(this.char_bytes);
        }
        catch (IOException e) {
            throw new TtcnError(e.getMessage());
        }
        finally {
            try {
                if (file_input != null) {
                    file_input.close();
                }
                if (file_channel != null) {
                    file_channel.close();
                }
            }
            catch (IOException e) {
                throw new TtcnError(e.getMessage());
            }
        }
    }

    public ConfigCharsetDetector(byte[] p_bytes) {
        if (p_bytes != null) {
            this.char_bytes = p_bytes;
        }
    }

    public String detectCharSet() {
        if (this.char_bytes == null) {
            return null;
        }
        for (int i = 0; i < this.char_bytes.length && (this.char_bytes[i] & 0x80) == 0; ++i) {
            if (i != this.char_bytes.length - 1) continue;
            return "US-ASCII";
        }
        String detectedBom = this.detectBOM();
        if (detectedBom != null) {
            return detectedBom;
        }
        if (this.char_bytes.length < 3) {
            return null;
        }
        if (this.isUTF8()) {
            return "UTF-8";
        }
        return null;
    }

    private String detectBOM() {
        if (this.char_bytes.length < 3) {
            return null;
        }
        if (this.char_bytes[0] == UTF8_BOM[0] && this.char_bytes[1] == UTF8_BOM[1] && this.char_bytes[2] == UTF8_BOM[2]) {
            return "UTF-8";
        }
        if (this.char_bytes[0] == UTF16_LE_BOM[0] && this.char_bytes[1] == UTF16_LE_BOM[1]) {
            return "UTF-16LE";
        }
        if (this.char_bytes[0] == UTF16_BE_BOM[0] && this.char_bytes[1] == UTF16_BE_BOM[1]) {
            return "UTF-16BE";
        }
        return null;
    }

    private boolean isUTF8() {
        int code_length = 0;
        int i = 0;
        int data_length = this.char_bytes.length;
        int ch = 0;
        while (i != data_length) {
            int temp_byte = this.char_bytes[i] & 0xFF;
            if (temp_byte <= 127) {
                ++i;
                continue;
            }
            if (194 <= temp_byte && temp_byte <= 223) {
                code_length = 2;
            } else if (224 <= temp_byte && temp_byte <= 239) {
                code_length = 3;
            } else if (240 <= temp_byte && temp_byte <= 244) {
                code_length = 4;
            } else {
                return false;
            }
            if (i + (code_length - 1) >= data_length) {
                return false;
            }
            for (int j = 1; j < code_length; ++j) {
                if ((this.char_bytes[i + j] & 0xC0) == 128) continue;
                return false;
            }
            if (code_length == 2) {
                ch = ((this.char_bytes[i] & 0x1F) << 6) + (this.char_bytes[i + 1] & 0x3F);
            } else if (code_length == 3) {
                ch = ((this.char_bytes[i] & 0xF) << 12) + ((this.char_bytes[i + 1] & 0x3F) << 6) + (this.char_bytes[i + 2] & 0x3F);
                if (ch < 2048) {
                    return false;
                }
                if (ch >> 11 == 27) {
                    return false;
                }
            } else if (code_length == 4 && ((ch = ((this.char_bytes[i] & 7) << 18) + ((this.char_bytes[i + 1] & 0x3F) << 12) + ((this.char_bytes[i + 2] & 0x3F) << 6) + (this.char_bytes[i + 3] & 0x3F)) < 65536 || ch > 69631)) {
                return false;
            }
            i += code_length;
        }
        return true;
    }
}

