/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.runtime.core.mctr;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import org.eclipse.titan.runtime.core.cfgparser.ComponentSectionHandler;
import org.eclipse.titan.runtime.core.cfgparser.ExecuteSectionHandler;
import org.eclipse.titan.runtime.core.cfgparser.GroupSectionHandler;
import org.eclipse.titan.runtime.core.cfgparser.IOUtils;

public class ConfigData {
    private String log_file_name = null;
    private List<ExecuteSectionHandler.ExecuteItem> executeItems;
    private List<GroupSectionHandler.Group> group_list;
    private List<ComponentSectionHandler.Component> component_list;
    private String local_addr = null;
    private int tcp_listen_port = 0;
    private BigInteger num_hcs;
    private Double kill_timer = 10.0;
    private cf_timestamp_format tsformat = cf_timestamp_format.TSF_NONE;

    public ConfigData() {
        this.num_hcs = new BigInteger("-1");
    }

    public void clear() {
        this.log_file_name = null;
        this.executeItems = null;
        this.group_list = null;
        this.component_list = null;
        this.local_addr = null;
        this.tcp_listen_port = 0;
        this.num_hcs = new BigInteger("-1");
        this.kill_timer = 10.0;
    }

    public void add_host(List<GroupSectionHandler.Group> group_list) {
        this.group_list = group_list;
    }

    public void add_component(List<ComponentSectionHandler.Component> component_list) {
        this.component_list = component_list;
    }

    public void add_exec(List<ExecuteSectionHandler.ExecuteItem> exec_items) {
        this.executeItems = exec_items;
    }

    public void set_log_file(String f) {
        if (f != null) {
            this.log_file_name = f;
        }
    }

    public String getLog_file_name() {
        return this.log_file_name;
    }

    public List<ExecuteSectionHandler.ExecuteItem> getExecuteItems() {
        return this.executeItems;
    }

    public List<GroupSectionHandler.Group> getGroup_list() {
        return this.group_list;
    }

    public List<ComponentSectionHandler.Component> getComponent_list() {
        return this.component_list;
    }

    public String getLocal_addr() {
        return this.local_addr;
    }

    public int getTcp_listen_port() {
        return this.tcp_listen_port;
    }

    public BigInteger getNum_hcs() {
        return this.num_hcs;
    }

    public Double getKill_timer() {
        return this.kill_timer;
    }

    public void setLocal_addr(String local_addr) {
        this.local_addr = local_addr;
    }

    public void setTcp_listen_port(int tcp_listen_port) {
        this.tcp_listen_port = tcp_listen_port;
    }

    public void setNum_hcs(BigInteger num_hcs) {
        this.num_hcs = num_hcs;
    }

    public void setKill_timer(Double kill_timer) {
        this.kill_timer = kill_timer;
    }

    static String getConfigFileContent(File config_file) {
        if (config_file == null) {
            return "";
        }
        StringBuilder contentBuilder = new StringBuilder();
        BufferedReader br = null;
        try {
            String currentLine;
            br = new BufferedReader(new FileReader(config_file));
            while ((currentLine = br.readLine()) != null) {
                contentBuilder.append(currentLine).append("\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        IOUtils.closeQuietly(br);
        return contentBuilder.toString();
    }

    public cf_timestamp_format getTsformat() {
        return this.tsformat;
    }

    public void setTsformat(cf_timestamp_format tsformat) {
        this.tsformat = tsformat;
    }

    public static enum cf_timestamp_format {
        TSF_NONE,
        TSF_TIME,
        TSF_DATE_TIME,
        TSF_SEC;

    }
}

