/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.executor.executors;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.path.PathUtil;
import org.eclipse.titan.executor.executors.LaunchConfigurationUtil;
import org.eclipse.titan.executor.tabpages.hostcontrollers.HostControllersTab;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public abstract class LaunchShortcutConfig
implements ILaunchShortcut {
    protected abstract String getConfigurationId();

    protected abstract String getDialogTitle();

    protected abstract String getLaunchConfigurationType();

    public abstract boolean initLaunchConfiguration(ILaunchConfigurationWorkingCopy var1, IProject var2, String var3);

    protected ILaunchConfigurationWorkingCopy getWorkingCopy(IProject project, IFile file, String mode) {
        try {
            ILaunchConfigurationType configurationType = LaunchConfigurationUtil.getLaunchManager().getLaunchConfigurationType(this.getConfigurationId());
            ILaunchConfiguration[] configurations = LaunchConfigurationUtil.getLaunchManager().getLaunchConfigurations(configurationType);
            ArrayList<ILaunchConfiguration> candidateConfigurations = new ArrayList<ILaunchConfiguration>();
            for (ILaunchConfiguration configuration : configurations) {
                IResource[] resources = configuration.getMappedResources();
                if (resources == null || resources.length < 2) continue;
                boolean found = false;
                for (IResource resource : resources) {
                    if (!resource.equals((Object)project)) continue;
                    found = true;
                    break;
                }
                if (found) {
                    found = false;
                    for (IResource resource : resources) {
                        if (!file.equals(resource)) continue;
                        found = true;
                        break;
                    }
                }
                if (!found) continue;
                candidateConfigurations.add(configuration);
            }
            if (1 == candidateConfigurations.size()) {
                this.performLaunch((ILaunchConfiguration)candidateConfigurations.get(0), mode);
                return null;
            }
            if (candidateConfigurations.size() > 1) {
                IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
                ElementListSelectionDialog dialog = new ElementListSelectionDialog(null, (ILabelProvider)labelProvider);
                dialog.setTitle(this.getDialogTitle());
                dialog.setMessage("Select existing configuration.");
                dialog.setElements((Object[])candidateConfigurations.toArray(new ILaunchConfiguration[candidateConfigurations.size()]));
                if (dialog.open() == 0) {
                    ILaunchConfiguration result = (ILaunchConfiguration)dialog.getFirstResult();
                    this.performLaunch(result, mode);
                    labelProvider.dispose();
                    return null;
                }
                labelProvider.dispose();
            }
            String configurationName = file.getFullPath().toString().substring(1).replace("/", "-") + "-" + this.getLaunchConfigurationType();
            ILaunchConfiguration config = LaunchConfigurationUtil.findLaunchConfigurationByName(configurationName, configurationType);
            ILaunchConfigurationWorkingCopy wc = null;
            wc = config != null ? config.getWorkingCopy() : configurationType.newInstance(null, LaunchConfigurationUtil.getLaunchManager().generateLaunchConfigurationName(configurationName));
            wc.setMappedResources(new IResource[]{project, file});
            wc.setAttribute("org.eclipse.titan.executor.executeConfigurationFileOnLaunch", true);
            return wc;
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            return null;
        }
    }

    protected void performLaunch(ILaunchConfiguration configuration, String mode) throws CoreException {
        if (configuration.isWorkingCopy()) {
            configuration = ((ILaunchConfigurationWorkingCopy)configuration).doSave();
        }
        configuration.launch(mode, null);
    }

    public final void launch(IEditorPart editor, String mode) {
        ErrorReporter.INTERNAL_ERROR((String)"LaunchShortcutConfig.launch called from an editor even though it is no registered to support such calls.");
    }

    public final void launch(ISelection selection, String mode) {
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        Object[] selections = ((IStructuredSelection)selection).toArray();
        if (1 != selections.length) {
            return;
        }
        if (!(selections[0] instanceof IFile)) {
            ErrorReporter.logError((String)"Config file not found");
            return;
        }
        IFile file = (IFile)selections[0];
        IProject project = file.getProject();
        if (project == null) {
            ErrorReporter.logError((String)"Project file not found");
            return;
        }
        ILaunchConfigurationWorkingCopy wc = this.getWorkingCopy(project, file, mode);
        if (wc == null) {
            return;
        }
        boolean result = this.initLaunchConfiguration(wc, project, PathUtil.getRelativePath((String)project.getLocation().toOSString(), (String)file.getLocation().toOSString()));
        if (result) {
            result = HostControllersTab.initLaunchConfiguration(wc);
        }
        try {
            if (result) {
                wc.setMappedResources(new IResource[]{project, file});
                wc.setAttribute("org.eclipse.titan.executor.executeConfigurationFileOnLaunch", true);
                this.performLaunch((ILaunchConfiguration)wc, mode);
            }
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
    }
}

