/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.ASN1.types;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASN1.ASN1Type;
import org.eclipse.titan.designer.AST.ASN1.IASN1Type;
import org.eclipse.titan.designer.AST.ASN1.Object.ObjectClass_Definition;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IReferencingType;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.ParameterisedSubReference;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TypeCompatibilityInfo;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public final class ObjectClassField_Type
extends ASN1Type
implements IReferencingType {
    private final IASN1Type referred_type;
    private final ObjectClass_Definition objectClass;
    private final Identifier fieldName;

    public ObjectClassField_Type(IASN1Type referredType, ObjectClass_Definition objectClass, Identifier identifier) {
        this.referred_type = referredType;
        this.objectClass = objectClass;
        this.fieldName = identifier;
        if (referredType != null) {
            referredType.setOwnertype(IType.TypeOwner_type.OT_OCFT, this);
        }
    }

    @Override
    public IType.Type_type getTypetype() {
        return IType.Type_type.TYPE_OBJECTCLASSFIELDTYPE;
    }

    @Override
    public IASN1Type newInstance() {
        return new ObjectClassField_Type(this.referred_type, this.objectClass, this.fieldName);
    }

    @Override
    public String chainedDescription() {
        return "type ObjectClassFieldType: " + this.referred_type.getFullName();
    }

    public ObjectClass_Definition getMyObjectClass() {
        return this.objectClass;
    }

    public Identifier getObjectClassFieldName() {
        return this.fieldName;
    }

    @Override
    public boolean isCompatible(CompilationTimeStamp timestamp, IType otherType, TypeCompatibilityInfo info, TypeCompatibilityInfo.Chain leftChain, TypeCompatibilityInfo.Chain rightChain) {
        this.check(timestamp);
        otherType.check(timestamp);
        if (null == this.referred_type) {
            return false;
        }
        IType t1 = this.referred_type.getTypeRefdLast(timestamp);
        IType t2 = otherType.getTypeRefdLast(timestamp);
        if (t1.getIsErroneous(timestamp) || t2.getIsErroneous(timestamp)) {
            return true;
        }
        return t1.isCompatible(timestamp, t2, null, null, null);
    }

    @Override
    public IType.Type_type getTypetypeTtcn3() {
        return IType.Type_type.TYPE_UNDEFINED;
    }

    @Override
    public String getTypename() {
        if (this.isErroneous || null == this.referred_type || this == this.referred_type) {
            return "Object class field type";
        }
        return this.referred_type.getTypename();
    }

    @Override
    public String getOutlineIcon() {
        return "titan.gif";
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (null != this.lastTimeChecked && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        this.isErroneous = false;
        if (null != this.referred_type) {
            this.referred_type.check(timestamp);
        }
        if (null != this.constraints) {
            this.constraints.check(timestamp);
        }
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (referenceChain.add(this)) {
            ReferenceChain tempReferenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
            IType type = this.getTypeRefd(timestamp, tempReferenceChain);
            tempReferenceChain.release();
            if (null != type && !type.getIsErroneous(timestamp) && !this.equals(type)) {
                type.checkRecursions(timestamp, referenceChain);
            }
        }
    }

    @Override
    public IValue checkThisValueRef(CompilationTimeStamp timestamp, IValue value) {
        if (IValue.Value_type.UNDEFINED_LOWERIDENTIFIER_VALUE.equals((Object)value.getValuetype())) {
            ReferenceChain tempReferenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
            IType refd = this.getTypeRefd(timestamp, tempReferenceChain);
            tempReferenceChain.release();
            if (null == refd) {
                return value;
            }
            return refd.checkThisValueRef(timestamp, value);
        }
        return value;
    }

    @Override
    public boolean checkThisValue(CompilationTimeStamp timestamp, IValue value, Assignment lhs, IType.ValueCheckingOptions valueCheckingOptions) {
        ReferenceChain tempReferenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
        IType last = this.getTypeRefd(timestamp, tempReferenceChain);
        tempReferenceChain.release();
        boolean selfReference = false;
        if (null != last && last != this) {
            selfReference = last.checkThisValue(timestamp, value, lhs, valueCheckingOptions);
        }
        value.setLastTimeChecked(timestamp);
        return selfReference;
    }

    @Override
    public boolean checkThisTemplate(CompilationTimeStamp timestamp, ITTCN3Template template, boolean isModified, boolean implicitOmit, Assignment lhs) {
        this.registerUsage(template);
        if (this.getIsErroneous(timestamp)) {
            return false;
        }
        boolean selfReference = false;
        IType tempType = this.getTypeRefdLast(timestamp);
        if (tempType != this) {
            selfReference = tempType.checkThisTemplate(timestamp, template, isModified, implicitOmit, lhs);
        }
        return selfReference;
    }

    @Override
    public IType getTypeRefd(CompilationTimeStamp timestamp, IReferenceChain refChain) {
        if (refChain.add(this) && !this.getIsErroneous(timestamp)) {
            return this.referred_type;
        }
        this.isErroneous = true;
        this.lastTimeChecked = timestamp;
        return this;
    }

    @Override
    public IType getFieldType(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, Expected_Value_type expectedIndex, IReferenceChain refChain, boolean interruptIfOptional) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (subreferences.size() <= actualSubReference) {
            return this;
        }
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Type `{0}'' can not be indexed", this.getTypename()));
                return null;
            }
            case fieldSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((FieldSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                return null;
            }
            case parameterisedSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((ParameterisedSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                return null;
            }
        }
        subreference.getLocation().reportSemanticError("Unsupported subreference kind.");
        return null;
    }

    @Override
    public void checkMapParameter(CompilationTimeStamp timestamp, IReferenceChain refChain, Location errorLocation) {
        if (refChain.contains(this)) {
            return;
        }
        refChain.add(this);
        IType referencedLast = this.getTypeRefdLast(timestamp);
        if (referencedLast != null) {
            referencedLast.checkMapParameter(timestamp, refChain, errorLocation);
        }
    }

    @Override
    public StringBuilder getProposalDescription(StringBuilder builder) {
        if (null != this.referred_type) {
            return this.referred_type.getProposalDescription(builder);
        }
        return builder.append("unknown_referred_type");
    }

    @Override
    public void addProposal(ProposalCollector propCollector, int i) {
        if (null != this.referred_type && !this.equals(this.referred_type)) {
            this.referred_type.addProposal(propCollector, i);
        }
    }

    @Override
    public void addDeclaration(DeclarationCollector declarationCollector, int i) {
        if (null != this.referred_type && !this.equals(this.referred_type)) {
            this.referred_type.addDeclaration(declarationCollector, i);
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        super.findReferences(referenceFinder, foundIdentifiers);
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (!super.memberAccept(v)) {
            return false;
        }
        if (this.referred_type != null && !this.referred_type.accept(v)) {
            return false;
        }
        if (this.objectClass != null && !this.objectClass.accept(v)) {
            return false;
        }
        return this.fieldName == null || this.fieldName.accept(v);
    }

    @Override
    public String createStringRep_for_OpenType_AltName(CompilationTimeStamp timestamp) {
        if (this.isTagged() || this.constraints != null || this.withAttributesPath != null && this.withAttributesPath.hasAttributes(timestamp)) {
            return this.getGenNameOwn();
        }
        return this.getTypeRefdLast(timestamp).createStringRep_for_OpenType_AltName(timestamp);
    }

    @Override
    public String getGenNameValue(JavaGenData aData, StringBuilder source) {
        if (this == this.referred_type || this.referred_type == null) {
            ErrorReporter.INTERNAL_ERROR((String)("Code generator reached erroneous object class field type `" + this.getFullName() + "''"));
            return "FATAL_ERROR encountered while processing `" + this.getFullName() + "''\n";
        }
        return this.referred_type.getGenNameValue(aData, source);
    }

    @Override
    public String getGenNameTemplate(JavaGenData aData, StringBuilder source) {
        if (this == this.referred_type || this.referred_type == null) {
            ErrorReporter.INTERNAL_ERROR((String)("Code generator reached erroneous object class field type `" + this.getFullName() + "''"));
            return "FATAL_ERROR encountered while processing `" + this.getFullName() + "''\n";
        }
        return this.referred_type.getGenNameTemplate(aData, source);
    }

    @Override
    public String getGenNameTypeDescriptor(JavaGenData aData, StringBuilder source) {
        if (this.rawAttribute != null || this.jsonAttribute != null || this.hasVariantAttributes(CompilationTimeStamp.getBaseTimestamp())) {
            if (this.needsAlias()) {
                String baseName = this.getGenNameOwn(aData);
                return baseName + "." + this.getGenNameOwn();
            }
            if (this.getParentType() != null) {
                IType parentType = this.getParentType();
                if (parentType.generatesOwnClass(aData, source)) {
                    return parentType.getGenNameOwn(aData) + "." + this.getGenNameOwn();
                }
                return this.getGenNameOwn(aData);
            }
            return this.getGenNameOwn(aData);
        }
        if (this.needsAlias()) {
            String baseName = this.getGenNameOwn(aData);
            return baseName + "." + this.getGenNameOwn();
        }
        return this.referred_type.getGenNameTypeDescriptor(aData, source);
    }

    @Override
    public boolean needsOwnJsonDescriptor(JavaGenData aData) {
        return this.jsonAttribute != null && !this.jsonAttribute.empty() || this.getOwnertype() == IType.TypeOwner_type.OT_RECORD_OF && this.getParentType().getJsonAttribute() != null && this.getParentType().getJsonAttribute().as_map;
    }

    @Override
    public String getGenNameJsonDescriptor(JavaGenData aData, StringBuilder source) {
        if (this == this.referred_type || this.referred_type == null) {
            ErrorReporter.INTERNAL_ERROR((String)("Code generator reached erroneous type reference `" + this.getFullName() + "''"));
            return "FATAL_ERROR encountered while processing `" + this.getFullName() + "''\n";
        }
        if (this.needsOwnJsonDescriptor(aData)) {
            return this.getGenNameOwn(aData) + "_json_";
        }
        return this.referred_type.getGenNameJsonDescriptor(aData, source);
    }

    @Override
    public boolean generatesOwnClass(JavaGenData aData, StringBuilder source) {
        return this.needsAlias();
    }

    @Override
    public void generateCode(JavaGenData aData, StringBuilder source) {
        StringBuilder tempSource;
        if (this.lastTimeGenerated != null && !this.lastTimeGenerated.isLess(aData.getBuildTimstamp())) {
            return;
        }
        this.lastTimeGenerated = aData.getBuildTimstamp();
        IType last = this.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
        if (this.myScope.getModuleScopeGen() == last.getMyScope().getModuleScopeGen() && (tempSource = aData.getCodeForType(last.getGenNameOwn())).length() == 0) {
            last.generateCode(aData, tempSource);
        }
        if (this.needsAlias()) {
            String ownName = this.getGenNameOwn();
            last.generateCode(aData, source);
            source.append(MessageFormat.format("\tpublic static class {0} extends {1} '{'\n", ownName, this.referred_type.getGenNameValue(aData, source)));
            StringBuilder descriptor = new StringBuilder();
            this.generateCodeTypedescriptor(aData, source, descriptor, null);
            this.generateCodeDefaultCoding(aData, source, descriptor);
            this.generateCodeForCodingHandlers(aData, source, descriptor);
            source.append((CharSequence)descriptor);
            source.append("\t}\n");
            source.append(MessageFormat.format("\tpublic static class {0}_template extends {1} '{' '}'\n", ownName, this.referred_type.getGenNameTemplate(aData, source)));
        } else {
            this.generateCodeTypedescriptor(aData, source, null, aData.attibute_registry);
            this.generateCodeDefaultCoding(aData, source, null);
            this.generateCodeForCodingHandlers(aData, source, null);
        }
    }
}

