/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.attributes;

import java.text.MessageFormat;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.attributes.DecodeAttribute;
import org.eclipse.titan.designer.AST.TTCN3.attributes.ErrorBehaviorAttribute;
import org.eclipse.titan.designer.AST.TTCN3.attributes.ErrorBehaviorList;
import org.eclipse.titan.designer.AST.TTCN3.attributes.ExtensionAttribute;
import org.eclipse.titan.designer.AST.TTCN3.attributes.TypeMappingTarget;
import org.eclipse.titan.designer.AST.TTCN3.types.PortGenerator;
import org.eclipse.titan.designer.AST.TTCN3.types.Port_Type;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class DecodeTypeMappingTarget
extends TypeMappingTarget {
    private final Type targetType;
    private final DecodeAttribute decodeAttribute;
    private final ErrorBehaviorAttribute errorBehaviorAttribute;

    public DecodeTypeMappingTarget(Type targetType, ExtensionAttribute decodeAttribute, ErrorBehaviorAttribute errorBehaviorAttribute) {
        this.targetType = targetType;
        this.decodeAttribute = decodeAttribute instanceof DecodeAttribute ? (DecodeAttribute)decodeAttribute : null;
        this.errorBehaviorAttribute = errorBehaviorAttribute;
        if (targetType != null) {
            targetType.setFullNameParent(this);
        }
    }

    @Override
    public TypeMappingTarget.TypeMapping_type getTypeMappingType() {
        return TypeMappingTarget.TypeMapping_type.DECODE;
    }

    @Override
    public String getMappingName() {
        return "decode";
    }

    @Override
    public Type getTargetType() {
        return this.targetType;
    }

    public IType.MessageEncoding_type getCodingType() {
        if (this.decodeAttribute != null) {
            return this.decodeAttribute.getEncodingType();
        }
        return IType.MessageEncoding_type.UNDEFINED;
    }

    public boolean hasCodingOptions() {
        if (this.decodeAttribute != null) {
            return this.decodeAttribute.getOptions() != null;
        }
        return false;
    }

    public String getCodingOptions() {
        if (this.decodeAttribute != null) {
            return this.decodeAttribute.getOptions();
        }
        return "UNDEFINED";
    }

    public ErrorBehaviorList getErrrorBehaviorList() {
        return this.errorBehaviorAttribute.getErrrorBehaviorList();
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.targetType == child) {
            return builder.append(".<target_type>");
        }
        if (this.errorBehaviorAttribute == child) {
            return builder.append(".<errorbehavior>");
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.targetType != null) {
            this.targetType.setMyScope(scope);
        }
    }

    @Override
    public void check(CompilationTimeStamp timestamp, Type sourceType, Port_Type portType, boolean legacy, boolean incoming) {
        Type streamType;
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        if (this.targetType != null) {
            this.targetType.check(timestamp);
        }
        if ((streamType = Type.getStreamType(this.decodeAttribute.getEncodingType(), 1)) != null && !streamType.isIdentical(timestamp, sourceType)) {
            sourceType.getLocation().reportSemanticError(MessageFormat.format("Source type of {0} encoding should be `{1}'' instead of `{2}''", this.decodeAttribute.getEncodingType().getEncodingName(), streamType.getTypename(), sourceType.getTypename()));
        }
        if (!this.targetType.hasEncoding(timestamp, this.decodeAttribute.getEncodingType(), this.decodeAttribute.getOptions())) {
            this.targetType.getLocation().reportSemanticError(MessageFormat.format("Target type `{0}'' does not support {1} encoding", this.targetType.getTypename(), this.decodeAttribute.getEncodingType().getEncodingName()));
        }
        if (this.errorBehaviorAttribute != null) {
            this.errorBehaviorAttribute.check(timestamp);
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.targetType != null) {
            this.targetType.updateSyntax(reparser, false);
            reparser.updateLocation(this.targetType.getLocation());
        }
        if (this.decodeAttribute != null) {
            this.decodeAttribute.updateSyntax(reparser, false);
            reparser.updateLocation(this.decodeAttribute.getLocation());
        }
        if (this.errorBehaviorAttribute != null) {
            this.errorBehaviorAttribute.updateSyntax(reparser, false);
            reparser.updateLocation(this.errorBehaviorAttribute.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.targetType != null) {
            this.targetType.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.targetType != null && !this.targetType.accept(v)) {
            return false;
        }
        if (this.decodeAttribute != null && !this.decodeAttribute.accept(v)) {
            return false;
        }
        return this.errorBehaviorAttribute == null || this.errorBehaviorAttribute.accept(v);
    }

    @Override
    public PortGenerator.MessageTypeMappingTarget fillTypeMappingTarget(JavaGenData aData, StringBuilder source, IType sourceType, AtomicBoolean hasSliding) {
        String targetTypeName = null;
        String displayName = null;
        String typeDescriptorName = null;
        hasSliding.set(false);
        if (this.targetType != null) {
            targetTypeName = this.targetType.getGenNameValue(aData, source);
            displayName = this.targetType.getTypename();
            typeDescriptorName = this.targetType.getGenNameTypeDescriptor(aData, source);
        }
        String encodingType = this.decodeAttribute.getEncodingType().getEncodingName();
        String encodingOptions = null;
        if (this.decodeAttribute.getOptions() != null) {
            encodingOptions = this.decodeAttribute.getOptions();
        }
        StringBuilder errorBehaviour = new StringBuilder();
        if (this.errorBehaviorAttribute != null) {
            this.errorBehaviorAttribute.getErrrorBehaviorList().generateCode(aData, errorBehaviour);
        } else {
            aData.addCommonLibraryImport("TTCN_EncDec");
            errorBehaviour.append("TTCN_EncDec.set_error_behavior(TTCN_EncDec.error_type.ET_ALL, TTCN_EncDec.error_behavior_type.EB_DEFAULT);\n");
        }
        return new PortGenerator.MessageTypeMappingTarget(targetTypeName, displayName, typeDescriptorName, encodingType, encodingOptions, errorBehaviour.toString(), PortGenerator.MessageMappingType_type.DECODE);
    }
}

