/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.definitions;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.DocumentComment;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.NamedBridgeScope;
import org.eclipse.titan.designer.AST.NamingConventionHelper;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.TemplateRestriction;
import org.eclipse.titan.designer.AST.TTCN3.attributes.AttributeSpecification;
import org.eclipse.titan.designer.AST.TTCN3.attributes.ExtensionAttribute;
import org.eclipse.titan.designer.AST.TTCN3.attributes.PrototypeAttribute;
import org.eclipse.titan.designer.AST.TTCN3.attributes.Qualifiers;
import org.eclipse.titan.designer.AST.TTCN3.attributes.SingleWithAttribute;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_FunctionBase;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameter;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameterList;
import org.eclipse.titan.designer.AST.TTCN3.definitions.PortScope;
import org.eclipse.titan.designer.AST.TTCN3.definitions.RunsOnScope;
import org.eclipse.titan.designer.AST.TTCN3.statements.StatementBlock;
import org.eclipse.titan.designer.AST.TTCN3.types.Class_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.Component_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.Port_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.Referenced_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.SignatureExceptions;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.Activator;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.Stylers;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.editors.controls.HoverContentType;
import org.eclipse.titan.designer.editors.controls.HoverProposal;
import org.eclipse.titan.designer.editors.controls.Ttcn3HoverContent;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3CodeSkeletons;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.extensionattributeparser.ExtensionAttributeAnalyzer;
import org.eclipse.titan.designer.parsers.ttcn3parser.IdentifierReparser;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;
import org.eclipse.ui.IEditorPart;

public final class Def_Function
extends Def_FunctionBase {
    private static final String FULLNAMEPART1 = ".<runs_on_type>";
    private static final String FULLNAMEPART2 = ".<formal_parameter_list>";
    private static final String FULLNAMEPART3 = ".<type>";
    private static final String FULLNAMEPART4 = ".<statement_block>";
    private static final String FULLNAMEPART5 = ".<mtc_type>";
    private static final String FULLNAMEPART6 = ".<system_type>";
    private static final String FULLNAMEPART7 = ".<port_type>";
    private static final String FULLNAMEPART8 = ".<finally_block>";
    public static final String PORTRETURNNOTALLOWED = "Functions can not return ports";
    private static final String DASHALLOWEDONLYFORTEMPLATES = "Using not used symbol (`-') as the default parameter is allowed only for modified templates";
    private static final String CLASSNORUNSON = "Class functions cannot have a `runs on` clause";
    private static final String CLASSNOMTC = "Class functions cannot have an `mtc` clause";
    private static final String CLASSNOSYSTEM = "Class functions cannot have a `system` clause";
    private static final String EXCEPTIONSOOP = "Function exceptions are only supported in the OOP extension";
    private static final String KIND = "function";
    private final Reference runsOnRef;
    private Component_Type runsOnType = null;
    private final Reference mtcReference;
    private Component_Type mtcType = null;
    private final Reference systemReference;
    private Component_Type systemType = null;
    private final Reference portReference;
    private IType portType = null;
    private final boolean returnsTemplate;
    private final TemplateRestriction.Restriction_type templateRestriction;
    private final StatementBlock finallyBlock;
    private Def_FunctionBase.EncodingPrototype_type prototype;
    private Type inputType;
    private Type outputType;
    private final SignatureExceptions exceptions;
    private final boolean isClassFunction;
    private final Location classModifierLocation;
    private final Location funcModifierLocation;
    private boolean isConstructor = false;
    private boolean isOverride = false;
    private boolean isStartable;

    public Def_Function(Identifier identifier, FormalParameterList formalParameters, Reference runsOnRef, Reference mtcReference, Reference systemReference, Reference portReference, Type returnType, boolean returnsTemplate, TemplateRestriction.Restriction_type templateRestriction, SignatureExceptions exceptions, StatementBlock block, StatementBlock finallyBlock, boolean isClassFunction, boolean isAbstract, boolean isFinal, Location classModifierLocation, boolean isDeterministic, boolean isControl, Location funcModifierLocation) {
        super(identifier, block, isAbstract, isFinal, isDeterministic, isControl, formalParameters, returnType);
        Assignment.Assignment_type assignment_type = returnType == null ? Assignment.Assignment_type.A_FUNCTION : (this.assignmentType = returnsTemplate ? Assignment.Assignment_type.A_FUNCTION_RTEMP : Assignment.Assignment_type.A_FUNCTION_RVAL);
        if (this.formalParameterList != null) {
            this.formalParameterList.setMyDefinition(this);
            this.formalParameterList.setFullNameParent(this);
        }
        this.runsOnRef = runsOnRef;
        this.mtcReference = mtcReference;
        this.systemReference = systemReference;
        this.portReference = portReference;
        this.returnsTemplate = returnsTemplate;
        this.templateRestriction = templateRestriction;
        this.finallyBlock = finallyBlock;
        this.isClassFunction = isClassFunction;
        this.classModifierLocation = classModifierLocation;
        this.funcModifierLocation = funcModifierLocation;
        this.exceptions = exceptions;
        this.prototype = Def_FunctionBase.EncodingPrototype_type.NONE;
        this.inputType = null;
        this.outputType = null;
        if (block != null) {
            block.setMyDefinition(this);
            block.setFullNameParent(this);
        }
        if (finallyBlock != null) {
            finallyBlock.setMyDefinition(this);
            finallyBlock.setFullNameParent(this);
            finallyBlock.setOwnerIsFinally();
        }
        if (runsOnRef != null) {
            runsOnRef.setFullNameParent(this);
        }
        if (mtcReference != null) {
            mtcReference.setFullNameParent(this);
        }
        if (systemReference != null) {
            systemReference.setFullNameParent(this);
        }
        if (portReference != null) {
            portReference.setFullNameParent(this);
        }
        if (returnType != null) {
            returnType.setOwnertype(IType.TypeOwner_type.OT_FUNCTION_DEF, this);
            returnType.setFullNameParent(this);
        }
        if (isClassFunction && identifier.getName().equals("create")) {
            this.isConstructor = true;
        }
    }

    public Def_Function(Identifier identifier, FormalParameterList formalParameters, Reference runsOnRef, Reference mtcReference, Reference systemReference, Reference portReference, Type returnType, boolean returnsTemplate, TemplateRestriction.Restriction_type templateRestriction, SignatureExceptions exceptions, StatementBlock block, StatementBlock finallyBlock, boolean isDeterministic, boolean isControl, Location funcModifierLocation) {
        this(identifier, formalParameters, runsOnRef, mtcReference, systemReference, portReference, returnType, returnsTemplate, templateRestriction, exceptions, block, finallyBlock, false, false, false, null, isDeterministic, isControl, funcModifierLocation);
    }

    public Def_Function(Identifier identifier, FormalParameterList formalParameters, Reference runsOnRef, Reference mtcReference, Reference systemReference, Reference portReference, Type returnType, boolean returnsTemplate, TemplateRestriction.Restriction_type templateRestriction, SignatureExceptions exceptions, StatementBlock block, StatementBlock finallyBlock, boolean isDeterministic, boolean isControl, Location funcModifierLocation, boolean isClassFunction) {
        this(identifier, formalParameters, runsOnRef, mtcReference, systemReference, portReference, returnType, returnsTemplate, templateRestriction, exceptions, block, finallyBlock, true, false, false, null, isDeterministic, isControl, funcModifierLocation);
    }

    public Def_Function(Identifier identifier, FormalParameterList formalParameters, Type returnType) {
        this(identifier, formalParameters, null, null, null, null, returnType, false, null, null, null, null, false, false, null);
    }

    public boolean isStartable() {
        return this.isStartable;
    }

    public static String getKind() {
        return KIND;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.runsOnRef == child) {
            return builder.append(FULLNAMEPART1);
        }
        if (this.formalParameterList == child) {
            return builder.append(FULLNAMEPART2);
        }
        if (this.returnType == child) {
            return builder.append(FULLNAMEPART3);
        }
        if (this.statementBlock == child) {
            return builder.append(FULLNAMEPART4);
        }
        if (this.mtcReference == child) {
            return builder.append(FULLNAMEPART5);
        }
        if (this.systemReference == child) {
            return builder.append(FULLNAMEPART6);
        }
        if (this.portReference == child) {
            return builder.append(FULLNAMEPART7);
        }
        if (this.finallyBlock == child) {
            return builder.append(FULLNAMEPART8);
        }
        return builder;
    }

    public Def_FunctionBase.EncodingPrototype_type getPrototype() {
        return this.prototype;
    }

    public Type getInputType() {
        return this.inputType;
    }

    public Type getOutputType() {
        return this.outputType;
    }

    @Override
    public String getProposalKind() {
        return KIND;
    }

    @Override
    public String getAssignmentName() {
        return KIND;
    }

    @Override
    public String getProposalDescription() {
        StringBuilder nameBuilder = new StringBuilder(this.identifier.getDisplayName());
        nameBuilder.append('(');
        this.formalParameterList.getAsProposalDesriptionPart(nameBuilder);
        nameBuilder.append(')');
        return nameBuilder.toString();
    }

    @Override
    public void setMyScope(Scope scope) {
        if (this.bridgeScope != null && this.bridgeScope.getParentScope() == scope) {
            return;
        }
        this.bridgeScope = new NamedBridgeScope();
        this.bridgeScope.setParentScope(scope);
        scope.addSubScope(this.getLocation(), this.bridgeScope);
        this.bridgeScope.setScopeMacroName(this.identifier.getDisplayName());
        super.setMyScope(this.bridgeScope);
        if (this.runsOnRef != null) {
            this.runsOnRef.setMyScope(this.bridgeScope);
        }
        if (this.mtcReference != null) {
            this.mtcReference.setMyScope(this.bridgeScope);
        }
        if (this.systemReference != null) {
            this.systemReference.setMyScope(this.bridgeScope);
        }
        if (this.portReference != null) {
            this.portReference.setMyScope(this.bridgeScope);
        }
        if (this.formalParameterList != null) {
            this.formalParameterList.setMyScope(this.bridgeScope);
        }
        if (this.returnType != null) {
            this.returnType.setMyScope(this.bridgeScope);
        }
        if (this.statementBlock != null) {
            this.statementBlock.setMyScope(this.formalParameterList);
        }
        if (this.finallyBlock != null) {
            this.finallyBlock.setMyScope(this.formalParameterList);
        }
        if (this.statementBlock != null) {
            this.bridgeScope.addSubScope(this.statementBlock.getLocation(), this.statementBlock);
        }
        if (this.formalParameterList != null) {
            this.bridgeScope.addSubScope(this.formalParameterList.getLocation(), this.formalParameterList);
        }
    }

    public Component_Type getRunsOnType(CompilationTimeStamp timestamp) {
        this.check(timestamp);
        return this.runsOnType;
    }

    public Reference getRunsOnReference(CompilationTimeStamp timestamp) {
        this.check(timestamp);
        return this.runsOnRef;
    }

    public Component_Type getMtcType(CompilationTimeStamp timestamp) {
        this.check(timestamp);
        return this.mtcType;
    }

    public Component_Type getSystemType(CompilationTimeStamp timestamp) {
        this.check(timestamp);
        return this.systemType;
    }

    public IType getPortType(CompilationTimeStamp timestamp) {
        this.check(timestamp);
        return this.portType;
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        this.check(timestamp, null);
    }

    @Override
    public void check(CompilationTimeStamp timestamp, IReferenceChain refChain) {
        Assignment assignment;
        Module module;
        boolean isOopEnabled;
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        this.removeSyntaxDecoration();
        this.isUsed = false;
        this.runsOnType = null;
        this.mtcType = null;
        this.systemType = null;
        this.portType = null;
        this.isStartable = false;
        if (this.exceptions != null && !(isOopEnabled = Activator.getDefault().getPreferenceStore().getBoolean("org.eclipse.titan.designer.enableOOPExtension"))) {
            this.exceptions.getLocation().reportSemanticError(EXCEPTIONSOOP);
        }
        if (this.isClassFunction) {
            if (this.runsOnRef != null) {
                this.runsOnRef.getLocation().reportSemanticError(CLASSNORUNSON);
            }
            if (this.mtcReference != null) {
                this.mtcReference.getLocation().reportSemanticError(CLASSNOMTC);
            }
            if (this.systemReference != null) {
                this.systemReference.getLocation().reportSemanticError(CLASSNOSYSTEM);
            }
        } else {
            if (this.runsOnRef != null && this.portReference != null) {
                this.runsOnRef.getLocation().reportSemanticError("A `runs on' and a `port' clause cannot be present at the same time.");
            }
            if (this.runsOnRef != null) {
                this.runsOnType = this.runsOnRef.chkComponentypeReference(timestamp);
                if (this.runsOnType != null) {
                    Scope formalParlistPreviosScope = this.formalParameterList.getParentScope();
                    if (formalParlistPreviosScope instanceof RunsOnScope && ((RunsOnScope)formalParlistPreviosScope).getParentScope() == this.myScope) {
                        ((RunsOnScope)formalParlistPreviosScope).setComponentType(this.runsOnType);
                    } else {
                        RunsOnScope tempScope = new RunsOnScope(this.runsOnType, this.myScope);
                        this.formalParameterList.setMyScope(tempScope);
                    }
                }
            }
            if (this.mtcReference != null) {
                this.mtcType = this.mtcReference.chkComponentypeReference(timestamp);
            }
            if (this.systemReference != null) {
                this.systemType = this.systemReference.chkComponentypeReference(timestamp);
            }
        }
        boolean canSkip = false;
        if (this.myScope != null && (module = this.myScope.getModuleScope()) != null && module.getSkippedFromSemanticChecking()) {
            canSkip = true;
        }
        if (!canSkip) {
            this.formalParameterList.reset();
        }
        this.formalParameterList.check(timestamp, this.getAssignmentType());
        if (this.returnType != null) {
            IType returnedType;
            if (!this.isConstructor) {
                this.returnType.check(timestamp);
            }
            if (IType.Type_type.TYPE_PORT.equals((Object)(returnedType = this.returnType.getTypeRefdLast(timestamp)).getTypetype()) && this.returnType.getLocation() != null) {
                this.returnType.getLocation().reportSemanticError(PORTRETURNNOTALLOWED);
            }
        }
        if (this.formalParameterList.hasNotusedDefaultValue()) {
            this.formalParameterList.getLocation().reportSemanticError(DASHALLOWEDONLYFORTEMPLATES);
            return;
        }
        this.prototype = Def_FunctionBase.EncodingPrototype_type.NONE;
        this.inputType = null;
        this.outputType = null;
        if (this.withAttributesPath != null) {
            this.withAttributesPath.checkGlobalAttributes(timestamp, false);
            this.withAttributesPath.checkAttributes(timestamp);
            this.analyzeExtensionAttributes(timestamp);
            this.checkPrototype(timestamp);
        }
        if (this.portReference != null && (assignment = this.portReference.getRefdAssignment(timestamp, false)) != null) {
            this.portType = assignment.getType(timestamp);
            if (this.portType != null) {
                if (this.portType.getTypetype() == IType.Type_type.TYPE_PORT) {
                    PortScope tempScope = new PortScope((Port_Type)this.portType, this.myScope);
                    this.formalParameterList.setMyScope(tempScope);
                } else {
                    this.portReference.getLocation().reportSemanticError(MessageFormat.format("Reference `{0}'' does not refer to a port type.", this.portReference.getDisplayName()));
                }
            }
        }
        this.isStartable = this.runsOnRef != null;
        this.isStartable &= this.formalParameterList.getStartability();
        if (this.isStartable && this.returnType != null && this.returnType.isComponentInternal(timestamp)) {
            this.isStartable = false;
        }
        if (canSkip) {
            return;
        }
        for (Scope sc = this.getMyScope(); sc != null && sc instanceof StatementBlock || sc instanceof FormalParameterList || sc instanceof NamedBridgeScope; sc = sc.getParentScope()) {
        }
        NamingConventionHelper.checkConvention("org.eclipse.titan.designer.reportNamingConventionFunction", this.identifier, this);
        NamingConventionHelper.checkNameContents(this.identifier, this.getMyScope().getModuleScope().getIdentifier(), this.getDescription());
        if (this.statementBlock != null) {
            this.statementBlock.check(timestamp);
            if (this.returnType != null && !this.isConstructor) {
                switch (this.statementBlock.hasReturn(timestamp)) {
                    case RS_NO: {
                        String retval = Type.typeToSrcTypeDefault(this.getType(timestamp).getTypetypeTtcn3());
                        this.identifier.getLocation().reportSemanticError("The function has a return type, but it does not have any return statement", new HoverProposal[]{new HoverProposal("Add missing return statement...", "IMG_OBJ_ADD", this.getLocation(), this.getLocation().getEndOffset() - 1, "return " + retval + ";\n")});
                        break;
                    }
                    case RS_MAYBE: {
                        this.identifier.getLocation().reportSemanticError("The function has return type, but control might leave it without reaching a return statement");
                        break;
                    }
                }
            }
            this.statementBlock.postCheck();
            this.statementBlock.setCodeSection(GovernedSimple.CodeSectionType.CS_INLINE);
        }
        if (this.finallyBlock != null) {
            this.finallyBlock.check(timestamp);
        }
        this.checkDocumentComment();
    }

    public boolean checkStartable(CompilationTimeStamp timestamp, Location errorLocation) {
        this.check(timestamp);
        if (this.runsOnRef == null) {
            errorLocation.reportSemanticError(MessageFormat.format("Function `{0}'' cannot be started on parallel test component because it does not have a `runs on'' clause", this.getFullName()));
        }
        this.formalParameterList.checkStartability(timestamp, "Function", this, errorLocation);
        if (this.returnType != null && this.returnType.isComponentInternal(timestamp)) {
            HashSet<IType> typeSet = new HashSet<IType>();
            String errorMessage = "the return type or embedded in the return type of function `" + this.getFullName() + "' if it is started on a parallel test component";
            this.returnType.checkComponentInternal(timestamp, typeSet, errorMessage);
        }
        return this.isStartable;
    }

    public void analyzeExtensionAttributes(CompilationTimeStamp timestamp) {
        List<SingleWithAttribute> realAttributes = this.withAttributesPath.getRealAttributes(timestamp);
        ArrayList<AttributeSpecification> specifications = null;
        for (SingleWithAttribute attribute : realAttributes) {
            Qualifiers qualifiers;
            if (!SingleWithAttribute.Attribute_Type.Extension_Attribute.equals((Object)attribute.getAttributeType()) || (qualifiers = attribute.getQualifiers()) != null && qualifiers.getNofQualifiers() != 0) continue;
            if (specifications == null) {
                specifications = new ArrayList<AttributeSpecification>();
            }
            specifications.add(attribute.getAttributeSpecification());
        }
        if (specifications == null) {
            return;
        }
        ArrayList<ExtensionAttribute> attributes = new ArrayList<ExtensionAttribute>();
        for (AttributeSpecification specification : specifications) {
            ExtensionAttributeAnalyzer analyzer = new ExtensionAttributeAnalyzer();
            analyzer.parse(specification);
            List<ExtensionAttribute> temp = analyzer.getAttributes();
            if (temp == null) continue;
            attributes.addAll(temp);
        }
        for (ExtensionAttribute extensionAttribute : attributes) {
            if (!ExtensionAttribute.ExtensionAttribute_type.PROTOTYPE.equals((Object)extensionAttribute.getAttributeType())) continue;
            PrototypeAttribute realAttribute = (PrototypeAttribute)extensionAttribute;
            if (Def_FunctionBase.EncodingPrototype_type.NONE.equals((Object)this.prototype)) {
                this.prototype = realAttribute.getPrototypeType();
                continue;
            }
            realAttribute.getLocation().reportSingularSemanticError("Duplicate attribute `prototype'");
        }
    }

    public void checkPrototype(CompilationTimeStamp timestamp) {
        if (Def_FunctionBase.EncodingPrototype_type.NONE.equals((Object)this.prototype)) {
            return;
        }
        if (Def_FunctionBase.EncodingPrototype_type.CONVERT.equals((Object)this.prototype)) {
            if (this.formalParameterList.getNofParameters() == 1) {
                FormalParameter parameter = this.formalParameterList.getParameterByIndex(0);
                Assignment.Assignment_type assignmentType = parameter.getRealAssignmentType();
                if (Assignment.Assignment_type.A_PAR_VAL_IN.semanticallyEquals(assignmentType)) {
                    this.inputType = parameter.getType(timestamp);
                } else {
                    parameter.getLocation().reportSemanticError(MessageFormat.format("The parameter must be an `in'' value parameter for attribute `prototype({0})'' instead of {1}", this.prototype.getName(), parameter.getAssignmentName()));
                }
            } else {
                this.formalParameterList.getLocation().reportSemanticError(MessageFormat.format("The function must have one parameter instead of {0} for attribute `prototype({1})''", this.formalParameterList.getNofParameters(), this.prototype.getName()));
            }
        } else if (this.formalParameterList.getNofParameters() == 2) {
            FormalParameter firstParameter = this.formalParameterList.getParameterByIndex(0);
            if (Def_FunctionBase.EncodingPrototype_type.SLIDING.equals((Object)this.prototype)) {
                if (Assignment.Assignment_type.A_PAR_VAL_INOUT.semanticallyEquals(firstParameter.getRealAssignmentType())) {
                    Type firstParameterType = firstParameter.getType(timestamp);
                    IType last = firstParameterType.getTypeRefdLast(timestamp);
                    if (last.getIsErroneous(timestamp)) {
                        this.inputType = firstParameterType;
                    } else {
                        switch (last.getTypetypeTtcn3()) {
                            case TYPE_OCTETSTRING: 
                            case TYPE_CHARSTRING: {
                                this.inputType = firstParameterType;
                                break;
                            }
                            default: {
                                firstParameter.getLocation().reportSemanticError(MessageFormat.format("The type of the first parameter must be `octetstring'' or `charstring'' for attribute `prototype({0})''", this.prototype.getName()));
                            }
                        }
                    }
                } else {
                    firstParameter.getLocation().reportSemanticError(MessageFormat.format("The first parameter must be an `inout'' value parameter for attribute `prototype({0})'' instead of {1}", this.prototype.getName(), firstParameter.getAssignmentName()));
                }
            } else {
                Assignment.Assignment_type assignmentType = firstParameter.getRealAssignmentType();
                if (Assignment.Assignment_type.A_PAR_VAL_IN.semanticallyEquals(assignmentType) || Assignment.Assignment_type.A_PAR_VAL.semanticallyEquals(assignmentType)) {
                    this.inputType = firstParameter.getType(timestamp);
                } else {
                    firstParameter.getLocation().reportSemanticError(MessageFormat.format("The first parameter must be an `in'' value parameter for attribute `prototype({0})'' instead of {1}", this.prototype.getName(), firstParameter.getAssignmentName()));
                }
            }
            FormalParameter secondParameter = this.formalParameterList.getParameterByIndex(1);
            if (Assignment.Assignment_type.A_PAR_VAL_OUT.semanticallyEquals(secondParameter.getRealAssignmentType())) {
                this.outputType = secondParameter.getType(timestamp);
            } else {
                secondParameter.getLocation().reportSemanticError(MessageFormat.format("The second parameter must be an `out'' value parameter for attribute `prototype({0})'' instead of {1}", this.prototype.getName(), secondParameter.getAssignmentName()));
            }
        } else {
            this.formalParameterList.getLocation().reportSemanticError(MessageFormat.format("The function must have two parameters for attribute `prototype({0})'' instead of {1}", this.prototype.getName(), this.formalParameterList.getNofParameters()));
        }
        if (Def_FunctionBase.EncodingPrototype_type.FAST.equals((Object)this.prototype)) {
            if (this.returnType != null) {
                this.returnType.getLocation().reportSemanticError(MessageFormat.format("The function cannot have return type for attribute `prototype({0})''", this.prototype.getName()));
            }
        } else if (this.returnType == null) {
            this.location.reportSemanticError(MessageFormat.format("The function must have a return type for attribute `prototype({0})''", this.prototype.getName()));
        } else {
            if (Assignment.Assignment_type.A_FUNCTION_RTEMP.semanticallyEquals(this.assignmentType)) {
                this.returnType.getLocation().reportSemanticError(MessageFormat.format("The function must return a value instead of a template for attribute `prototype({0})''", this.prototype.getName()));
            }
            if (Def_FunctionBase.EncodingPrototype_type.CONVERT.equals((Object)this.prototype)) {
                this.outputType = this.returnType;
            } else {
                IType last = this.returnType.getTypeRefdLast(timestamp);
                if (!last.getIsErroneous(timestamp) && !IType.Type_type.TYPE_INTEGER.equals((Object)last.getTypetypeTtcn3())) {
                    this.returnType.getLocation().reportSemanticError(MessageFormat.format("The return type of the function must be `integer'' instead of `{0}'' for attribute `prototype({1})''", this.returnType.getTypename(), this.prototype.getName()));
                }
            }
        }
        if (this.runsOnType != null && this.runsOnRef != null) {
            this.runsOnRef.getLocation().reportSemanticError(MessageFormat.format("The function cannot have `runs on'' clause for attribute `prototype({0})''", this.prototype.getName()));
        }
    }

    @Override
    public void postCheck() {
        Module module;
        if (this.myScope != null && (module = this.myScope.getModuleScope()) != null && module.getSkippedFromSemanticChecking()) {
            return;
        }
        super.postCheck();
        this.formalParameterList.postCheck();
    }

    @Override
    public void addProposal(ProposalCollector propCollector, int index) {
        List<ISubReference> subrefs = propCollector.getReference().getSubreferences();
        if (subrefs.size() <= index || ISubReference.Subreference_type.arraySubReference.equals((Object)subrefs.get(index).getReferenceType())) {
            return;
        }
        if (subrefs.size() == index + 1 && this.identifier.getName().toLowerCase(Locale.ENGLISH).startsWith(subrefs.get(index).getId().getName().toLowerCase(Locale.ENGLISH))) {
            StringBuilder patternBuilder = new StringBuilder(this.identifier.getDisplayName());
            patternBuilder.append('(');
            this.formalParameterList.getAsProposalPart(patternBuilder);
            patternBuilder.append(')');
            propCollector.addTemplateProposal(this.identifier.getDisplayName(), new Template(this.getProposalDescription(), "", propCollector.getContextIdentifier(), patternBuilder.toString(), false), TTCN3CodeSkeletons.SKELETON_IMAGE);
            super.addProposal(propCollector, index);
        } else if (subrefs.size() > index + 1 && this.returnType != null && ISubReference.Subreference_type.parameterisedSubReference.equals((Object)subrefs.get(index).getReferenceType()) && this.identifier.getName().equals(subrefs.get(index).getId().getName())) {
            this.returnType.addProposal(propCollector, index + 1);
        }
    }

    @Override
    public void addDeclaration(DeclarationCollector declarationCollector, int index) {
        List<ISubReference> subrefs = declarationCollector.getReference().getSubreferences();
        if (subrefs.size() <= index || ISubReference.Subreference_type.arraySubReference.equals((Object)subrefs.get(index).getReferenceType())) {
            return;
        }
        if (this.identifier.getName().equals(subrefs.get(index).getId().getName())) {
            if (subrefs.size() > index + 1 && this.returnType != null) {
                this.returnType.addDeclaration(declarationCollector, index + 1);
            } else {
                declarationCollector.addDeclaration(this);
            }
        }
    }

    @Override
    public String getOutlineText() {
        StringBuilder text = new StringBuilder(this.identifier.getDisplayName());
        if (this.formalParameterList == null || this.lastTimeChecked == null) {
            return text.toString();
        }
        text.append('(');
        for (int i = 0; i < this.formalParameterList.getNofParameters(); ++i) {
            FormalParameter parameter;
            if (i != 0) {
                text.append(", ");
            }
            if (Assignment.Assignment_type.A_PAR_TIMER.semanticallyEquals((parameter = this.formalParameterList.getParameterByIndex(i)).getRealAssignmentType())) {
                text.append("timer");
                continue;
            }
            Type type = parameter.getType(this.lastTimeChecked);
            if (type == null) {
                text.append("Unknown type");
                continue;
            }
            text.append(type.getTypename());
        }
        text.append(')');
        return text.toString();
    }

    public StyledString getStyledProposalText() {
        StyledString styled = new StyledString(this.identifier.getDisplayName());
        if (this.formalParameterList == null || this.lastTimeChecked == null) {
            return styled;
        }
        styled.append(" ( ");
        Stylers.BlueBoldStyler bluebold = new Stylers.BlueBoldStyler();
        Stylers.BlackItalicStyler blackitalic = new Stylers.BlackItalicStyler();
        for (int i = 0; i < this.formalParameterList.getNofParameters(); ++i) {
            FormalParameter parameter;
            if (i != 0) {
                styled.append(", ");
            }
            if (Assignment.Assignment_type.A_PAR_TIMER.semanticallyEquals((parameter = this.formalParameterList.getParameterByIndex(i)).getRealAssignmentType())) {
                styled.append("timer");
                continue;
            }
            Type type = parameter.getType(this.lastTimeChecked);
            if (type == null) {
                styled.append("Unknown type");
                continue;
            }
            styled.append(type.getTypename(), (StyledString.Styler)bluebold);
            styled.append(' ');
            styled.append(parameter.getGenName(), (StyledString.Styler)blackitalic);
        }
        styled.append(" )");
        return styled;
    }

    public String getProposalText() {
        StringBuilder styled = new StringBuilder(this.identifier.getDisplayName());
        if (this.formalParameterList == null || this.lastTimeChecked == null) {
            return styled.toString();
        }
        styled.append(" (");
        for (int i = 0; i < this.formalParameterList.getNofParameters(); ++i) {
            if (i != 0) {
                styled.append(",");
            }
            styled.append("<br>");
            FormalParameter parameter = this.formalParameterList.getParameterByIndex(i);
            if (Assignment.Assignment_type.A_PAR_TIMER.semanticallyEquals(parameter.getRealAssignmentType())) {
                styled.append("<pre>    timer</pre>");
                continue;
            }
            Type type = parameter.getType(this.lastTimeChecked);
            if (type == null) {
                styled.append("<pre>    Unknown type</pre>");
                continue;
            }
            styled.append("<pre>    " + type.getTypename() + "</pre>");
            styled.append(' ');
            styled.append(parameter.getGenName());
        }
        styled.append("<br>)");
        return styled.toString();
    }

    @Override
    public TemplateRestriction.Restriction_type getTemplateRestriction() {
        return this.templateRestriction;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            this.lastTimeChecked = null;
            boolean enveloped = false;
            Location temporalIdentifier = this.identifier.getLocation();
            if (reparser.envelopsDamage(temporalIdentifier) || reparser.isExtending(temporalIdentifier)) {
                reparser.extendDamagedRegion(temporalIdentifier);
                IdentifierReparser r = new IdentifierReparser(reparser);
                int result = r.parseAndSetNameChanged();
                this.identifier = r.getIdentifier();
                if (result == 0 && this.identifier != null) {
                    enveloped = true;
                } else {
                    this.removeBridge();
                    throw new ReParseException(result);
                }
            }
            if (this.formalParameterList != null) {
                if (enveloped) {
                    this.formalParameterList.updateSyntax(reparser, false);
                    reparser.updateLocation(this.formalParameterList.getLocation());
                } else if (reparser.envelopsDamage(this.formalParameterList.getLocation())) {
                    try {
                        this.formalParameterList.updateSyntax(reparser, true);
                        enveloped = true;
                        reparser.updateLocation(this.formalParameterList.getLocation());
                    }
                    catch (ReParseException e) {
                        this.removeBridge();
                        throw e;
                    }
                }
            }
            if (this.runsOnRef != null) {
                if (enveloped) {
                    this.runsOnRef.updateSyntax(reparser, false);
                    reparser.updateLocation(this.runsOnRef.getLocation());
                } else if (reparser.envelopsDamage(this.runsOnRef.getLocation())) {
                    try {
                        this.runsOnRef.updateSyntax(reparser, true);
                        enveloped = true;
                        reparser.updateLocation(this.runsOnRef.getLocation());
                    }
                    catch (ReParseException e) {
                        this.removeBridge();
                        throw e;
                    }
                }
            }
            if (this.mtcReference != null) {
                if (enveloped) {
                    this.mtcReference.updateSyntax(reparser, false);
                    reparser.updateLocation(this.mtcReference.getLocation());
                } else if (reparser.envelopsDamage(this.mtcReference.getLocation())) {
                    try {
                        this.mtcReference.updateSyntax(reparser, true);
                        enveloped = true;
                        reparser.updateLocation(this.mtcReference.getLocation());
                    }
                    catch (ReParseException e) {
                        this.removeBridge();
                        throw e;
                    }
                }
            }
            if (this.systemReference != null) {
                if (enveloped) {
                    this.systemReference.updateSyntax(reparser, false);
                    reparser.updateLocation(this.systemReference.getLocation());
                } else if (reparser.envelopsDamage(this.systemReference.getLocation())) {
                    try {
                        this.systemReference.updateSyntax(reparser, true);
                        enveloped = true;
                        reparser.updateLocation(this.systemReference.getLocation());
                    }
                    catch (ReParseException e) {
                        this.removeBridge();
                        throw e;
                    }
                }
            }
            if (this.portReference != null) {
                if (enveloped) {
                    this.portReference.updateSyntax(reparser, false);
                    reparser.updateLocation(this.portReference.getLocation());
                } else if (reparser.envelopsDamage(this.portReference.getLocation())) {
                    try {
                        this.portReference.updateSyntax(reparser, true);
                        enveloped = true;
                        reparser.updateLocation(this.portReference.getLocation());
                    }
                    catch (ReParseException e) {
                        this.removeBridge();
                        throw e;
                    }
                }
            }
            if (this.returnType != null) {
                if (enveloped) {
                    this.returnType.updateSyntax(reparser, false);
                    reparser.updateLocation(this.returnType.getLocation());
                } else if (reparser.envelopsDamage(this.returnType.getLocation())) {
                    try {
                        this.returnType.updateSyntax(reparser, true);
                        enveloped = true;
                        reparser.updateLocation(this.returnType.getLocation());
                    }
                    catch (ReParseException e) {
                        this.removeBridge();
                        throw e;
                    }
                }
            }
            if (this.statementBlock != null) {
                if (enveloped) {
                    this.statementBlock.updateSyntax(reparser, false);
                    reparser.updateLocation(this.statementBlock.getLocation());
                } else if (reparser.envelopsDamage(this.statementBlock.getLocation())) {
                    try {
                        this.statementBlock.updateSyntax(reparser, true);
                        enveloped = true;
                        reparser.updateLocation(this.statementBlock.getLocation());
                    }
                    catch (ReParseException e) {
                        this.removeBridge();
                        throw e;
                    }
                }
            }
            if (this.withAttributesPath != null) {
                if (enveloped) {
                    this.withAttributesPath.updateSyntax(reparser, false);
                    reparser.updateLocation(this.withAttributesPath.getLocation());
                } else if (reparser.envelopsDamage(this.withAttributesPath.getLocation())) {
                    try {
                        this.withAttributesPath.updateSyntax(reparser, true);
                        enveloped = true;
                        reparser.updateLocation(this.withAttributesPath.getLocation());
                    }
                    catch (ReParseException e) {
                        this.removeBridge();
                        throw e;
                    }
                }
            }
            if (!enveloped) {
                this.removeBridge();
                throw new ReParseException();
            }
            return;
        }
        reparser.updateLocation(this.identifier.getLocation());
        if (this.formalParameterList != null) {
            this.formalParameterList.updateSyntax(reparser, false);
            reparser.updateLocation(this.formalParameterList.getLocation());
        }
        if (this.runsOnRef != null) {
            this.runsOnRef.updateSyntax(reparser, false);
            reparser.updateLocation(this.runsOnRef.getLocation());
        }
        if (this.mtcReference != null) {
            this.mtcReference.updateSyntax(reparser, false);
            reparser.updateLocation(this.mtcReference.getLocation());
        }
        if (this.systemReference != null) {
            this.systemReference.updateSyntax(reparser, false);
            reparser.updateLocation(this.systemReference.getLocation());
        }
        if (this.portReference != null) {
            this.portReference.updateSyntax(reparser, false);
            reparser.updateLocation(this.portReference.getLocation());
        }
        if (!(this.returnType == null || this.identifier.getName().equals("create") && this.returnType instanceof Class_Type)) {
            this.returnType.updateSyntax(reparser, false);
            reparser.updateLocation(this.returnType.getLocation());
        }
        if (this.statementBlock != null) {
            this.statementBlock.updateSyntax(reparser, false);
            reparser.updateLocation(this.statementBlock.getLocation());
        }
        if (this.withAttributesPath != null) {
            this.withAttributesPath.updateSyntax(reparser, false);
            reparser.updateLocation(this.withAttributesPath.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        super.findReferences(referenceFinder, foundIdentifiers);
        if (this.formalParameterList != null) {
            this.formalParameterList.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.returnType != null) {
            this.returnType.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.runsOnRef != null) {
            this.runsOnRef.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.mtcReference != null) {
            this.mtcReference.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.systemReference != null) {
            this.systemReference.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.portReference != null) {
            this.portReference.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.statementBlock != null) {
            this.statementBlock.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (!super.memberAccept(v)) {
            return false;
        }
        if (this.formalParameterList != null && !this.formalParameterList.accept(v)) {
            return false;
        }
        if (this.returnType != null && this.returnType instanceof Class_Type && !this.isConstructor && !this.returnType.accept(v)) {
            return false;
        }
        if (this.runsOnRef != null && !this.runsOnRef.accept(v)) {
            return false;
        }
        if (this.mtcReference != null && !this.mtcReference.accept(v)) {
            return false;
        }
        if (this.systemReference != null && !this.systemReference.accept(v)) {
            return false;
        }
        if (this.portReference != null && !this.portReference.accept(v)) {
            return false;
        }
        return this.statementBlock == null || this.statementBlock.accept(v);
    }

    @Override
    public void generateCode(JavaGenData aData, boolean cleanUp) {
        if (this.portType != null) {
            return;
        }
        StringBuilder sb = aData.getSrc();
        this.generateCodeInternal(aData, sb);
    }

    public void generateCodePortBody(JavaGenData aData, StringBuilder source) {
        this.generateCodeInternal(aData, source);
    }

    private void generateCodeInternal(JavaGenData aData, StringBuilder source) {
        String genName = this.getGenName();
        if (this.formalParameterList != null) {
            this.formalParameterList.setGenName(genName);
        }
        StringBuilder tempSource = new StringBuilder("public");
        if (this.portType == null) {
            tempSource.append(" static");
        }
        tempSource.append(" final ");
        String returnTypeName = null;
        switch (this.assignmentType) {
            case A_FUNCTION: {
                returnTypeName = "void";
                break;
            }
            case A_FUNCTION_RVAL: {
                returnTypeName = this.returnType.getGenNameValue(aData, tempSource);
                break;
            }
            case A_FUNCTION_RTEMP: {
                returnTypeName = this.returnType.getGenNameTemplate(aData, tempSource);
                break;
            }
            default: {
                ErrorReporter.INTERNAL_ERROR((String)("Code generator reached erroneous definition `" + this.getFullName() + "''"));
            }
        }
        tempSource.append(returnTypeName);
        tempSource.append(' ');
        tempSource.append(genName);
        tempSource.append('(');
        if (this.formalParameterList != null) {
            this.formalParameterList.generateCode(aData, tempSource);
        }
        tempSource.append(") {\n");
        this.getLocation().create_location_object(aData, tempSource, "FUNCTION", this.getIdentifier().getDisplayName());
        if (this.formalParameterList != null) {
            this.formalParameterList.generateCodeSetUnbound(aData, tempSource);
            this.formalParameterList.generateCodeShadowObjects(aData, tempSource);
        }
        if (aData.getAddSourceInfo()) {
            tempSource.append("try {\n");
        }
        this.statementBlock.generateCode(aData, tempSource);
        if (aData.getAddSourceInfo()) {
            tempSource.append("} finally {\n");
            this.getLocation().release_location_object(aData, tempSource);
            tempSource.append("}\n");
        }
        tempSource.append("}\n");
        if (this.isStartable) {
            int i;
            aData.addBuiltinTypeImport("TitanComponent");
            aData.addBuiltinTypeImport("Text_Buf");
            aData.addCommonLibraryImport("TTCN_Logger");
            aData.addCommonLibraryImport("TTCN_Runtime");
            tempSource.append(MessageFormat.format("public static final void start_{0}(final TitanComponent component_reference", genName));
            if (this.formalParameterList != null && this.formalParameterList.getNofParameters() > 0) {
                tempSource.append(", ");
                this.formalParameterList.generateCode(aData, tempSource);
            }
            tempSource.append(") {\n");
            tempSource.append("TTCN_Logger.begin_event(TTCN_Logger.Severity.PARALLEL_PTC);\n");
            tempSource.append(MessageFormat.format("TTCN_Logger.log_event_str(\"Starting function {0}(\");\n", this.identifier.getDisplayName()));
            if (this.formalParameterList != null) {
                for (i = 0; i < this.formalParameterList.getNofParameters(); ++i) {
                    if (i > 0) {
                        tempSource.append("TTCN_Logger.log_event_str(\", \");\n");
                    }
                    tempSource.append(MessageFormat.format("{0}.log();\n", this.formalParameterList.getParameterByIndex(i).getGeneratedReferenceName()));
                }
            }
            tempSource.append("TTCN_Logger.log_event_str(\") on component \");\n");
            tempSource.append("component_reference.log();\n");
            tempSource.append("TTCN_Logger.log_char('.');\n");
            tempSource.append("TTCN_Logger.end_event();\n");
            tempSource.append("final Text_Buf text_buf = new Text_Buf();\n");
            tempSource.append(MessageFormat.format("TTCN_Runtime.prepare_start_component(component_reference, \"{0}\", \"{1}\", text_buf);\n", this.myScope.getModuleScopeGen().getIdentifier().getDisplayName(), this.identifier.getDisplayName()));
            if (this.formalParameterList != null) {
                for (i = 0; i < this.formalParameterList.getNofParameters(); ++i) {
                    tempSource.append(MessageFormat.format("{0}.encode_text(text_buf);\n", this.formalParameterList.getParameterByIndex(i).getGeneratedReferenceName()));
                }
            }
            tempSource.append("TTCN_Runtime.send_start_component(text_buf);\n");
            tempSource.append("}\n");
            StringBuilder startFunction = aData.getStartPTCFunction();
            startFunction.append(MessageFormat.format("if(\"{0}\".equals(function_name)) '{'\n", this.identifier.getDisplayName()));
            if (this.formalParameterList != null) {
                int i2;
                for (i2 = 0; i2 < this.formalParameterList.getNofParameters(); ++i2) {
                    FormalParameter formalParameter = this.formalParameterList.getParameterByIndex(i2);
                    formalParameter.generateCodeObject(aData, startFunction, "", false, true);
                    startFunction.append(MessageFormat.format("\t\t\t{0}.decode_text(function_arguments);\n", formalParameter.getGeneratedReferenceName()));
                }
                startFunction.append("\t\t\tTTCN_Logger.begin_event(TTCN_Logger.Severity.PARALLEL_PTC);\n");
                startFunction.append(MessageFormat.format("\t\t\tTTCN_Logger.log_event_str(\"Starting function {0}(\");\n", this.identifier.getDisplayName()));
                for (i2 = 0; i2 < this.formalParameterList.getNofParameters(); ++i2) {
                    if (i2 > 0) {
                        startFunction.append("\t\t\tTTCN_Logger.log_event_str(\", \");\n");
                    }
                    startFunction.append(MessageFormat.format("\t\t\t{0}.log();\n", this.formalParameterList.getParameterByIndex(i2).getGeneratedReferenceName()));
                }
                startFunction.append("\t\t\tTTCN_Logger.log_event_str(\").\");\n");
                startFunction.append("\t\t\tTTCN_Logger.end_event();\n");
            } else {
                startFunction.append(MessageFormat.format("\t\t\tTTCN_Logger.log_str(TTCN_Logger.Severity.PARALLEL_PTC, \"Starting function {0}().\");\n", this.identifier.getDisplayName()));
            }
            startFunction.append("\t\t\tTTCN_Runtime.function_started(function_arguments);\n");
            StringBuilder actualParList = this.formalParameterList == null ? new StringBuilder() : this.formalParameterList.generateCodeActualParlist("");
            boolean returnValueKept = false;
            if (this.assignmentType == Assignment.Assignment_type.A_FUNCTION_RVAL) {
                IType t = this.returnType;
                while (true) {
                    if (t.hasDoneAttribute()) {
                        returnValueKept = true;
                        break;
                    }
                    if (!(t instanceof Referenced_Type)) break;
                    ReferenceChain referenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
                    IType t2 = ((Referenced_Type)t).getTypeRefd(CompilationTimeStamp.getBaseTimestamp(), referenceChain);
                    referenceChain.release();
                    if (t2.getIsErroneous(CompilationTimeStamp.getBaseTimestamp()) || t2 == t) break;
                    t = t2;
                }
            }
            if (returnValueKept) {
                String returnTypeDisplayName = this.returnType.getTypename();
                startFunction.append(MessageFormat.format("\t\t\tfinal {0} ret_val = new {0}({1}({2}));\n", returnTypeName, genName, actualParList));
                startFunction.append("\t\t\tTTCN_Logger.begin_event(TTCN_Logger.Severity.PARALLEL_UNQUALIFIED);\n");
                startFunction.append(MessageFormat.format("\t\t\tTTCN_Logger.log_event_str(\"Function {0} returned {1} : \");\n", this.identifier.getDisplayName(), returnTypeDisplayName));
                startFunction.append("\t\t\tret_val.log();\n");
                startFunction.append("\t\t\tTTCN_Logger.end_event();\n");
                startFunction.append("\t\t\tfinal Text_Buf text_buf = new Text_Buf();\n");
                startFunction.append(MessageFormat.format("\t\t\tTTCN_Runtime.prepare_function_finished(\"{0}\", text_buf);\n", returnTypeDisplayName));
                startFunction.append("\t\t\tret_val.encode_text(text_buf);\n");
                startFunction.append("\t\t\tTTCN_Runtime.send_function_finished(text_buf);\n");
            } else {
                startFunction.append(MessageFormat.format("\t\t\t{0}({1});\n", genName, actualParList));
                startFunction.append(MessageFormat.format("\t\t\tTTCN_Runtime.function_finished(\"{0}\");\n", this.identifier.getDisplayName()));
            }
            startFunction.append("\t\t\treturn true;\n");
            startFunction.append("\t\t} else ");
        }
        source.append((CharSequence)tempSource);
    }

    @Override
    public Ttcn3HoverContent getHoverContent(IEditorPart editor) {
        super.getHoverContent(editor);
        DocumentComment dc = null;
        if (this.hasDocumentComment() && (dc = this.parseDocumentComment()).isDeprecated()) {
            this.hoverContent.addDeprecated();
        }
        this.hoverContent.addIcon(this.getOutlineIcon()).addText(KIND).addStyledText(this.isDeterministic ? " @deterministic" : "", 2).addStyledText(this.isControl ? " @control " : " ", 2).addStyledText(this.getFullName(), 1).addText("(");
        for (int i = 0; i < this.formalParameterList.getNofParameters(); ++i) {
            FormalParameter fp = this.formalParameterList.getParameterByIndex(i);
            if (i > 0) {
                this.hoverContent.addText(", ");
            }
            this.hoverContent.addText(fp.getFormalParamType()).addText(" ").addText(fp.getType(this.lastTimeChecked).getTypename()).addText(" ").addText(fp.getIdentifier().getDisplayName());
        }
        this.hoverContent.addText(")");
        if (this.runsOnRef != null) {
            this.hoverContent.addText(" runs on ").addStyledText(this.runsOnRef.getDisplayName(), 1);
        }
        if (this.portReference != null) {
            this.hoverContent.addText(" port ").addStyledText(this.portReference.getDisplayName(), 1);
        }
        if (this.mtcReference != null) {
            this.hoverContent.addText(" mtc ").addStyledText(this.mtcReference.getDisplayName(), 1);
        }
        if (this.systemReference != null) {
            this.hoverContent.addText(" system ").addStyledText(this.systemReference.getDisplayName(), 1);
        }
        if (this.returnType != null) {
            this.hoverContent.addText(" return ").addStyledText(this.returnType.getTypename(), 1);
        }
        this.hoverContent.closeHeader();
        this.getHoverContentFromComment(this.hoverContent, dc, this.formalParameterList);
        this.hoverContent.addContent(HoverContentType.INFO);
        return this.hoverContent;
    }

    @Override
    public String generateDocComment(String indentation) {
        return this.generateCommonDocComment(indentation, this.formalParameterList, this.returnType);
    }

    public boolean isOverride() {
        return this.isOverride;
    }

    public void setOverride(boolean isOverride) {
        this.isOverride = isOverride;
    }

    @Override
    public FormalParameterList.IsIdenticalResult isIdentical(CompilationTimeStamp timestamp, Def_FunctionBase other) {
        if (!(other instanceof Def_Function)) {
            return FormalParameterList.IsIdenticalResult.RES_DIFFERS;
        }
        Def_Function otherf = (Def_Function)other;
        Assignment.Assignment_type asstype = this.getAssignmentType();
        Assignment.Assignment_type asstype2 = otherf.getAssignmentType();
        if (this.getAssignmentType() != asstype2 && (asstype == Assignment.Assignment_type.A_FUNCTION && asstype2 != Assignment.Assignment_type.A_EXT_FUNCTION || asstype == Assignment.Assignment_type.A_EXT_FUNCTION && asstype2 != Assignment.Assignment_type.A_FUNCTION || asstype == Assignment.Assignment_type.A_FUNCTION_RVAL && asstype2 != Assignment.Assignment_type.A_EXT_FUNCTION_RVAL || asstype == Assignment.Assignment_type.A_EXT_FUNCTION_RVAL && asstype2 != Assignment.Assignment_type.A_FUNCTION_RVAL || asstype == Assignment.Assignment_type.A_FUNCTION_RTEMP && asstype2 != Assignment.Assignment_type.A_EXT_FUNCTION_RTEMP || asstype == Assignment.Assignment_type.A_EXT_FUNCTION_RTEMP && asstype2 != Assignment.Assignment_type.A_FUNCTION_RTEMP)) {
            return FormalParameterList.IsIdenticalResult.RES_DIFFERS;
        }
        if (this.returnType != null && !otherf.getType(timestamp).isIdentical(timestamp, this.returnType)) {
            return FormalParameterList.IsIdenticalResult.RES_DIFFERS;
        }
        FormalParameterList otherFpl = otherf.getFormalParameterList();
        FormalParameterList.IsIdenticalResult identical = this.getFormalParameterList().isIdentical(timestamp, otherFpl);
        if (identical == FormalParameterList.IsIdenticalResult.RES_DIFFERS) {
            return FormalParameterList.IsIdenticalResult.RES_DIFFERS;
        }
        if (this.exceptions != null || otherf.exceptions != null) {
            if (this.exceptions == null || otherf.exceptions == null) {
                return FormalParameterList.IsIdenticalResult.RES_DIFFERS;
            }
            if (this.exceptions.getNofExceptions() != otherf.exceptions.getNofExceptions()) {
                return FormalParameterList.IsIdenticalResult.RES_DIFFERS;
            }
            for (int i = 0; i < this.exceptions.getNofExceptions(); ++i) {
                if (!otherf.exceptions.hasException(timestamp, this.exceptions.getExceptionByIndex(i))) continue;
                return FormalParameterList.IsIdenticalResult.RES_DIFFERS;
            }
        }
        return identical;
    }
}

