/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.NULL_Location;
import org.eclipse.titan.designer.AST.ParameterisedSubReference;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Code;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Altstep;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.statements.AltGuard;
import org.eclipse.titan.designer.AST.TTCN3.statements.Else_Altguard;
import org.eclipse.titan.designer.AST.TTCN3.statements.Invoke_Altguard;
import org.eclipse.titan.designer.AST.TTCN3.statements.Operation_Altguard;
import org.eclipse.titan.designer.AST.TTCN3.statements.Referenced_Altguard;
import org.eclipse.titan.designer.AST.TTCN3.statements.Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.StatementBlock;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class AltGuards
extends ASTNode
implements IIncrementallyUpdateable {
    private static final String FULLNAMEPART = ".alt_guard_";
    private final ArrayList<AltGuard> altGuards = new ArrayList();
    private boolean hasRepeat = false;
    private String label;
    private boolean isAltstep = false;
    private Location location = NULL_Location.INSTANCE;

    public void setLocation(Location location) {
        this.location = location;
    }

    public Location getLocation() {
        return this.location;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        int size = this.altGuards.size();
        for (int i = 0; i < size; ++i) {
            if (this.altGuards.get(i) != child) continue;
            return builder.append(FULLNAMEPART).append(String.valueOf(i + 1));
        }
        return builder;
    }

    public void addAltGuard(AltGuard altGuard) {
        if (altGuard != null) {
            this.altGuards.add(altGuard);
            altGuard.setFullNameParent(this);
        }
    }

    public int getNofAltguards() {
        return this.altGuards.size();
    }

    public AltGuard getAltguardByIndex(int i) {
        return this.altGuards.get(i);
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        this.altGuards.trimToSize();
        for (AltGuard guard : this.altGuards) {
            guard.setMyScope(scope);
        }
    }

    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        for (AltGuard guard : this.altGuards) {
            guard.setCodeSection(codeSection);
        }
    }

    public void setMyStatementBlock(StatementBlock statementBlock, int index) {
        int size = this.altGuards.size();
        for (int i = 0; i < size; ++i) {
            this.altGuards.get(i).setMyStatementBlock(statementBlock, index);
        }
    }

    public void setMyDefinition(Definition definition) {
        for (AltGuard guard : this.altGuards) {
            guard.setMyDefinition(definition);
        }
    }

    public void setMyAltguards(AltGuards altGuards) {
        for (AltGuard altGuard : this.altGuards) {
            altGuard.setMyAltguards(altGuards);
        }
    }

    public void setMyLaicStmt(AltGuards pAltGuards, Statement pLoopStmt) {
        for (AltGuard altGuard : this.altGuards) {
            altGuard.setMyLaicStmt(pAltGuards, pLoopStmt);
        }
    }

    public void repeatFound() {
        this.hasRepeat = true;
    }

    public String getLabel() {
        return this.label;
    }

    public void setIsAltstep() {
        this.isAltstep = true;
    }

    public boolean getIsAltstep() {
        return this.isAltstep;
    }

    public boolean hasElse() {
        for (AltGuard guard : this.altGuards) {
            if (guard.getType() != AltGuard.altguard_type.AG_ELSE) continue;
            return true;
        }
        return false;
    }

    public StatementBlock.ReturnStatus_type hasReturn(CompilationTimeStamp timestamp) {
        StatementBlock.ReturnStatus_type result = StatementBlock.ReturnStatus_type.RS_MAYBE;
        for (AltGuard guard : this.altGuards) {
            switch (guard.hasReturn(timestamp)) {
                case RS_NO: {
                    if (result == StatementBlock.ReturnStatus_type.RS_YES) {
                        return StatementBlock.ReturnStatus_type.RS_MAYBE;
                    }
                    result = StatementBlock.ReturnStatus_type.RS_NO;
                    break;
                }
                case RS_YES: {
                    if (result == StatementBlock.ReturnStatus_type.RS_NO) {
                        return StatementBlock.ReturnStatus_type.RS_MAYBE;
                    }
                    result = StatementBlock.ReturnStatus_type.RS_YES;
                    break;
                }
                default: {
                    return StatementBlock.ReturnStatus_type.RS_MAYBE;
                }
            }
            if (!(guard instanceof Else_Altguard)) continue;
            break;
        }
        return result;
    }

    public boolean hasReceivingStatement() {
        for (int i = 0; i < this.altGuards.size(); ++i) {
            if (!this.altGuards.get(i).getStatementBlock().hasReceivingStatement(0)) continue;
            return true;
        }
        return false;
    }

    public void check(CompilationTimeStamp timestamp) {
        for (AltGuard guard : this.altGuards) {
            guard.check(timestamp);
        }
    }

    public void checkAllowedInterleave() {
        for (AltGuard guard : this.altGuards) {
            guard.checkAllowedInterleave();
        }
    }

    public void postCheck() {
        for (AltGuard guard : this.altGuards) {
            guard.postCheck();
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            boolean enveloped = false;
            int nofDamaged = 0;
            int leftBoundary = this.location.getOffset();
            int rightBoundary = this.location.getEndOffset();
            int damageOffset = reparser.getDamageStart();
            int size = this.altGuards.size();
            for (int i = 0; i < size && !enveloped; ++i) {
                AltGuard altGuard = this.altGuards.get(i);
                Location temporalLocation = altGuard.getLocation();
                if (reparser.envelopsDamage(temporalLocation)) {
                    enveloped = true;
                    leftBoundary = temporalLocation.getOffset();
                    rightBoundary = temporalLocation.getEndOffset();
                    continue;
                }
                if (reparser.isDamaged(temporalLocation)) {
                    ++nofDamaged;
                    continue;
                }
                if (temporalLocation.getEndOffset() < damageOffset && temporalLocation.getEndOffset() > leftBoundary) {
                    leftBoundary = temporalLocation.getEndOffset();
                }
                if (temporalLocation.getOffset() < damageOffset || temporalLocation.getOffset() >= rightBoundary) continue;
                rightBoundary = temporalLocation.getOffset();
            }
            if (nofDamaged != 0) {
                throw new ReParseException();
            }
            for (AltGuard altGuard : this.altGuards) {
                Location temporalLocation = altGuard.getLocation();
                if (!reparser.isAffectedAppended(temporalLocation)) continue;
                altGuard.updateSyntax(reparser, enveloped && reparser.envelopsDamage(temporalLocation));
                reparser.updateLocation(altGuard.getLocation());
            }
            return;
        }
        for (AltGuard guard : this.altGuards) {
            guard.updateSyntax(reparser, false);
            reparser.updateLocation(guard.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.altGuards == null) {
            return;
        }
        for (AltGuard ag : this.altGuards) {
            ag.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.altGuards != null) {
            for (AltGuard ag : this.altGuards) {
                if (ag.accept(v)) continue;
                return false;
            }
        }
        return true;
    }

    public void generateCodeAlt(JavaGenData aData, StringBuilder source) {
        AltGuard altGuard;
        int i;
        aData.addBuiltinTypeImport("TitanAlt_Status");
        boolean labelNeeded = this.hasRepeat;
        boolean hasElseBranch = false;
        for (i = 0; i < this.altGuards.size(); ++i) {
            altGuard = this.altGuards.get(i);
            switch (altGuard.getType()) {
                case AG_OP: {
                    if (!((Operation_Altguard)altGuard).getGuardStatement().canRepeat()) break;
                    labelNeeded = true;
                    break;
                }
                case AG_REF: 
                case AG_INVOKE: {
                    labelNeeded = true;
                    break;
                }
                case AG_ELSE: {
                    hasElseBranch = true;
                    break;
                }
                default: {
                    ErrorReporter.INTERNAL_ERROR((String)("unknown altguard type encountered `" + this.getFullName() + "''"));
                    return;
                }
            }
            if (hasElseBranch) break;
        }
        if (!hasElseBranch) {
            labelNeeded = true;
        }
        this.label = aData.getTemporaryVariableName();
        if (labelNeeded) {
            source.append(this.label).append(":\n");
        }
        source.append("for ( ; ; ) {\n");
        for (i = 0; i < this.altGuards.size() && !(altGuard = this.altGuards.get(i)).getType().equals((Object)AltGuard.altguard_type.AG_ELSE); ++i) {
            source.append(MessageFormat.format("TitanAlt_Status {0}_alt_flag_{1} = ", this.label, i));
            if (altGuard.getGuardExpression() == null) {
                source.append("TitanAlt_Status.ALT_MAYBE");
            } else {
                source.append("TitanAlt_Status.ALT_UNCHECKED");
            }
            source.append(";\n");
        }
        if (!hasElseBranch) {
            source.append(MessageFormat.format("TitanAlt_Status {0}_default_flag = TitanAlt_Status.ALT_MAYBE;\n", this.label));
        }
        aData.addCommonLibraryImport("TTCN_Snapshot");
        source.append("TTCN_Snapshot.take_new(false);\n");
        source.append("for ( ; ; ) {\n");
        for (i = 0; i < this.altGuards.size(); ++i) {
            altGuard = this.altGuards.get(i);
            AltGuard.altguard_type altGuardType = altGuard.getType();
            if (altGuardType.equals((Object)AltGuard.altguard_type.AG_ELSE)) {
                source.append("TTCN_Snapshot.else_branch_reached();\n");
                StatementBlock block = altGuard.getStatementBlock();
                if (block.getSize() > 0) {
                    source.append("{\n");
                    block.generateCode(aData, source);
                    source.append("}\n");
                }
                if (block.hasReturn(CompilationTimeStamp.getBaseTimestamp()) == StatementBlock.ReturnStatus_type.RS_YES) break;
                source.append("break;\n");
                break;
            }
            IValue guardExpression = altGuard.getGuardExpression();
            if (guardExpression != null) {
                source.append(MessageFormat.format("if ({0}_alt_flag_{1} == TitanAlt_Status.ALT_UNCHECKED) '{'\n", this.label, i));
                guardExpression.getLocation().update_location_object(aData, source);
                ExpressionStruct expression = new ExpressionStruct();
                guardExpression.generateCodeExpression(aData, expression, true);
                source.append((CharSequence)expression.preamble);
                source.append(MessageFormat.format("if(TitanBoolean.get_native({0})) '{'\n", expression.expression));
                source.append(MessageFormat.format("{0}_alt_flag_{1} = TitanAlt_Status.ALT_MAYBE;\n", this.label, i));
                source.append("} else {\n");
                source.append(MessageFormat.format("{0}_alt_flag_{1} = TitanAlt_Status.ALT_NO;\n", this.label, i));
                source.append("}\n");
                source.append("}\n");
            }
            source.append(MessageFormat.format("if ({0}_alt_flag_{1} == TitanAlt_Status.ALT_MAYBE) '{'\n", this.label, i));
            boolean canRepeat = false;
            ExpressionStruct expression = new ExpressionStruct();
            expression.expression.append(MessageFormat.format("{0}_alt_flag_{1} = ", this.label, i));
            switch (altGuardType) {
                case AG_OP: {
                    Statement statement = ((Operation_Altguard)altGuard).getGuardStatement();
                    altGuard.getLocation().update_location_object(aData, source);
                    statement.generateCodeExpression(aData, expression, null);
                    canRepeat = statement.canRepeat();
                    break;
                }
                case AG_REF: {
                    Reference reference = ((Referenced_Altguard)altGuard).getGuardReference();
                    altGuard.getLocation().update_location_object(aData, source);
                    Assignment altstep = reference.getRefdAssignment(CompilationTimeStamp.getBaseTimestamp(), false);
                    expression.expression.append(MessageFormat.format("{0}_instance(", altstep.getGenNameFromScope(aData, source, "")));
                    ISubReference subreference = reference.getSubreferences().get(0);
                    ((ParameterisedSubReference)subreference).getActualParameters().generateCodeAlias(aData, expression, ((Def_Altstep)altstep).getFormalParameterList());
                    expression.expression.append(')');
                    canRepeat = true;
                    break;
                }
                case AG_INVOKE: {
                    altGuard.getLocation().update_location_object(aData, source);
                    ((Invoke_Altguard)altGuard).generateCodeInvokeInstance(aData, expression);
                    canRepeat = true;
                    break;
                }
                default: {
                    ErrorReporter.INTERNAL_ERROR((String)("unknown altguard type encountered `" + this.getFullName() + "''"));
                    return;
                }
            }
            expression.mergeExpression(source);
            if (canRepeat) {
                source.append(MessageFormat.format("if ({0}_alt_flag_{1} == TitanAlt_Status.ALT_REPEAT) continue {2};\n", this.label, i, this.label));
            }
            if (altGuardType.equals((Object)AltGuard.altguard_type.AG_REF) || altGuardType.equals((Object)AltGuard.altguard_type.AG_INVOKE)) {
                source.append(MessageFormat.format("if ({0}_alt_flag_{1} == TitanAlt_Status.ALT_BREAK) break;\n", this.label, i));
            }
            source.append(MessageFormat.format("if ({0}_alt_flag_{1} == TitanAlt_Status.ALT_YES) ", this.label, i));
            StatementBlock block = altGuard.getStatementBlock();
            if (block != null && block.getSize() > 0) {
                source.append("{\n");
                block.generateCode(aData, source);
                if (!StatementBlock.ReturnStatus_type.RS_YES.equals((Object)block.hasReturn(CompilationTimeStamp.getBaseTimestamp()))) {
                    source.append("break;\n");
                }
                source.append("}\n");
            } else {
                source.append("break;\n");
            }
            source.append("}\n");
        }
        if (!hasElseBranch) {
            aData.addCommonLibraryImport("TTCN_Default");
            source.append(MessageFormat.format("if ({0}_default_flag == TitanAlt_Status.ALT_MAYBE) '{'\n", this.label));
            source.append(MessageFormat.format("{0}_default_flag = TTCN_Default.try_altsteps();\n", this.label));
            source.append(MessageFormat.format("if ({0}_default_flag == TitanAlt_Status.ALT_YES || {0}_default_flag == TitanAlt_Status.ALT_BREAK) '{'\n", this.label));
            source.append("break;\n");
            source.append(MessageFormat.format("} else if({0}_default_flag == TitanAlt_Status.ALT_REPEAT) '{'\n", this.label));
            source.append(MessageFormat.format("continue {0};\n", this.label));
            source.append("}\n");
            source.append("}\n");
            this.getLocation().update_location_object(aData, source);
            source.append("if ( ");
            for (i = 0; i < this.altGuards.size(); ++i) {
                source.append(MessageFormat.format("{0}_alt_flag_{1} == TitanAlt_Status.ALT_NO &&", this.label, i));
            }
            source.append(MessageFormat.format("{0}_default_flag == TitanAlt_Status.ALT_NO) '{'\n", this.label));
            source.append("throw new TtcnError(\"None of the branches can be chosen in the alt statement");
            if (this.location != null && this.location.getFile() != null) {
                source.append(MessageFormat.format("in file {0} at line {1}", Code.translate_string(this.location.getFile().getName()), this.location.getLine()));
            }
            source.append("\");\n");
            source.append("}\n");
            source.append("TTCN_Snapshot.take_new(true);\n");
        }
        source.append("}\n");
        source.append("break;\n");
        source.append("}\n");
    }

    public void generateCodeAltstep(JavaGenData aData, StringBuilder source) {
        boolean hasElse = this.hasElse();
        if (!hasElse) {
            source.append("TitanAlt_Status returnValue = TitanAlt_Status.ALT_NO;\n");
        }
        for (int i = 0; i < this.altGuards.size(); ++i) {
            AltGuard altGuard = this.altGuards.get(i);
            AltGuard.altguard_type altGuardType = altGuard.getType();
            if (altGuardType.equals((Object)AltGuard.altguard_type.AG_ELSE)) {
                source.append("TTCN_Snapshot.else_branch_reached();\n");
                StatementBlock block = altGuard.getStatementBlock();
                if (block.getSize() > 0) {
                    source.append("{\n");
                    block.generateCode(aData, source);
                    source.append("}\n");
                }
                if (block.hasReturn(CompilationTimeStamp.getBaseTimestamp()) == StatementBlock.ReturnStatus_type.RS_YES) break;
                source.append("return TitanAlt_Status.ALT_YES;\n");
                break;
            }
            AtomicInteger blockCount = new AtomicInteger(0);
            IValue guardExpression = altGuard.getGuardExpression();
            if (guardExpression != null) {
                guardExpression.getLocation().update_location_object(aData, source);
                if (guardExpression.returnsNative()) {
                    guardExpression.generateCodeTmp(aData, source, "if (", blockCount);
                    source.append(") {\n");
                } else {
                    aData.addBuiltinTypeImport("TitanBoolean");
                    guardExpression.generateCodeTmp(aData, source, "if (TitanBoolean.get_native(", blockCount);
                    source.append(") ) {\n");
                }
                blockCount.incrementAndGet();
            }
            boolean canRepeat = false;
            ExpressionStruct expression = new ExpressionStruct();
            switch (altGuardType) {
                case AG_OP: {
                    Statement statement = ((Operation_Altguard)altGuard).getGuardStatement();
                    altGuard.getLocation().update_location_object(aData, source);
                    statement.generateCodeExpression(aData, expression, null);
                    canRepeat = statement.canRepeat();
                    break;
                }
                case AG_REF: {
                    Reference reference = ((Referenced_Altguard)altGuard).getGuardReference();
                    altGuard.getLocation().update_location_object(aData, source);
                    Assignment altstep = reference.getRefdAssignment(CompilationTimeStamp.getBaseTimestamp(), false);
                    expression.expression.append(MessageFormat.format("{0}_instance(", altstep.getGenNameFromScope(aData, source, "")));
                    ISubReference subreference = reference.getSubreferences().get(0);
                    ((ParameterisedSubReference)subreference).getActualParameters().generateCodeAlias(aData, expression, ((Def_Altstep)altstep).getFormalParameterList());
                    expression.expression.append(')');
                    canRepeat = true;
                    break;
                }
                case AG_INVOKE: {
                    altGuard.getLocation().update_location_object(aData, source);
                    ((Invoke_Altguard)altGuard).generateCodeInvokeInstance(aData, expression);
                    canRepeat = true;
                    break;
                }
                default: {
                    ErrorReporter.INTERNAL_ERROR((String)("unknown altguard type encountered `" + this.getFullName() + "''"));
                    return;
                }
            }
            if (expression.preamble.length() > 0 || expression.postamble.length() > 0) {
                if (blockCount.get() == 0) {
                    source.append("{\n");
                    blockCount.set(blockCount.get() + 1);
                }
                String tempId = aData.getTemporaryVariableName();
                source.append(MessageFormat.format("TitanAlt_Status {0};\n", tempId));
                source.append("{\n");
                source.append((CharSequence)expression.preamble);
                source.append(MessageFormat.format("{0} = {1};\n", tempId, expression.expression));
                source.append((CharSequence)expression.postamble);
                source.append("}\n");
                source.append(MessageFormat.format("switch ({0}) '{'\n", tempId));
            } else {
                source.append(MessageFormat.format("switch ({0}) '{'\n", expression.expression));
            }
            source.append("case ALT_YES:\n");
            StatementBlock block = altGuard.getStatementBlock();
            if (block != null && block.getSize() > 0) {
                source.append("{\n");
                block.generateCode(aData, source);
                source.append("}\n");
            }
            if (block == null || block.hasReturn(CompilationTimeStamp.getBaseTimestamp()) != StatementBlock.ReturnStatus_type.RS_YES) {
                source.append("return TitanAlt_Status.ALT_YES;\n");
            }
            if (canRepeat) {
                source.append("case ALT_REPEAT:\n");
                source.append("return TitanAlt_Status.ALT_REPEAT;\n");
            }
            if (altGuardType == AltGuard.altguard_type.AG_REF || altGuardType == AltGuard.altguard_type.AG_INVOKE) {
                source.append("case ALT_BREAK:\n");
                source.append("return TitanAlt_Status.ALT_BREAK;\n");
            }
            if (!hasElse) {
                source.append("case ALT_MAYBE:\n");
                source.append("returnValue = TitanAlt_Status.ALT_MAYBE;\n");
            }
            source.append("default:\n");
            source.append("break;\n");
            source.append("}\n");
            for (int j = 0; j < blockCount.get(); ++j) {
                source.append("}\n");
            }
        }
        if (!hasElse) {
            source.append("return returnValue;\n");
        }
    }

    public void generateCodeCallBody(JavaGenData aData, StringBuilder source, String tempId, String callTimer, boolean inInterleave) {
        AltGuard altGuard;
        int i;
        aData.addBuiltinTypeImport("TitanAlt_Status");
        if (this.hasRepeat) {
            source.append(MessageFormat.format("{0}:", tempId));
        }
        for (i = 0; i < this.altGuards.size(); ++i) {
            altGuard = this.altGuards.get(i);
            source.append(MessageFormat.format("TitanAlt_Status {0}_alt_flag_{1} = ", tempId, i));
            if (altGuard.getGuardExpression() == null) {
                source.append("TitanAlt_Status.ALT_MAYBE");
            } else {
                source.append("TitanAlt_Status.ALT_UNCHECKED");
            }
            source.append(";\n");
        }
        this.getLocation().update_location_object(aData, source);
        aData.addCommonLibraryImport("TTCN_Snapshot");
        source.append("TTCN_Snapshot.take_new(false);\n");
        source.append("for ( ; ; ) {\n");
        for (i = 0; i < this.altGuards.size(); ++i) {
            ExpressionStruct expression;
            altGuard = this.altGuards.get(i);
            if (!(altGuard instanceof Operation_Altguard)) continue;
            IValue guardExpression = altGuard.getGuardExpression();
            if (guardExpression != null) {
                source.append(MessageFormat.format("if ( {0}_alt_flag_{1} == TitanAlt_Status.ALT_UNCHECKED) '{'\n", tempId, i));
                guardExpression.getLocation().update_location_object(aData, source);
                expression = new ExpressionStruct();
                guardExpression.generateCodeExpression(aData, expression, true);
                source.append((CharSequence)expression.preamble);
                source.append(MessageFormat.format("if (TitanBoolean.get_native({0})) '{'\n", expression.expression));
                source.append(MessageFormat.format("{0}_alt_flag_{1} = TitanAlt_Status.ALT_MAYBE;\n", tempId, i));
                source.append("} else {\n");
                source.append(MessageFormat.format("{0}_alt_flag_{1} = TitanAlt_Status.ALT_NO;\n", tempId, i));
                source.append("}\n");
                source.append((CharSequence)expression.postamble);
                source.append("}\n");
            }
            source.append(MessageFormat.format("if ( {0}_alt_flag_{1} == TitanAlt_Status.ALT_MAYBE) '{'\n", tempId, i));
            expression = new ExpressionStruct();
            expression.expression.append(MessageFormat.format("{0}_alt_flag_{1} = ", tempId, i));
            Statement statement = ((Operation_Altguard)altGuard).getGuardStatement();
            statement.getLocation().update_location_object(aData, source);
            statement.generateCodeExpression(aData, expression, callTimer);
            expression.mergeExpression(source);
            source.append(MessageFormat.format("if ( {0}_alt_flag_{1} == TitanAlt_Status.ALT_YES) '{'\n", tempId, i));
            StatementBlock block = ((Operation_Altguard)altGuard).getStatementBlock();
            if (inInterleave) {
                if (block != null && block.getSize() > 0) {
                    if (block.hasReceivingStatement(0)) {
                        source.append(MessageFormat.format("continue {0}_branch{1};\n", tempId, i));
                    } else {
                        source.append("{\n");
                        block.generateCode(aData, source);
                        source.append(MessageFormat.format("continue {0}_end;\n", tempId));
                        source.append("}\n");
                    }
                } else {
                    source.append(MessageFormat.format("continue {0}_end;\n", tempId));
                }
            } else if (block != null && block.getSize() > 0) {
                source.append("{\n");
                block.generateCode(aData, source);
                if (block.hasReturn(CompilationTimeStamp.getBaseTimestamp()) != StatementBlock.ReturnStatus_type.RS_YES) {
                    source.append("break;\n");
                }
                source.append("}\n");
            } else {
                source.append("break;\n");
            }
            source.append("}\n");
            source.append("}\n");
        }
        this.getLocation().update_location_object(aData, source);
        source.append("if (");
        for (i = 0; i < this.altGuards.size(); ++i) {
            if (i > 0) {
                source.append(" && ");
            }
            source.append(MessageFormat.format("{0}_alt_flag_{1} == TitanAlt_Status.ALT_NO", tempId, i));
        }
        source.append(") {\n");
        source.append("throw new TtcnError(\"None of the branches can be chosen in the response and exception handling part of call statement in file");
        if (this.location != null && this.location.getFile() != null) {
            source.append(MessageFormat.format("in file {0} at line {1}", Code.translate_string(this.location.getFile().getName()), this.location.getLine()));
        }
        source.append("\");\n");
        source.append("}\n");
        source.append("TTCN_Snapshot.take_new(true);\n");
        source.append("}\n");
    }
}

