/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.statements.LogArgument;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class LogArguments
extends ASTNode
implements IIncrementallyUpdateable {
    private static final String FULLNAMEPART = ".logargs_";
    private final ArrayList<LogArgument> arguments;

    public LogArguments() {
        this.arguments = new ArrayList();
    }

    public LogArguments(ArrayList<LogArgument> arguments) {
        if (arguments == null) {
            this.arguments = new ArrayList();
        } else {
            for (LogArgument logArgument : arguments) {
                logArgument.setFullNameParent(this);
            }
            this.arguments = arguments;
        }
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        int size = this.arguments.size();
        for (int i = 0; i < size; ++i) {
            if (this.arguments.get(i) != child) continue;
            return builder.append(FULLNAMEPART).append(Integer.toString(i + 1));
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        for (LogArgument argument : this.arguments) {
            argument.setMyScope(scope);
        }
    }

    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        for (LogArgument argument : this.arguments) {
            argument.setCodeSection(codeSection);
        }
    }

    public int getNofLogArguments() {
        return this.arguments.size();
    }

    public LogArgument getLogArgumentByIndex(int index) {
        return this.arguments.get(index);
    }

    public void check(CompilationTimeStamp timestamp) {
        for (LogArgument argument : this.arguments) {
            argument.check(timestamp);
        }
    }

    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        for (LogArgument argument : this.arguments) {
            argument.checkRecursions(timestamp, referenceChain);
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        for (LogArgument argument : this.arguments) {
            argument.updateSyntax(reparser, false);
            reparser.updateLocation(argument.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        for (LogArgument logArgument : this.arguments) {
            logArgument.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        for (LogArgument la : this.arguments) {
            if (la.accept(v)) continue;
            return false;
        }
        return true;
    }

    public void generateCode(JavaGenData aData, StringBuilder source) {
        for (int i = 0; i < this.arguments.size(); ++i) {
            this.arguments.get(i).generateCode(aData, source);
        }
    }

    public void generateCodeExpression(JavaGenData aData, ExpressionStruct expression) {
        aData.addCommonLibraryImport("TTCN_Logger");
        aData.addBuiltinTypeImport("TitanCharString");
        expression.preamble.append("TTCN_Logger.begin_event_log2str();\n");
        int size = this.arguments.size();
        for (int i = 0; i < size; ++i) {
            this.arguments.get(i).generateCode(aData, expression.preamble);
        }
        String tempId = aData.getTemporaryVariableName();
        expression.preamble.append(MessageFormat.format("final TitanCharString {0} = TTCN_Logger.end_event_log2str();\n", tempId));
        expression.expression.append(tempId);
    }
}

