/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.statements.Parameter_Redirection;
import org.eclipse.titan.designer.AST.TTCN3.statements.Variable_Entries;
import org.eclipse.titan.designer.AST.TTCN3.statements.Variable_Entry;
import org.eclipse.titan.designer.AST.TTCN3.templates.TemplateInstance;
import org.eclipse.titan.designer.AST.TTCN3.types.SignatureFormalParameter;
import org.eclipse.titan.designer.AST.TTCN3.types.SignatureFormalParameterList;
import org.eclipse.titan.designer.AST.TTCN3.types.Signature_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class VariableList_Parameter_Redirection
extends Parameter_Redirection {
    private static final String FULLNAMEPART = ".parametervariables";
    private final Variable_Entries entries;

    public VariableList_Parameter_Redirection(Variable_Entries entries) {
        this.entries = entries;
        if (entries != null) {
            entries.setFullNameParent(this);
        }
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.entries == child) {
            return builder.append(FULLNAMEPART);
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.entries != null) {
            this.entries.setMyScope(scope);
        }
    }

    @Override
    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        if (this.entries != null) {
            this.entries.setCodeSection(codeSection);
        }
    }

    @Override
    public boolean hasDecodedModifier() {
        int size = this.entries.getNofEntries();
        for (int i = 0; i < size; ++i) {
            Variable_Entry entry = this.entries.getEntryByIndex(i);
            if (!entry.isDecoded()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void checkErroneous(CompilationTimeStamp timestamp) {
        int size = this.entries.getNofEntries();
        for (int i = 0; i < size; ++i) {
            Variable_Entry entry = this.entries.getEntryByIndex(i);
            this.checkVariableReference(timestamp, entry.getReference(), null);
        }
    }

    @Override
    public void check(CompilationTimeStamp timestamp, Signature_Type signature, boolean isOut) {
        int nofParameters;
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.checkErroneous(timestamp);
        if (signature == null) {
            return;
        }
        SignatureFormalParameterList parameterList = signature.getParameterList();
        if (parameterList.getNofParameters() == 0) {
            this.getLocation().reportSemanticError(MessageFormat.format("Parameter redirect cannot be used because signature `{0}'' does not have parameters", signature.getTypename()));
            this.checkErroneous(timestamp);
            return;
        }
        int nofVariableEntries = this.entries.getNofEntries();
        int n = nofParameters = isOut ? parameterList.getNofOutParameters() : parameterList.getNofInParameters();
        if (nofVariableEntries != nofParameters) {
            this.getLocation().reportSemanticError(MessageFormat.format("Too {0} variable entries compared to the number of {1}/inout parameters in signature `{2}'': {3} was expected instead of {4}", nofVariableEntries > nofParameters ? "many" : "few", isOut ? "out" : "in", signature.getTypename(), nofParameters, nofVariableEntries));
        }
        for (int i = 0; i < nofVariableEntries; ++i) {
            Variable_Entry entry = this.entries.getEntryByIndex(i);
            if (i < nofParameters) {
                SignatureFormalParameter parameter = isOut ? parameterList.getOutParameterByIndex(i) : parameterList.getInParameterByIndex(i);
                this.checkVariableReference(timestamp, entry.getReference(), parameter.getType());
                continue;
            }
            this.checkVariableReference(timestamp, entry.getReference(), null);
        }
        this.lastTimeChecked = timestamp;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        this.entries.updateSyntax(reparser, isDamaged);
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.entries == null) {
            return;
        }
        this.entries.findReferences(referenceFinder, foundIdentifiers);
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        return this.entries == null || this.entries.accept(v);
    }

    @Override
    public void generateCode(JavaGenData aData, ExpressionStruct expression, TemplateInstance matched_ti, String lastGenTIExpression, boolean is_out) {
        this.internalGenerateCode(aData, expression, this.entries, matched_ti, lastGenTIExpression, is_out);
    }

    @Override
    public void generateCodeDecoded(JavaGenData aData, StringBuilder source, TemplateInstance matched_ti, String tempID, boolean is_out) {
        this.internalGenerateCodeDecoded(aData, source, this.entries, matched_ti, tempID, is_out);
    }
}

