/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.types;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.ITypeWithComponents;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.NULL_Location;
import org.eclipse.titan.designer.AST.ParameterisedSubReference;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.attributes.JsonAST;
import org.eclipse.titan.designer.AST.TTCN3.attributes.RawAST;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Type;
import org.eclipse.titan.designer.AST.TTCN3.definitions.IMemberInfo;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.types.EnumItem;
import org.eclipse.titan.designer.AST.TTCN3.types.EnumeratedGenerator;
import org.eclipse.titan.designer.AST.TTCN3.types.EnumerationItems;
import org.eclipse.titan.designer.AST.TTCN3.types.TTCN3_Set_Seq_Choice_BaseType;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.SubType;
import org.eclipse.titan.designer.AST.TTCN3.values.Bitstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Hexstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Integer_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Octetstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Undefined_LowerIdentifier_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.Bit2IntExpression;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.Hex2IntExpression;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.AST.TypeCompatibilityInfo;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.compiler.BuildTimestamp;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.editors.controls.HoverContentType;
import org.eclipse.titan.designer.editors.controls.Ttcn3HoverContent;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class TTCN3_Enumerated_Type
extends Type
implements ITypeWithComponents,
IMemberInfo {
    public static final String COMPILE_TIME_VALUE_CHECK = "A value known at compile time was expected for enumeration `{0}''";
    public static final String VALUE_TYPE_CHECK = "INTEGER or BITSTRING or OCTETSTRING or HEXSTRING value was expected for enumeration `{0}''";
    public static final String DUPLICATEENUMERATIONIDENTIFIERFIRST = "Duplicate enumeration identifier `{0}'' was first declared here";
    public static final String DUPLICATEENUMERATIONIDENTIFIERREPEATED = "Duplicate enumeration identifier `{0}'' was declared here again";
    public static final String DUPLICATEDENUMERATIONVALUEFIRST = "Value {0} is already assigned to `{1}''";
    public static final String DUPLICATEDENUMERATIONVALUEREPEATED = "Duplicate numeric value {0} for enumeration `{1}''";
    private static final String TTCN3ENUMERATEDVALUEEXPECTED = "Enumerated value was expected";
    private static final String ASN1ENUMERATEDVALUEEXPECTED = "ENUMERATED value was expected";
    private static final String TEMPLATENOTALLOWED = "{0} cannot be used for enumerated type";
    private static final String LENGTHRESTRICTIONNOTALLOWED = "Length restriction is not allowed for enumerated type";
    private static final String LARGEINTEGERERROR = "Using a large integer value ({0}) as an ENUMERATED/enumerated value is not supported";
    private final EnumerationItems items;
    private Map<String, EnumItem> nameMap;

    public TTCN3_Enumerated_Type(EnumerationItems items) {
        this.items = items;
        if (items != null) {
            items.setFullNameParent(this);
        }
    }

    @Override
    public IType.Type_type getTypetype() {
        return IType.Type_type.TYPE_TTCN3_ENUMERATED;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.items != null) {
            this.items.setMyScope(scope);
        }
    }

    @Override
    public boolean isCompatible(CompilationTimeStamp timestamp, IType otherType, TypeCompatibilityInfo info, TypeCompatibilityInfo.Chain leftChain, TypeCompatibilityInfo.Chain rightChain) {
        this.check(timestamp);
        otherType.check(timestamp);
        IType temp = otherType.getTypeRefdLast(timestamp);
        if (this.getIsErroneous(timestamp) || temp.getIsErroneous(timestamp)) {
            return true;
        }
        return this == temp;
    }

    @Override
    public boolean isIdentical(CompilationTimeStamp timestamp, IType type) {
        return this.isCompatible(timestamp, type, null, null, null);
    }

    @Override
    public IType.Type_type getTypetypeTtcn3() {
        if (this.isErroneous) {
            return IType.Type_type.TYPE_UNDEFINED;
        }
        return this.getTypetype();
    }

    @Override
    public String getTypename() {
        return this.getFullName();
    }

    @Override
    public String getOutlineIcon() {
        return "enumeration.gif";
    }

    public boolean hasEnumItemWithName(Identifier identifier) {
        if (this.lastTimeChecked == null) {
            this.check(CompilationTimeStamp.getBaseTimestamp());
        }
        return this.nameMap.containsKey(identifier.getName());
    }

    public EnumItem getEnumItemWithName(Identifier identifier) {
        if (this.lastTimeChecked == null) {
            this.check(CompilationTimeStamp.getBaseTimestamp());
        }
        return this.nameMap.get(identifier.getName());
    }

    public List<EnumItem> getEnumItems() {
        ArrayList<EnumItem> items = new ArrayList<EnumItem>();
        for (Map.Entry<String, EnumItem> entry : this.nameMap.entrySet()) {
            items.add(entry.getValue());
        }
        return items;
    }

    public List<EnumItem> getEnumItemsOrdered() {
        return new ArrayList<EnumItem>(this.items.getItems());
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        Object item;
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.initAttributes(timestamp);
        List<EnumItem> enumItems = this.items.getItems();
        int nofItems = enumItems.size();
        this.nameMap = new HashMap<String, EnumItem>(nofItems);
        HashMap<Long, EnumItem> valueMap = new HashMap<Long, EnumItem>(nofItems);
        for (int i = 0; i < nofItems; ++i) {
            item = enumItems.get(i);
            this.checkEnumItem(timestamp, (EnumItem)item, valueMap);
        }
        if (!this.getIsErroneous(timestamp) && this.lastTimeChecked == null) {
            Long firstUnused = 0L;
            while (valueMap.containsKey(firstUnused)) {
                item = firstUnused;
                Long l = firstUnused = Long.valueOf(firstUnused + 1L);
            }
            for (int i = 0; i < nofItems; ++i) {
                EnumItem item2 = enumItems.get(i);
                if (item2.isOriginal()) continue;
                Value value = item2.getValue();
                if (value == null || ((Integer_Value)value).getValue() != firstUnused.longValue()) {
                    Integer_Value tempValue = new Integer_Value(firstUnused);
                    tempValue.setLocation(item2.getLocation());
                    item2.setValue(tempValue);
                }
                valueMap.put(firstUnused, item2);
                firstUnused = firstUnused + 1L;
                while (valueMap.containsKey(firstUnused)) {
                    Long l = firstUnused;
                    Long l2 = firstUnused = Long.valueOf(firstUnused + 1L);
                }
            }
        }
        valueMap.clear();
        this.lastTimeChecked = timestamp;
        this.checkSubtypeRestrictions(timestamp);
        if (this.myScope != null) {
            this.checkEncode(timestamp);
            this.checkVariants(timestamp);
        }
    }

    private void checkEnumItem(CompilationTimeStamp timestamp, EnumItem item, Map<Long, EnumItem> valueMap) {
        Identifier id = item.getId();
        String fieldName = id.getName();
        if (this.nameMap.containsKey(fieldName)) {
            this.nameMap.get(fieldName).getId().getLocation().reportSingularSemanticError(MessageFormat.format(DUPLICATEENUMERATIONIDENTIFIERFIRST, id.getDisplayName()));
            id.getLocation().reportSemanticError(MessageFormat.format(DUPLICATEENUMERATIONIDENTIFIERREPEATED, id.getDisplayName()));
        } else {
            this.nameMap.put(fieldName, item);
        }
        IValue value = item.getValue();
        if (value != null && item.isOriginal()) {
            ReferenceChain referenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
            if (IValue.Value_type.UNDEFINED_LOWERIDENTIFIER_VALUE.equals((Object)value.getValuetype())) {
                IValue refd;
                IValue ref = value.setLoweridToReference(timestamp);
                IValue iValue = refd = ref != null ? ref.getValueRefdLast(timestamp, referenceChain) : null;
                if (refd == null) {
                    value.getLocation().reportSemanticError(MessageFormat.format(VALUE_TYPE_CHECK, id.getDisplayName()));
                    this.setIsErroneous(true);
                    return;
                }
                value = refd;
            }
            if (value.isUnfoldable(timestamp)) {
                value.getLocation().reportSemanticError(MessageFormat.format(COMPILE_TIME_VALUE_CHECK, id.getDisplayName()));
                this.setIsErroneous(true);
                return;
            }
            if (value.getIsErroneous(timestamp)) {
                value.getLocation().reportSemanticError(MessageFormat.format(VALUE_TYPE_CHECK, id.getDisplayName()));
                this.setIsErroneous(true);
                return;
            }
            block0 : switch (value.getValuetype()) {
                case INTEGER_VALUE: {
                    Integer_Value intValue = (Integer_Value)value;
                    this.setAndCheckEnumIntegerValue(timestamp, item, valueMap, intValue);
                    break;
                }
                case BITSTRING_VALUE: {
                    Bitstring_Value bitValue = (Bitstring_Value)value;
                    this.setAndCheckEnumIntegerValue(timestamp, item, valueMap, Bit2IntExpression.bit2int(bitValue.getValue()));
                    break;
                }
                case OCTETSTRING_VALUE: {
                    Octetstring_Value octetValue = (Octetstring_Value)value;
                    this.setAndCheckEnumIntegerValue(timestamp, item, valueMap, Hex2IntExpression.hex2int(octetValue.getValue()));
                    break;
                }
                case HEXSTRING_VALUE: {
                    Hexstring_Value hexValue = (Hexstring_Value)value;
                    this.setAndCheckEnumIntegerValue(timestamp, item, valueMap, Hex2IntExpression.hex2int(hexValue.getValue()));
                    break;
                }
                case EXPRESSION_VALUE: {
                    Expression_Value expressionValue = (Expression_Value)value;
                    IValue evaluatedValue = expressionValue.evaluateValue(timestamp, Expected_Value_type.EXPECTED_CONSTANT, referenceChain);
                    IType.Type_type type = expressionValue.getExpressionReturntype(timestamp, Expected_Value_type.EXPECTED_CONSTANT);
                    switch (type) {
                        case TYPE_INTEGER: {
                            Integer_Value intExpressionValue = (Integer_Value)evaluatedValue;
                            this.setAndCheckEnumIntegerValue(timestamp, item, valueMap, new Integer_Value(intExpressionValue.getValue()));
                            break block0;
                        }
                        case TYPE_BITSTRING: {
                            Bitstring_Value bitExpressionValue = (Bitstring_Value)evaluatedValue;
                            this.setAndCheckEnumIntegerValue(timestamp, item, valueMap, Bit2IntExpression.bit2int(bitExpressionValue.getValue()));
                            break block0;
                        }
                        case TYPE_OCTETSTRING: {
                            Octetstring_Value octetExpressionValue = (Octetstring_Value)evaluatedValue;
                            this.setAndCheckEnumIntegerValue(timestamp, item, valueMap, Hex2IntExpression.hex2int(octetExpressionValue.getValue()));
                            break block0;
                        }
                        case TYPE_HEXSTRING: {
                            Hexstring_Value hexExpressionValue = (Hexstring_Value)evaluatedValue;
                            this.setAndCheckEnumIntegerValue(timestamp, item, valueMap, Hex2IntExpression.hex2int(hexExpressionValue.getValue()));
                            break block0;
                        }
                    }
                    value.getLocation().reportSemanticError(MessageFormat.format(VALUE_TYPE_CHECK, id.getDisplayName()));
                    this.setIsErroneous(true);
                    break;
                }
                default: {
                    value.getLocation().reportSemanticError(MessageFormat.format(VALUE_TYPE_CHECK, id.getDisplayName()));
                    this.setIsErroneous(true);
                }
            }
        }
    }

    private void setAndCheckEnumIntegerValue(CompilationTimeStamp timestamp, EnumItem item, Map<Long, EnumItem> valueMap, Integer_Value enumIntValue) {
        item.setValue(enumIntValue);
        if (!enumIntValue.isNative()) {
            enumIntValue.getLocation().reportSemanticError(MessageFormat.format(LARGEINTEGERERROR, enumIntValue.getValueValue()));
            this.setIsErroneous(true);
        } else {
            Long enumLong = enumIntValue.getValue();
            if (valueMap.containsKey(enumLong)) {
                valueMap.get(enumLong).getLocation().reportSingularSemanticError(MessageFormat.format(DUPLICATEDENUMERATIONVALUEFIRST, enumLong, valueMap.get(enumLong).getId().getDisplayName()));
                enumIntValue.getLocation().reportSemanticError(MessageFormat.format(DUPLICATEDENUMERATIONVALUEREPEATED, enumLong, item.getId().getDisplayName()));
                this.setIsErroneous(true);
            } else {
                valueMap.put(enumLong, item);
            }
        }
    }

    @Override
    public SubType.SubType_type getSubtypeType() {
        return SubType.SubType_type.ST_ENUM;
    }

    @Override
    public IValue checkThisValueRef(CompilationTimeStamp timestamp, IValue value) {
        if (IValue.Value_type.UNDEFINED_LOWERIDENTIFIER_VALUE.equals((Object)value.getValuetype()) && this.hasEnumItemWithName(((Undefined_LowerIdentifier_Value)value).getIdentifier())) {
            IValue temp = value.setValuetype(timestamp, IValue.Value_type.ENUMERATED_VALUE);
            temp.setMyGovernor(this);
            return temp;
        }
        return super.checkThisValueRef(timestamp, value);
    }

    @Override
    public boolean checkThisValue(CompilationTimeStamp timestamp, IValue value, Assignment lhs, IType.ValueCheckingOptions valueCheckingOptions) {
        if (this.getIsErroneous(timestamp)) {
            return false;
        }
        boolean selfReference = super.checkThisValue(timestamp, value, lhs, valueCheckingOptions);
        IValue last = value.getValueRefdLast(timestamp, valueCheckingOptions.expected_value, null);
        if (last == null || last.getIsErroneous(timestamp)) {
            return selfReference;
        }
        switch (value.getValuetype()) {
            case OMIT_VALUE: 
            case REFERENCED_VALUE: {
                return selfReference;
            }
            case UNDEFINED_LOWERIDENTIFIER_VALUE: {
                if (!IValue.Value_type.REFERENCED_VALUE.equals((Object)last.getValuetype())) break;
                return selfReference;
            }
        }
        switch (last.getValuetype()) {
            case ENUMERATED_VALUE: {
                break;
            }
            case EXPRESSION_VALUE: 
            case MACRO_VALUE: {
                break;
            }
            default: {
                value.getLocation().reportSemanticError(value.isAsn() ? ASN1ENUMERATEDVALUEEXPECTED : TTCN3ENUMERATEDVALUEEXPECTED);
                value.setIsErroneous(true);
            }
        }
        if (valueCheckingOptions.sub_check && this.subType != null) {
            this.subType.checkThisValue(timestamp, last);
        }
        value.setLastTimeChecked(timestamp);
        return selfReference;
    }

    @Override
    public boolean checkThisTemplate(CompilationTimeStamp timestamp, ITTCN3Template template, boolean isModified, boolean implicitOmit, Assignment lhs) {
        this.registerUsage(template);
        template.setMyGovernor(this);
        if (!ITTCN3Template.Template_type.SPECIFIC_VALUE.equals((Object)template.getTemplatetype())) {
            template.getLocation().reportSemanticError(MessageFormat.format(TEMPLATENOTALLOWED, template.getTemplateTypeName()));
            template.setIsErroneous(true);
        }
        if (template.getLengthRestriction() != null) {
            template.getLocation().reportSemanticError(LENGTHRESTRICTIONNOTALLOWED);
            template.setIsErroneous(true);
        }
        return false;
    }

    @Override
    public void checkCodingAttributes(CompilationTimeStamp timestamp, IReferenceChain refChain) {
        int restrictionLength;
        if (this.subType != null && (restrictionLength = this.subType.get_length_restriction()) != -1) {
            if (this.rawAttribute == null) {
                this.rawAttribute = new RawAST(this.getDefaultRawFieldLength());
            }
            this.rawAttribute.length_restriction = restrictionLength;
        }
        this.checkJson(timestamp);
    }

    @Override
    public boolean canHaveCoding(CompilationTimeStamp timestamp, IType.MessageEncoding_type coding) {
        if (coding == IType.MessageEncoding_type.BER) {
            return this.hasEncoding(timestamp, IType.MessageEncoding_type.BER, null);
        }
        switch (coding) {
            case RAW: 
            case TEXT: 
            case JSON: 
            case XER: {
                return true;
            }
        }
        return false;
    }

    @Override
    public IType getFieldType(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, Expected_Value_type expectedIndex, IReferenceChain refChain, boolean interruptIfOptional) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (subreferences.size() <= actualSubReference) {
            return this;
        }
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Type `{0}'' can not be indexed", this.getTypename()));
                return null;
            }
            case fieldSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((FieldSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                return null;
            }
            case parameterisedSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((ParameterisedSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                return null;
            }
        }
        subreference.getLocation().reportSemanticError("Unsupported subreference kind.");
        return null;
    }

    @Override
    public void forceRaw(CompilationTimeStamp timestamp) {
        if (this.rawAttribute == null) {
            this.rawAttribute = new RawAST(this.getDefaultRawFieldLength());
        }
    }

    @Override
    public int getRawLength(BuildTimestamp timestamp) {
        if (this.rawAttribute != null && this.rawAttribute.fieldlength > 0) {
            return this.rawAttribute.fieldlength;
        }
        int min_bits = 0;
        long max_val = 0L;
        List<EnumItem> enumItems = this.items.getItems();
        for (int i = 0; i < enumItems.size(); ++i) {
            long val;
            if ((max_val < 0L ? -max_val : max_val) >= ((val = ((Integer_Value)enumItems.get(i).getValue()).getValue()) < 0L ? -val : val)) continue;
            max_val = val;
        }
        if (max_val < 0L) {
            min_bits = 1;
            max_val = -max_val;
        }
        while (max_val > 0L) {
            ++min_bits;
            max_val /= 2L;
        }
        return min_bits;
    }

    @Override
    public void forceJson(CompilationTimeStamp timestamp) {
        if (this.jsonAttribute == null) {
            this.jsonAttribute = new JsonAST();
        }
    }

    @Override
    public void checkJson(CompilationTimeStamp timestamp) {
        if (this.jsonAttribute == null) {
            return;
        }
        if (this.jsonAttribute.omit_as_null && !this.isOptionalField()) {
            this.getLocation().reportSemanticError("Invalid attribute, 'omit as null' requires optional field of a record or set.");
        }
        if (this.jsonAttribute.as_value) {
            this.getLocation().reportSemanticError("Invalid attribute, 'as value' is only allowed for unions, the anytype, or records or sets with one field");
        }
        if (this.jsonAttribute.alias != null) {
            IType parent = this.getParentType();
            if (parent == null) {
                this.getLocation().reportSemanticError("Invalid attribute, 'name as ...' requires field of a record, set or union.");
            } else {
                switch (parent.getTypetype()) {
                    case TYPE_TTCN3_SEQUENCE: 
                    case TYPE_TTCN3_SET: 
                    case TYPE_TTCN3_CHOICE: 
                    case TYPE_ANYTYPE: {
                        break;
                    }
                    default: {
                        this.getLocation().reportSemanticError("Invalid attribute, 'name as ...' requires field of a record, set or union.");
                    }
                }
            }
            if (parent != null && parent.getJsonAttribute() != null && parent.getJsonAttribute().as_value) {
                switch (parent.getTypetype()) {
                    case TYPE_TTCN3_CHOICE: 
                    case TYPE_ANYTYPE: {
                        this.getLocation().reportSemanticWarning(MessageFormat.format("Attribute 'name as ...' will be ignored, because parent {0} is encoded without field names.", parent.getTypename()));
                        break;
                    }
                    case TYPE_TTCN3_SEQUENCE: 
                    case TYPE_TTCN3_SET: {
                        if (((TTCN3_Set_Seq_Choice_BaseType)parent).getNofComponents() != 1) break;
                        this.getLocation().reportSemanticWarning(MessageFormat.format("Attribute 'name as ...' will be ignored, because parent {0} is encoded without field names.", parent.getTypename()));
                        break;
                    }
                }
            }
        }
        if (this.jsonAttribute.parsed_default_value != null) {
            this.checkJsonDefault(timestamp);
        }
        if (this.jsonAttribute.metainfo_unbound && (this.getParentType() == null || this.getParentType().getTypetype() != IType.Type_type.TYPE_TTCN3_SEQUENCE && this.getParentType().getTypetype() != IType.Type_type.TYPE_TTCN3_SET)) {
            this.getLocation().reportSemanticError("Invalid attribute 'metainfo for unbound', requires record, set, record of, set of, array or field of a record or set");
        }
        if (this.jsonAttribute.as_number && this.jsonAttribute.enum_texts.size() > 0) {
            this.getLocation().reportSemanticWarning("Attribute 'text ... as ...' will be ignored, because the enumerated values are encoded as numbers");
        }
        if (this.jsonAttribute.as_map) {
            this.getLocation().reportSemanticError("Invalid attribute, 'as map' requires record of or set of");
        }
        if (this.jsonAttribute.enum_texts.size() > 0) {
            for (int i = 0; i < this.jsonAttribute.enum_texts.size(); ++i) {
                int index;
                Identifier identifier = new Identifier(Identifier.Identifier_type.ID_TTCN, this.jsonAttribute.enum_texts.get((int)i).from, NULL_Location.INSTANCE, true);
                if (!this.hasEnumItemWithName(identifier)) {
                    this.getLocation().reportSemanticError(MessageFormat.format("Invalid JSON default value for enumerated type `{0}'", this.getTypename()));
                    continue;
                }
                EnumItem enumItem = this.getEnumItemWithName(identifier);
                this.jsonAttribute.enum_texts.get((int)i).index = index = (int)((Integer_Value)enumItem.getValue()).getValue();
                for (int j = 0; j < i; ++j) {
                    if (this.jsonAttribute.enum_texts.get((int)j).index != index) continue;
                    this.getLocation().reportSemanticError(MessageFormat.format("Duplicate attribute 'text ... as ...' for enumerated value '{0}'", this.jsonAttribute.enum_texts.get((int)i).from));
                }
            }
        }
    }

    @Override
    public StringBuilder getProposalDescription(StringBuilder builder) {
        return builder.append("enumerated");
    }

    @Override
    public void addProposal(ProposalCollector propCollector, int i) {
        List<ISubReference> subreferences = propCollector.getReference().getSubreferences();
        if (subreferences.size() != 1 || propCollector.getReference().getModuleIdentifier() != null) {
            return;
        }
        ISubReference subreference = subreferences.get(i);
        if (ISubReference.Subreference_type.fieldSubReference.equals((Object)subreference.getReferenceType()) && this.items != null) {
            this.items.addProposal(propCollector);
        }
    }

    @Override
    public void addDeclaration(DeclarationCollector declarationCollector, int i) {
        List<ISubReference> subreferences = declarationCollector.getReference().getSubreferences();
        if (i != 0 || subreferences.size() != 1 || declarationCollector.getReference().getModuleIdentifier() != null) {
            return;
        }
        ISubReference subreference = subreferences.get(i);
        if (ISubReference.Subreference_type.fieldSubReference.equals((Object)subreference.getReferenceType()) && this.items != null) {
            this.items.addDeclaration(declarationCollector, i);
        }
    }

    public void addDeclaration(DeclarationCollector declarationCollector, int i, Location commentLocation) {
        List<ISubReference> subreferences = declarationCollector.getReference().getSubreferences();
        if (i != 0 || subreferences.size() != 1 || declarationCollector.getReference().getModuleIdentifier() != null) {
            return;
        }
        ISubReference subreference = subreferences.get(i);
        if (ISubReference.Subreference_type.fieldSubReference.equals((Object)subreference.getReferenceType()) && this.items != null && commentLocation != null) {
            this.items.addDeclaration(declarationCollector, i, commentLocation);
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            this.lastTimeChecked = null;
            boolean handled = false;
            if (this.items != null && reparser.envelopsDamage(this.items.getLocation())) {
                this.items.updateSyntax(reparser, true);
                reparser.updateLocation(this.items.getLocation());
                handled = true;
            }
            if (this.subType != null) {
                this.subType.updateSyntax(reparser, false);
                handled = true;
            }
            if (handled) {
                return;
            }
            throw new ReParseException();
        }
        if (this.items != null) {
            this.items.updateSyntax(reparser, false);
            reparser.updateLocation(this.items.getLocation());
        }
        if (this.subType != null) {
            this.subType.updateSyntax(reparser, false);
        }
        if (this.withAttributesPath != null) {
            this.withAttributesPath.updateSyntax(reparser, false);
            reparser.updateLocation(this.withAttributesPath.getLocation());
        }
    }

    @Override
    public void getEnclosingField(int offset, ReferenceFinder rf) {
        if (this.items == null) {
            return;
        }
        for (EnumItem enumItem : this.items.getItems()) {
            if (!enumItem.getLocation().containsOffset(offset)) continue;
            rf.type = this;
            rf.fieldId = enumItem.getId();
            return;
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        super.findReferences(referenceFinder, foundIdentifiers);
        if (this.items != null) {
            this.items.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (!super.memberAccept(v)) {
            return false;
        }
        return this.items == null || this.items.accept(v);
    }

    @Override
    public Identifier getComponentIdentifierByName(Identifier identifier) {
        EnumItem enumItem = this.getEnumItemWithName(identifier);
        return enumItem == null ? null : enumItem.getId();
    }

    @Override
    public boolean generatesOwnClass(JavaGenData aData, StringBuilder source) {
        return true;
    }

    @Override
    public void generateCode(JavaGenData aData, StringBuilder source) {
        if (this.lastTimeGenerated != null && !this.lastTimeGenerated.isLess(aData.getBuildTimstamp())) {
            return;
        }
        this.lastTimeGenerated = aData.getBuildTimstamp();
        String ownName = this.getGenNameOwn();
        String displayName = this.getFullName();
        StringBuilder localTypeDescriptor = new StringBuilder();
        this.generateCodeTypedescriptor(aData, source, localTypeDescriptor, null);
        this.generateCodeDefaultCoding(aData, source, localTypeDescriptor);
        StringBuilder localCodingHandler = new StringBuilder();
        this.generateCodeForCodingHandlers(aData, source, localCodingHandler);
        boolean hasRaw = this.getGenerateCoderFunctions(IType.MessageEncoding_type.RAW);
        boolean hasJson = this.getGenerateCoderFunctions(IType.MessageEncoding_type.JSON);
        ArrayList<EnumeratedGenerator.Enum_field> fields = new ArrayList<EnumeratedGenerator.Enum_field>(this.items.getItems().size());
        for (int i = 0; i < this.items.getItems().size(); ++i) {
            EnumItem tempItem = this.items.getItems().get(i);
            Value tempValue = tempItem.getValue();
            fields.add(new EnumeratedGenerator.Enum_field(tempItem.getId().getName(), tempItem.getId().getDisplayName(), ((Integer_Value)tempValue).getValue()));
        }
        EnumeratedGenerator.Enum_Defs e_defs = new EnumeratedGenerator.Enum_Defs(fields, ownName, displayName, this.getGenNameTemplate(aData, source), hasRaw, hasJson);
        EnumeratedGenerator.generateValueClass(aData, source, e_defs, localTypeDescriptor, localCodingHandler);
        EnumeratedGenerator.generateTemplateClass(aData, source, e_defs);
        if (this.hasDoneAttribute()) {
            this.generateCodeDone(aData, source);
        }
        if (this.subType != null) {
            this.subType.generateCode(aData, source);
        }
    }

    @Override
    public String getGenNameValue(JavaGenData aData, StringBuilder source) {
        return this.getGenNameOwn(aData);
    }

    @Override
    public String getGenNameTemplate(JavaGenData aData, StringBuilder source) {
        return this.getGenNameOwn(aData).concat("_template");
    }

    @Override
    public String getGenNameTypeDescriptor(JavaGenData aData, StringBuilder source) {
        String baseName = this.getGenNameTypeName(aData, source);
        return baseName + "." + this.getGenNameOwn();
    }

    @Override
    public boolean needsOwnRawDescriptor(JavaGenData aData) {
        return true;
    }

    @Override
    public String getGenNameRawDescriptor(JavaGenData aData, StringBuilder source) {
        return this.getGenNameOwn(aData) + "." + this.getGenNameOwn() + "_raw_";
    }

    @Override
    public boolean needsOwnJsonDescriptor(JavaGenData aData) {
        return this.jsonAttribute != null && !this.jsonAttribute.empty() || this.getOwnertype() == IType.TypeOwner_type.OT_RECORD_OF && this.getParentType().getJsonAttribute() != null && this.getParentType().getJsonAttribute().as_map;
    }

    @Override
    public String getGenNameJsonDescriptor(JavaGenData aData, StringBuilder source) {
        if (this.needsOwnJsonDescriptor(aData)) {
            if (this.needsAlias()) {
                return this.getGenNameOwn(aData) + "." + this.getGenNameOwn() + "_json_";
            }
            return this.getGenNameOwn(aData) + "_json_";
        }
        aData.addBuiltinTypeImport("JSON");
        return "JSON.ENUMERATED_json_";
    }

    @Override
    public String getGenNameBerDescriptor(JavaGenData aData, StringBuilder source) {
        return "ENUMERATED_ber_";
    }

    public Ttcn3HoverContent getItemHoverContent(Identifier item) {
        if (this.getNameParent() instanceof Def_Type) {
            String memberText = null;
            Ttcn3HoverContent hoverContent = new Ttcn3HoverContent();
            Def_Type defType = (Def_Type)this.getNameParent();
            if (defType.hasDocumentComment()) {
                memberText = defType.getDocumentComment().getMember(item.getDisplayName());
            }
            hoverContent.addIcon(this.getOutlineIcon()).addText(defType.getIdentifier().getDisplayName()).addText(".").addText(item.getDisplayName());
            hoverContent.closeHeader();
            hoverContent.addText("<br>").addText(memberText != null ? memberText : "");
            hoverContent.addContent(HoverContentType.INFO);
            return hoverContent;
        }
        return null;
    }

    @Override
    public void addMembersContent(Ttcn3HoverContent content) {
        List<EnumItem> enumItems = this.items.getItems();
        int nofItems = enumItems.size();
        if (nofItems == 0) {
            return;
        }
        content.addTag("Members");
        for (int i = 0; i < nofItems; ++i) {
            EnumItem item = enumItems.get(i);
            content.addStyledText(item.getDeclaration().getIdentifier().getDisplayName(), 2).addText("<br>");
        }
    }
}

