/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.types.subtypes;

import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.SubtypeConstraint;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.TernaryBool;

public final class BooleanListConstraint
extends SubtypeConstraint {
    private final int constraint;

    public BooleanListConstraint(ConstraintValue constraint) {
        this.constraint = constraint.value();
    }

    public BooleanListConstraint(boolean b) {
        this.constraint = b ? ConstraintValue.TRUE.value() : ConstraintValue.FALSE.value();
    }

    private BooleanListConstraint(int constraint) {
        this.constraint = constraint;
    }

    @Override
    public BooleanListConstraint complement() {
        return new BooleanListConstraint(this.constraint ^ ConstraintValue.ALL.value());
    }

    @Override
    public BooleanListConstraint intersection(SubtypeConstraint other) {
        BooleanListConstraint o = (BooleanListConstraint)other;
        return new BooleanListConstraint(this.constraint & o.constraint);
    }

    @Override
    public boolean isElement(Object o) {
        Boolean b = (Boolean)o;
        return b.booleanValue() ? (this.constraint & ConstraintValue.TRUE.value()) != 0 : (this.constraint & ConstraintValue.FALSE.value()) != 0;
    }

    @Override
    public TernaryBool isEmpty() {
        return TernaryBool.fromBool(this.constraint == 0);
    }

    @Override
    public TernaryBool isEqual(SubtypeConstraint other) {
        BooleanListConstraint o = (BooleanListConstraint)other;
        return TernaryBool.fromBool(this.constraint == o.constraint);
    }

    @Override
    public TernaryBool isFull() {
        return TernaryBool.fromBool(this.constraint == ConstraintValue.ALL.value());
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append('(');
        if ((this.constraint & ConstraintValue.FALSE.value()) != 0) {
            sb.append("false");
        }
        if (this.constraint == ConstraintValue.ALL.value()) {
            sb.append(", ");
        }
        if ((this.constraint & ConstraintValue.TRUE.value()) != 0) {
            sb.append("true");
        }
        sb.append(')');
    }

    @Override
    public BooleanListConstraint union(SubtypeConstraint other) {
        BooleanListConstraint o = (BooleanListConstraint)other;
        return new BooleanListConstraint(this.constraint | o.constraint);
    }

    public static enum ConstraintValue {
        FALSE(1),
        TRUE(2),
        ALL(3);

        private final int value;

        private ConstraintValue(int v) {
            this.value = v;
        }

        public int value() {
            return this.value;
        }
    }
}

