/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Extfunction;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Function;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.types.Function_Type;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Function_Reference_Value
extends Value {
    private final Definition referredFunction;

    public Function_Reference_Value(Def_Function referredFunction) {
        this.referredFunction = referredFunction;
    }

    public Function_Reference_Value(Def_Extfunction referredFunction) {
        this.referredFunction = referredFunction;
    }

    @Override
    public IValue.Value_type getValuetype() {
        return IValue.Value_type.FUNCTION_REFERENCE_VALUE;
    }

    @Override
    public String createStringRepresentation() {
        StringBuilder builder = new StringBuilder("refers(");
        builder.append(this.referredFunction.getAssignmentName()).append(')');
        return builder.toString();
    }

    public Definition getReferredFunction() {
        return this.referredFunction;
    }

    @Override
    public IValue getReferencedSubValue(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, IReferenceChain refChain) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (this.getIsErroneous(timestamp) || subreferences.size() <= actualSubReference) {
            return this;
        }
        IType type = this.myGovernor.getTypeRefdLast(timestamp);
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid array element reference: type `{0}'' can not be indexed", type.getTypename()));
                return null;
            }
            case fieldSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((FieldSubReference)subreference).getId().getDisplayName(), type.getTypename()));
                return null;
            }
            case parameterisedSubReference: {
                subreference.getLocation().reportSemanticError("Invalid reference: internal parameterisation is not supported");
                return null;
            }
        }
        subreference.getLocation().reportSemanticError("Unsupported subreference kind.");
        return null;
    }

    @Override
    public boolean isUnfoldable(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        return false;
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        return IType.Type_type.TYPE_FUNCTION;
    }

    @Override
    public boolean checkEquality(CompilationTimeStamp timestamp, IValue other) {
        ReferenceChain referenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
        IValue last = other.getValueRefdLast(timestamp, referenceChain);
        referenceChain.release();
        return IValue.Value_type.FUNCTION_REFERENCE_VALUE.equals((Object)last.getValuetype()) && this.referredFunction == ((Function_Reference_Value)last).getReferredFunction();
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        return true;
    }

    @Override
    public boolean canGenerateSingleExpression() {
        return true;
    }

    @Override
    public StringBuilder generateCodeInit(JavaGenData aData, StringBuilder source, String name) {
        source.append(name);
        source.append(".operator_assign( ");
        source.append((CharSequence)this.generateSingleExpression(aData));
        source.append(" );\n");
        this.lastTimeGenerated = aData.getBuildTimstamp();
        return source;
    }

    @Override
    public StringBuilder generateSingleExpression(JavaGenData aData) {
        StringBuilder result = new StringBuilder();
        IType governor = this.myGovernor;
        if (governor == null) {
            governor = this.getExpressionGovernor(CompilationTimeStamp.getBaseTimestamp(), Expected_Value_type.EXPECTED_TEMPLATE);
        }
        if (governor == null) {
            governor = this.myLastSetGovernor;
        }
        if (governor == null || this.referredFunction == null) {
            ErrorReporter.INTERNAL_ERROR((String)("FATAL ERROR while generating code for value `" + this.getFullName() + "''"));
            return result;
        }
        IType lastGovernor = governor.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
        Function_Type functionType = (Function_Type)lastGovernor;
        Type returnType = functionType.getReturnType();
        String moduleName = this.referredFunction.getMyScope().getModuleScopeGen().getName();
        String functionName = this.referredFunction.getIdentifier().getName();
        String functionGenName = this.referredFunction.getGenNameFromScope(aData, result, "");
        result.append(MessageFormat.format("new {0}(new {0}.function_pointer() '{'\n", governor.getGenNameValue(aData, result)));
        result.append("@Override\n");
        result.append("public String getModuleName() {\n");
        result.append(MessageFormat.format("return \"{0}\";\n", moduleName));
        result.append("}\n");
        result.append("@Override\n");
        result.append("public String getDefinitionName() {\n");
        result.append(MessageFormat.format("return \"{0}\";\n", functionName));
        result.append("}\n");
        result.append("@Override\n");
        result.append("public ");
        StringBuilder actualParList = functionType.getFormalParameters().generateCodeActualParlist("");
        if (returnType == null) {
            result.append("void");
        } else if (functionType.returnsTemplate()) {
            result.append(returnType.getGenNameTemplate(aData, result));
        } else {
            result.append(returnType.getGenNameValue(aData, result));
        }
        result.append(" invoke(");
        functionType.getFormalParameters().generateCode(aData, result);
        result.append(") {\n");
        result.append(MessageFormat.format("{0}{1}({2});\n", returnType == null ? "" : "return ", functionGenName, actualParList));
        result.append("}\n");
        if (functionType.isStartable(CompilationTimeStamp.getBaseTimestamp())) {
            aData.addBuiltinTypeImport("TitanComponent");
            result.append("@Override\n");
            result.append("public void start(final TitanComponent component_reference");
            if (functionType.getFormalParameters().getNofParameters() > 0) {
                result.append(", ");
                functionType.getFormalParameters().generateCode(aData, result);
            }
            result.append(") {\n");
            result.append(MessageFormat.format("{0}.start_{1}(component_reference", moduleName, functionName));
            if (actualParList != null && actualParList.length() > 0) {
                result.append(MessageFormat.format(", {0}", actualParList));
            }
            result.append(");\n");
            result.append("}\n");
        }
        result.append("})\n");
        return result;
    }
}

