/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.TTCN3.types.CharString_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.Integer_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.PredefFunc;
import org.eclipse.titan.designer.AST.TTCN3.values.UniversalChar;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.Hex2IntExpression;
import org.eclipse.titan.designer.compiler.JavaGenData;

public final class UniversalCharstring
implements Comparable<UniversalCharstring> {
    private List<UniversalChar> value;
    private boolean mErrorneous = false;
    private String mErrorMessage;

    public UniversalCharstring() {
        this.value = new ArrayList<UniversalChar>();
    }

    public UniversalCharstring(UniversalChar character) {
        this.value = new ArrayList<UniversalChar>(1);
        this.value.add(character);
    }

    public UniversalCharstring(String string, Location location) {
        StringBuilder octet_str = new StringBuilder();
        int len = string == null ? 0 : string.length();
        for (int i = 0; i < len; ++i) {
            try {
                octet_str.append(PredefFunc.hexdigit_to_char((char)(string.charAt(i) / 16)));
                octet_str.append(PredefFunc.hexdigit_to_char((char)(string.charAt(i) % 16)));
                continue;
            }
            catch (PredefFunc.DecodeException decodeException) {
                // empty catch block
            }
        }
        CharString_Type.CharCoding coding = PredefFunc.get_stringencoding(octet_str.toString(), location);
        if (CharString_Type.CharCoding.UTF_8 == coding) {
            try {
                UniversalCharstring ucs = PredefFunc.decode_utf8(octet_str.toString(), CharString_Type.CharCoding.UTF_8);
                this.value = ucs.value;
            }
            catch (Exception e) {
                this.mErrorneous = true;
                this.mErrorMessage = e.getMessage();
            }
            return;
        }
        if (string != null) {
            this.value = new ArrayList<UniversalChar>(string.length());
            for (int i = 0; i < string.length(); ++i) {
                this.value.add(new UniversalChar(string.charAt(i)));
            }
        }
    }

    public UniversalCharstring(List<String> uid_elements, Location location) {
        this.value = new ArrayList<UniversalChar>();
        if (uid_elements == null) {
            return;
        }
        for (int i = 0; i < uid_elements.size(); ++i) {
            String chunk;
            String uidChar = uid_elements.get(i);
            int offset = 1;
            if (uidChar.length() > 1 && uidChar.charAt(1) == '+') {
                ++offset;
            }
            if (!(chunk = uidChar.substring(offset)).matches("[0-9a-fA-F]{1,8}")) {
                location.reportSyntacticError(MessageFormat.format("The USI like notation requires element {0} to have between 1 and 8 hexadecimal characters", i));
                return;
            }
            Integer_Value val = Hex2IntExpression.hex2int(chunk);
            long intValue = val.getValue();
            long group = intValue >> 24 & 0xFFL;
            long plane = intValue >> 16 & 0xFFL;
            long row = intValue >> 8 & 0xFFL;
            long cell = intValue & 0xFFL;
            this.value.add(new UniversalChar((int)group, (int)plane, (int)row, (int)cell));
        }
    }

    public boolean isErrorneous() {
        return this.mErrorneous;
    }

    public String getErrorMessage() {
        return this.mErrorMessage;
    }

    public UniversalCharstring(UniversalCharstring other) {
        this.value = new ArrayList<UniversalChar>(other.value.size());
        for (int i = 0; i < other.value.size(); ++i) {
            this.value.add(other.value.get(i));
        }
    }

    private UniversalCharstring(List<UniversalChar> value) {
        this.value = value;
    }

    public int length() {
        return this.value.size();
    }

    public UniversalChar get(int index) {
        return this.value.get(index);
    }

    public String getString() {
        StringBuilder builder = new StringBuilder(this.value.size());
        for (int i = 0; i < this.value.size(); ++i) {
            builder.append((char)this.value.get(i).cell());
        }
        return builder.toString();
    }

    public String getStringRepresentation() {
        StringBuilder builder = new StringBuilder(this.value.size());
        for (int i = 0; i < this.value.size(); ++i) {
            UniversalChar tempChar = this.value.get(i);
            if (tempChar.group() == 0 && tempChar.plane() == 0 && tempChar.row() == 0) {
                builder.append((char)tempChar.cell());
                continue;
            }
            builder.append("char(").append(tempChar.group()).append(',').append(tempChar.plane()).append(',').append(tempChar.row()).append(',').append(tempChar.cell()).append(')');
        }
        return builder.toString();
    }

    public String getStringRepresentationForPattern() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.value.size(); ++i) {
            UniversalChar uchar = this.value.get(i);
            if (uchar.group() == 0 && uchar.plane() == 0 && uchar.row() == 0) {
                char tmp_c = (char)uchar.cell();
                if (!Character.isWhitespace(tmp_c) && (uchar.cell() < 32 || uchar.cell() >= 127)) continue;
                builder.append(tmp_c);
                continue;
            }
            builder.append("\\\\q{").append(uchar.group()).append(',').append(uchar.plane()).append(',').append(uchar.row()).append(',').append(uchar.cell()).append('}');
        }
        return builder.toString();
    }

    public UniversalCharstring substring(int beginIndex) {
        return this.substring(beginIndex, this.value.size());
    }

    public UniversalCharstring substring(int beginIndex, int endIndex) {
        ArrayList<UniversalChar> newList = new ArrayList<UniversalChar>(this.value.subList(beginIndex, endIndex));
        return new UniversalCharstring(newList);
    }

    public UniversalCharstring append(String other) {
        for (int i = 0; i < other.length(); ++i) {
            this.value.add(new UniversalChar(0, 0, 0, other.charAt(i)));
        }
        return this;
    }

    public UniversalCharstring append(UniversalCharstring other) {
        if (other != null) {
            for (int i = 0; i < other.value.size(); ++i) {
                this.value.add(other.value.get(i));
            }
        }
        return this;
    }

    public UniversalCharstring append(UniversalChar uc) {
        if (uc != null) {
            this.value.add(uc);
        }
        return this;
    }

    public static boolean isCharstring(String string) {
        if (string == null) {
            return true;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) <= '\u007f') continue;
            return false;
        }
        return true;
    }

    public int compareWith(UniversalCharstring other) {
        if (this == other) {
            return 0;
        }
        int i = 0;
        while (true) {
            if (i == this.value.size()) {
                if (i == other.value.size()) {
                    return 0;
                }
                return -1;
            }
            if (i == other.value.size()) {
                return 1;
            }
            UniversalChar actual = this.value.get(i);
            UniversalChar otherActual = other.value.get(i);
            if (actual.group() > otherActual.group()) {
                return 1;
            }
            if (actual.group() < otherActual.group()) {
                return -1;
            }
            if (actual.plane() > otherActual.plane()) {
                return 1;
            }
            if (actual.plane() < otherActual.plane()) {
                return -1;
            }
            if (actual.row() > otherActual.row()) {
                return 1;
            }
            if (actual.row() < otherActual.row()) {
                return -1;
            }
            if (actual.cell() > otherActual.cell()) {
                return 1;
            }
            if (actual.cell() < otherActual.cell()) {
                return -1;
            }
            ++i;
        }
    }

    @Override
    public int compareTo(UniversalCharstring other) {
        return this.compareWith(other);
    }

    public boolean checkEquality(UniversalCharstring other) {
        if (this == other) {
            return true;
        }
        if (this.value.size() != other.value.size()) {
            return false;
        }
        for (int i = 0; i < this.value.size(); ++i) {
            if (this.value.get(i).checkEquality(other.value.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean checkEquality(String other) {
        if (this.value.size() != other.length()) {
            return false;
        }
        for (int i = 0; i < this.value.size(); ++i) {
            if (this.value.get(i).checkEquality(other.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = 0;
        for (UniversalChar temp : this.value) {
            h = 31 * h + temp.group();
            h = 31 * h + temp.plane();
            h = 31 * h + temp.row();
            h = 31 * h + temp.cell();
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof UniversalCharstring) {
            return this.checkEquality((UniversalCharstring)obj);
        }
        return false;
    }

    public StringBuilder generateSingleExpression(JavaGenData aData) {
        StringBuilder result = new StringBuilder();
        result.append("new TitanUniversalChar[]{");
        int size = this.value.size();
        for (int i = 0; i < size; ++i) {
            UniversalChar temp = this.value.get(i);
            result.append((CharSequence)temp.generateSingleExpression(aData));
            if (i == size - 1) continue;
            result.append(", ");
        }
        result.append("}");
        return result;
    }
}

