/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.actions;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.MarkerHandler;
import org.eclipse.titan.designer.commonFilters.ResourceExclusionHelper;
import org.eclipse.titan.designer.graphics.ImageCache;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.GlobalProjectStructureTracker;
import org.eclipse.titan.designer.properties.PropertyNotificationManager;
import org.eclipse.titan.designer.properties.data.ProjectFileHandler;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.progress.IProgressConstants;

public final class ExcludeFromBuild
extends AbstractHandler
implements IObjectActionDelegate {
    static final String TRUE_STRING = "true";
    static final String FALSE_STRING = "false";
    private ISelection selection;
    private List<IProject> projects;

    public void run(IAction action) {
        this.doExclusion(this.selection);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.selection = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getSelection();
        this.doExclusion(this.selection);
        return null;
    }

    private void doExclusion(ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection structSelection = (IStructuredSelection)selection;
        if (structSelection.isEmpty()) {
            return;
        }
        ExcluderWorkspaceJob op = new ExcluderWorkspaceJob(structSelection);
        op.setPriority(30);
        op.setSystem(false);
        op.setUser(true);
        op.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        op.setProperty(IProgressConstants.ICON_PROPERTY, ImageCache.getImageDescriptor("titan.gif"));
        op.schedule();
    }

    private class ExcluderWorkspaceJob
    extends WorkspaceJob {
        private final IStructuredSelection structSelection;

        public ExcluderWorkspaceJob(IStructuredSelection structSelection) {
            super("Changing the excludedness of resources");
            this.structSelection = structSelection;
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) {
            ExcludeFromBuild.this.projects = new ArrayList();
            final ConcurrentLinkedQueue<WorkspaceJob> exclusionJobs = new ConcurrentLinkedQueue<WorkspaceJob>();
            HashSet<Object> resourcesToRefresh = new HashSet<Object>();
            HashSet<IProject> projectsToRefresh = new HashSet<IProject>();
            for (Object selected : this.structSelection.toList()) {
                WorkspaceJob op;
                String mode;
                if (selected instanceof IFile) {
                    final IFile file = (IFile)selected;
                    resourcesToRefresh.add(file);
                    try {
                        mode = file.getPersistentProperty(ResourceExclusionHelper.EXCLUDED_FILE_QUALIFIER);
                        file.setPersistentProperty(ResourceExclusionHelper.EXCLUDED_FILE_QUALIFIER, ExcludeFromBuild.TRUE_STRING.equals(mode) ? ExcludeFromBuild.FALSE_STRING : ExcludeFromBuild.TRUE_STRING);
                        op = new WorkspaceJob("Changing the excludedness of file: " + file.getName()){

                            public IStatus runInWorkspace(IProgressMonitor monitor) {
                                if (!ExcludeFromBuild.TRUE_STRING.equals(mode)) {
                                    MarkerHandler.markAllMarkersForRemoval((IResource)file);
                                    MarkerHandler.removeAllMarkedMarkers((IResource)file);
                                }
                                exclusionJobs.add(GlobalParser.getProjectSourceParser(file.getProject()).reportOutdating(file));
                                return Status.OK_STATUS;
                            }
                        };
                        op.setPriority(20);
                        op.setSystem(true);
                        op.setUser(false);
                        op.setRule((ISchedulingRule)file);
                        op.setProperty(IProgressConstants.ICON_PROPERTY, (Object)ImageCache.getImageDescriptor("titan.gif"));
                        exclusionJobs.add(op);
                        op.schedule();
                        if (ExcludeFromBuild.this.projects.contains(file.getProject())) continue;
                        ExcludeFromBuild.this.projects.add(file.getProject());
                        projectsToRefresh.add(file.getProject());
                    }
                    catch (CoreException e) {
                        ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
                    }
                    continue;
                }
                if (!(selected instanceof IFolder)) continue;
                final IFolder folder = (IFolder)selected;
                resourcesToRefresh.add(folder);
                try {
                    mode = folder.getPersistentProperty(ResourceExclusionHelper.EXCLUDED_FOLDER_QUALIFIER);
                    folder.setPersistentProperty(ResourceExclusionHelper.EXCLUDED_FOLDER_QUALIFIER, ExcludeFromBuild.TRUE_STRING.equals(mode) ? ExcludeFromBuild.FALSE_STRING : ExcludeFromBuild.TRUE_STRING);
                    if (!ExcludeFromBuild.TRUE_STRING.equals(mode)) {
                        op = new WorkspaceJob("Changing the excludedness of folder: " + folder.getName()){

                            public IStatus runInWorkspace(IProgressMonitor monitor) {
                                MarkerHandler.markAllMarkersForRemoval((IResource)folder);
                                MarkerHandler.removeAllMarkedMarkers((IResource)folder);
                                return Status.OK_STATUS;
                            }
                        };
                        op.setPriority(20);
                        op.setSystem(true);
                        op.setUser(false);
                        op.setRule((ISchedulingRule)folder);
                        op.setProperty(IProgressConstants.ICON_PROPERTY, (Object)ImageCache.getImageDescriptor("titan.gif"));
                        op.schedule();
                    }
                    exclusionJobs.add(GlobalParser.getProjectSourceParser(folder.getProject()).reportOutdating(folder));
                    if (ExcludeFromBuild.this.projects.contains(folder.getProject())) continue;
                    ExcludeFromBuild.this.projects.add(folder.getProject());
                    projectsToRefresh.add(folder.getProject());
                }
                catch (CoreException e) {
                    ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
                }
            }
            WorkspaceJob op = new WorkspaceJob("Waiting for exclusion threads to finish."){

                public IStatus runInWorkspace(IProgressMonitor monitor) {
                    while (!exclusionJobs.isEmpty()) {
                        WorkspaceJob job = (WorkspaceJob)exclusionJobs.poll();
                        try {
                            if (job == null) continue;
                            job.join();
                        }
                        catch (InterruptedException e) {
                            ErrorReporter.logExceptionStackTrace((Exception)e);
                        }
                    }
                    for (IProject project : ExcludeFromBuild.this.projects) {
                        ProjectFileHandler projectFileHandler = new ProjectFileHandler(project);
                        projectFileHandler.saveProjectSettings();
                        GlobalProjectStructureTracker.projectChanged(project);
                        PropertyNotificationManager.firePropertyChange((IResource)project);
                    }
                    return Status.OK_STATUS;
                }
            };
            op.setPriority(30);
            op.setSystem(true);
            op.setUser(false);
            op.setProperty(IProgressConstants.ICON_PROPERTY, (Object)ImageCache.getImageDescriptor("titan.gif"));
            op.schedule();
            return Status.OK_STATUS;
        }
    }
}

