/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.commonFilters;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.titan.designer.commonFilters.ResourceExclusionHelper;

public final class ExcludedResourceFilter
extends ViewerFilter {
    private static final String FILTER_ID = "org.eclipse.titan.designer.commonFilters.ExcludedResourceFilter";
    private static final String NAVIGATOR_QUALIFIER = "org.eclipse.ui.navigator";
    private static final String FILTER_ACTIVATION_KEY = "org.eclipse.ui.navigator.ProjectExplorer.filterActivation";
    private static boolean isActive = false;
    private static boolean isActiveSet = false;

    private static void checkIsActive() {
        IEclipsePreferences rootNode = (IEclipsePreferences)Platform.getPreferencesService().getRootNode().node("instance").node(NAVIGATOR_QUALIFIER);
        rootNode.addPreferenceChangeListener(new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                if (ExcludedResourceFilter.FILTER_ACTIVATION_KEY.equals(event.getKey())) {
                    String temp = Platform.getPreferencesService().getString(ExcludedResourceFilter.NAVIGATOR_QUALIFIER, ExcludedResourceFilter.FILTER_ACTIVATION_KEY, "", null);
                    isActive = temp.indexOf(ExcludedResourceFilter.FILTER_ID) != -1;
                    isActiveSet = true;
                }
            }
        });
        String temp = Platform.getPreferencesService().getString(NAVIGATOR_QUALIFIER, FILTER_ACTIVATION_KEY, "", null);
        isActive = temp.indexOf(FILTER_ID) != -1;
        isActiveSet = true;
    }

    public static boolean isActive() {
        if (!isActiveSet) {
            ExcludedResourceFilter.checkIsActive();
        }
        return isActive;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (element instanceof IFile) {
            ResourceExclusionHelper helper = new ResourceExclusionHelper();
            IFile file = (IFile)element;
            if (helper.isExcludedByRegexp(file.getName())) {
                return false;
            }
            if ('.' == file.getName().charAt(0)) {
                return false;
            }
            return !ResourceExclusionHelper.isDirectlyExcluded(file);
        }
        if (element instanceof IFolder) {
            ResourceExclusionHelper helper = new ResourceExclusionHelper();
            IFolder folder = (IFolder)element;
            if (helper.isExcludedByRegexp(folder.getName())) {
                return false;
            }
            if ('.' == folder.getName().charAt(0)) {
                return false;
            }
            return !ResourceExclusionHelper.isDirectlyExcluded(folder);
        }
        return true;
    }
}

