/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.titan.designer.editors.BreadcrumbTreeItem;

public class BreadcrumbTreeContentProvider
implements ITreeContentProvider {
    public Object[] getElements(Object inputElement) {
        Path path;
        File file;
        if (inputElement instanceof Path && (file = (path = (Path)inputElement).toFile()).isDirectory()) {
            File[] listing = file.listFiles();
            ArrayList<BreadcrumbTreeItem> treeItems = new ArrayList<BreadcrumbTreeItem>();
            for (File f : listing) {
                String filename;
                if (f.isHidden()) continue;
                if (f.isDirectory()) {
                    if (f.getName().startsWith(".")) continue;
                    treeItems.add(new BreadcrumbTreeItem(f.getName(), f));
                }
                if (!(filename = f.getName()).matches(".*[.][Tt][Tt][Cc][Nn]3?$") && !filename.matches(".*[.][Tt][Tt][Cc][Nn][Pp][Pp]$") && !filename.matches(".*[.][Aa][Ss][Nn]1?$")) continue;
                treeItems.add(new BreadcrumbTreeItem(f.getName(), f));
            }
            return treeItems.toArray();
        }
        return new Object[0];
    }

    public Object[] getChildren(Object parentElement) {
        BreadcrumbTreeItem item;
        if (parentElement instanceof BreadcrumbTreeItem && (item = (BreadcrumbTreeItem)parentElement).getData() instanceof File) {
            File file = (File)item.getData();
            return this.getElements(new Path(file.getAbsolutePath()));
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof BreadcrumbTreeItem) {
            BreadcrumbTreeItem item = (BreadcrumbTreeItem)element;
            return item.isDirectory();
        }
        return false;
    }
}

