/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension3;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension6;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.titan.designer.editors.Stylers;
import org.eclipse.titan.designer.editors.controls.HoverContentType;
import org.eclipse.titan.designer.editors.controls.Ttcn3HoverContent;
import org.eclipse.titan.designer.editors.controls.Ttcn3HoverInfoControl;

public final class CompletionProposal
implements ICompletionProposal,
ICompletionProposalExtension3,
ICompletionProposalExtension6 {
    private StyledString fDisplayString;
    private String fReplacementString;
    private int fReplacementOffset;
    private int fReplacementLength;
    private int fCursorPosition;
    private Image fImage;
    private IContextInformation fContextInformation;
    private Ttcn3HoverContent fAdditionalProposalInfo;
    private int fRelevance;

    public CompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition) {
        this(replacementString, replacementOffset, replacementLength, cursorPosition, null, null, null, null);
    }

    public CompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, Image image, String displayString, IContextInformation contextInformation, String additionalProposalInfo) {
        this(replacementString, replacementOffset, replacementLength, cursorPosition, image, new StyledString(displayString), contextInformation, new Ttcn3HoverContent(additionalProposalInfo), 0);
    }

    public CompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, Image image, StyledString displayString, IContextInformation contextInformation, Ttcn3HoverContent additionalProposalInfo, int relevance) {
        Assert.isNotNull((Object)replacementString);
        Assert.isTrue((replacementOffset >= 0 ? 1 : 0) != 0);
        Assert.isTrue((replacementLength >= 0 ? 1 : 0) != 0);
        Assert.isTrue((cursorPosition >= 0 ? 1 : 0) != 0);
        this.setRelevance(relevance);
        this.setReplacementString(replacementString);
        this.setReplacementOffset(replacementOffset);
        this.setReplacementLength(replacementLength);
        this.setCursorPosition(cursorPosition);
        this.setImage(image);
        this.setStyledDisplayString(displayString == null ? new StyledString(replacementString) : displayString);
        this.setContextInformation(contextInformation);
        this.setAdditionalProposalInfo(additionalProposalInfo);
    }

    public void apply(IDocument document) {
        try {
            document.replace(this.fReplacementOffset, this.fReplacementLength, this.fReplacementString);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public String getAdditionalProposalInfo() {
        if (this.fAdditionalProposalInfo != null) {
            return this.fAdditionalProposalInfo.getText(HoverContentType.INFO);
        }
        return "";
    }

    public void setAdditionalProposalInfo(Ttcn3HoverContent additionalProposalInfo) {
        this.fAdditionalProposalInfo = additionalProposalInfo;
    }

    public IContextInformation getContextInformation() {
        return this.fContextInformation;
    }

    public void setContextInformation(IContextInformation contextInformation) {
        this.fContextInformation = contextInformation;
    }

    public void setCursorPosition(int cursorPosition) {
        Assert.isTrue((cursorPosition >= 0 ? 1 : 0) != 0);
        this.fCursorPosition = cursorPosition;
    }

    public Image getImage() {
        return this.fImage;
    }

    public void setImage(Image image) {
        this.fImage = image;
    }

    public int getRelevance() {
        return this.fRelevance;
    }

    public void setRelevance(int relevance) {
        this.fRelevance = relevance;
    }

    public void setReplacementLength(int replacementLength) {
        Assert.isTrue((replacementLength >= 0 ? 1 : 0) != 0);
        this.fReplacementLength = replacementLength;
    }

    public void setReplacementOffset(int replacementOffset) {
        Assert.isTrue((replacementOffset >= 0 ? 1 : 0) != 0);
        this.fReplacementOffset = replacementOffset;
    }

    public void setReplacementString(String replacementString) {
        Assert.isNotNull((Object)replacementString);
        this.fReplacementString = replacementString;
    }

    public String getDisplayString() {
        if (this.fDisplayString != null) {
            return this.fDisplayString.toString();
        }
        return this.fReplacementString;
    }

    public StyledString getStyledDisplayString() {
        return this.fDisplayString;
    }

    public void setStyledDisplayString(StyledString text) {
        this.fDisplayString = text;
        if ((this.fRelevance & 2) > 0) {
            this.fDisplayString.setStyle(0, this.fReplacementLength, (StyledString.Styler)new Stylers.BoldStyler());
        }
    }

    public IInformationControlCreator getInformationControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new Ttcn3HoverInfoControl(parent);
            }
        };
    }

    public int getPrefixCompletionStart(IDocument document, int completionOffset) {
        return this.fReplacementOffset;
    }

    public CharSequence getPrefixCompletionText(IDocument document, int completionOffset) {
        return this.fReplacementString;
    }

    public Point getSelection(IDocument document) {
        return new Point(this.fReplacementOffset + this.fCursorPosition, 0);
    }
}

