/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.collections.impl.bimap.mutable.HashBiMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;

public final class DocumentTracker {
    private static final HashBiMap<IFile, IDocument> FILE_DOCUMENT_MAP = new HashBiMap();
    private static final Map<IDocument, Module> DOCUMENT_TTCN3MODULE_MAP = new ConcurrentHashMap<IDocument, Module>();
    private static final Map<String, AbstractDecoratedTextEditor> MODULE_EDITOR = new ConcurrentHashMap<String, AbstractDecoratedTextEditor>();

    private DocumentTracker() {
    }

    public static void put(IFile file, IDocument document, AbstractDecoratedTextEditor editor) {
        FILE_DOCUMENT_MAP.put((Object)file, (Object)document);
        ProjectSourceParser projectSourceParser = GlobalParser.getProjectSourceParser(file.getProject());
        Module tempModule = projectSourceParser.containedModule(file);
        if (tempModule != null) {
            DOCUMENT_TTCN3MODULE_MAP.put(document, tempModule);
            MODULE_EDITOR.put(tempModule.getIdentifier().getDisplayName(), editor);
        }
    }

    public static IDocument get(IFile file) {
        return (IDocument)FILE_DOCUMENT_MAP.get((Object)file);
    }

    public static IFile getFile(IDocument document) {
        return (IFile)FILE_DOCUMENT_MAP.inverse().get((Object)document);
    }

    public static Module get(IDocument document) {
        if (DOCUMENT_TTCN3MODULE_MAP.get(document) == null) {
            for (IFile key : FILE_DOCUMENT_MAP.keySet()) {
                Module tempModule;
                if (!((IDocument)FILE_DOCUMENT_MAP.get((Object)key)).equals(document) || (tempModule = GlobalParser.getProjectSourceParser(key.getProject()).containedModule(key)) == null) continue;
                DOCUMENT_TTCN3MODULE_MAP.put(document, tempModule);
                return tempModule;
            }
        }
        return DOCUMENT_TTCN3MODULE_MAP.get(document);
    }

    public static AbstractDecoratedTextEditor get(Module module) {
        if (module != null && module.getIdentifier() != null) {
            return MODULE_EDITOR.get(module.getIdentifier().getDisplayName());
        }
        return null;
    }
}

