/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.actions;

import java.text.MessageFormat;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.commonFilters.ResourceExclusionHelper;
import org.eclipse.titan.designer.core.TITANNature;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.AbstractTextEditor;

public abstract class OpenDeclarationBase
extends AbstractHandler
implements IEditorActionDelegate {
    public static final String FILENOTIDENTIFIABLE = "The file related to the editor could not be identified";
    public static final String EDITORNOTFOUND = "The {0} editor could not be found";
    protected IEditorPart targetEditor = null;
    protected ISelection selection = TextSelection.emptySelection();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.targetEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        this.doOpenDeclaration();
        return null;
    }

    public final void run(IAction action) {
        this.doOpenDeclaration();
    }

    public final void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    public final void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.targetEditor = targetEditor;
    }

    protected abstract void doOpenDeclaration();

    protected void selectAndRevealDeclaration(Location location, String editorType) {
        IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(location.getFile().getName());
        if (desc == null) {
            this.targetEditor.getEditorSite().getActionBars().getStatusLineManager().setErrorMessage(MessageFormat.format(EDITORNOTFOUND, editorType));
            return;
        }
        try {
            IWorkbenchPage page = this.targetEditor.getSite().getPage();
            IEditorPart editorPart = page.openEditor((IEditorInput)new FileEditorInput((IFile)location.getFile()), desc.getId());
            if (editorPart != null && editorPart instanceof AbstractTextEditor) {
                ((AbstractTextEditor)editorPart).selectAndReveal(location.getOffset(), location.getEndOffset() - location.getOffset());
            }
        }
        catch (PartInitException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
    }

    protected boolean check() {
        this.targetEditor.getEditorSite().getActionBars().getStatusLineManager().setErrorMessage(null);
        IFile file = (IFile)this.targetEditor.getEditorInput().getAdapter(IFile.class);
        if (file == null) {
            this.targetEditor.getEditorSite().getActionBars().getStatusLineManager().setErrorMessage(FILENOTIDENTIFIABLE);
            return false;
        }
        if (!TITANNature.hasTITANNature(file.getProject())) {
            this.targetEditor.getEditorSite().getActionBars().getStatusLineManager().setErrorMessage("The project containing the selected file does not have the TITAN nature among its natures");
            return false;
        }
        if (ResourceExclusionHelper.isExcluded((IResource)file)) {
            MessageDialog.openError(null, (String)"Open Declaration does not work within excluded resources", (String)"This module is excluded from build. To use the Open Declaration feature please click on the 'Toggle exclude from build state' in the context menu of the Project Explorer. ");
            return false;
        }
        return true;
    }
}

