/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.configeditor.pages.logging;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Map;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.titan.common.parsers.AddedParseTree;
import org.eclipse.titan.common.parsers.cfg.ConfigTreeNodeUtilities;
import org.eclipse.titan.common.parsers.cfg.indices.LoggingBit;
import org.eclipse.titan.common.parsers.cfg.indices.LoggingBitHelper;
import org.eclipse.titan.common.parsers.cfg.indices.LoggingSectionHandler;
import org.eclipse.titan.designer.editors.configeditor.ConfigEditor;
import org.eclipse.titan.designer.editors.configeditor.pages.logging.LoggingBitsContentProvider;
import org.eclipse.titan.designer.editors.configeditor.pages.logging.LoggingBitsLabelProvider;
import org.eclipse.titan.designer.editors.configeditor.pages.logging.LoggingPage;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public final class LoggingBitsSubPage {
    private LoggingSectionHandler loggingSectionHandler;
    private LoggingSectionHandler.LogParamEntry selectedLogEntry;
    private final ConfigEditor editor;
    private final LoggingPage loggingPage;
    private CheckboxTreeViewer consoleMaskViewer;
    private CheckboxTreeViewer fileMaskViewer;

    public LoggingBitsSubPage(ConfigEditor editor, LoggingPage loggingPage) {
        this.editor = editor;
        this.loggingPage = loggingPage;
    }

    void createSectionLoggingBits(FormToolkit toolkit, ScrolledForm form, Composite parent) {
        Section section = toolkit.createSection(parent, 4096);
        section.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite client = toolkit.createComposite((Composite)section, 64);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        client.setLayout((Layout)layout);
        client.setLayoutData((Object)new GridData(4, 4, true, true));
        section.setClient((Control)client);
        toolkit.paintBordersFor(client);
        this.createSubSectionConsoleMaskBits(toolkit, form, client);
        this.createSubSectionFileMaskBits(toolkit, form, client);
    }

    void createSubSectionConsoleMaskBits(FormToolkit toolkit, final ScrolledForm form, Composite parent) {
        Section section = toolkit.createSection(parent, 384);
        section.setLayoutData((Object)new GridData(4, 4, true, true));
        section.setText("Console Log bitmask");
        section.setExpanded(true);
        section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                form.reflow(false);
            }
        });
        Composite client = toolkit.createComposite((Composite)section, 64);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        client.setLayout((Layout)layout);
        section.setClient((Control)client);
        toolkit.paintBordersFor(client);
        this.consoleMaskViewer = new CheckboxTreeViewer(client, 772);
        this.consoleMaskViewer.setContentProvider((IContentProvider)new LoggingBitsContentProvider());
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = 230;
        this.consoleMaskViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.consoleMaskViewer.setLabelProvider((IBaseLabelProvider)new LoggingBitsLabelProvider());
        this.consoleMaskViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getChecked() && LoggingBitsSubPage.this.selectedLogEntry.getConsoleMaskRoot() == null) {
                    LoggingBitsSubPage.this.createConsoleMaskRootNode(LoggingBitsSubPage.this.loggingPage.getSelectedTreeElement(), LoggingBitsSubPage.this.selectedLogEntry);
                }
                LoggingBitsSubPage.this.checkStateChangeHandler(LoggingBitsSubPage.this.selectedLogEntry.getConsoleMaskBits(), LoggingBitsSubPage.this.selectedLogEntry.getConsoleMask(), event);
                LoggingBitsSubPage.this.bitCompression(LoggingBitsSubPage.this.selectedLogEntry.getConsoleMaskBits(), LoggingBitsSubPage.this.selectedLogEntry.getConsoleMask());
                LoggingBitsSubPage.this.evaluateSelection(LoggingBitsSubPage.this.consoleMaskViewer, LoggingBitsSubPage.this.selectedLogEntry.getConsoleMaskBits());
                if (!event.getChecked() && LoggingBitsSubPage.this.selectedLogEntry.getConsoleMaskBits().keySet().isEmpty()) {
                    ConfigTreeNodeUtilities.removeChild((ParseTree)LoggingBitsSubPage.this.loggingSectionHandler.getLastSectionRoot(), (ParseTree)LoggingBitsSubPage.this.selectedLogEntry.getConsoleMaskRoot());
                    LoggingBitsSubPage.this.selectedLogEntry.setConsoleMaskRoot(null);
                }
            }
        });
        this.consoleMaskViewer.getTree().addListener(32, new Listener(){

            public void handleEvent(Event event) {
                TreeItem item = LoggingBitsSubPage.this.consoleMaskViewer.getTree().getItem(new Point(event.x, event.y));
                if (item != null && item.getData() instanceof LoggingBit) {
                    LoggingBitsSubPage.this.consoleMaskViewer.getTree().setToolTipText(((LoggingBit)item.getData()).getToolTip());
                    return;
                }
                LoggingBitsSubPage.this.consoleMaskViewer.getTree().setToolTipText("");
            }
        });
        this.consoleMaskViewer.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
            }

            public void treeExpanded(TreeExpansionEvent event) {
                LoggingBitsSubPage.this.evaluateSelection(LoggingBitsSubPage.this.consoleMaskViewer, LoggingBitsSubPage.this.selectedLogEntry.getConsoleMaskBits());
            }
        });
        if (this.selectedLogEntry == null) {
            this.consoleMaskViewer.getControl().setEnabled(false);
            this.consoleMaskViewer.setInput(new EnumMap(LoggingBit.class));
        } else {
            this.consoleMaskViewer.getControl().setEnabled(true);
            this.consoleMaskViewer.setInput((Object)this.selectedLogEntry.getConsoleMaskBits());
            this.bitCompression(this.selectedLogEntry.getConsoleMaskBits(), this.selectedLogEntry.getConsoleMask());
            this.evaluateSelection(this.consoleMaskViewer, this.selectedLogEntry.getConsoleMaskBits());
        }
    }

    void createSubSectionFileMaskBits(FormToolkit toolkit, final ScrolledForm form, Composite parent) {
        Section section = toolkit.createSection(parent, 384);
        section.setLayoutData((Object)new GridData(4, 4, true, true));
        section.setText("File Log bitmask");
        section.setExpanded(true);
        section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                form.reflow(false);
            }
        });
        Composite client = toolkit.createComposite((Composite)section, 64);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        client.setLayout((Layout)layout);
        section.setClient((Control)client);
        toolkit.paintBordersFor(client);
        this.fileMaskViewer = new CheckboxTreeViewer(client, 772);
        this.fileMaskViewer.setContentProvider((IContentProvider)new LoggingBitsContentProvider());
        this.fileMaskViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.fileMaskViewer.setLabelProvider((IBaseLabelProvider)new LoggingBitsLabelProvider());
        this.fileMaskViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getChecked() && LoggingBitsSubPage.this.selectedLogEntry.getFileMaskRoot() == null) {
                    LoggingBitsSubPage.this.createFileMaskRootNode(LoggingBitsSubPage.this.loggingPage.getSelectedTreeElement(), LoggingBitsSubPage.this.selectedLogEntry);
                }
                LoggingBitsSubPage.this.checkStateChangeHandler(LoggingBitsSubPage.this.selectedLogEntry.getFileMaskBits(), LoggingBitsSubPage.this.selectedLogEntry.getFileMask(), event);
                LoggingBitsSubPage.this.bitCompression(LoggingBitsSubPage.this.selectedLogEntry.getFileMaskBits(), LoggingBitsSubPage.this.selectedLogEntry.getFileMask());
                LoggingBitsSubPage.this.evaluateSelection(LoggingBitsSubPage.this.fileMaskViewer, LoggingBitsSubPage.this.selectedLogEntry.getFileMaskBits());
                if (!event.getChecked() && LoggingBitsSubPage.this.selectedLogEntry.getFileMaskBits().keySet().isEmpty()) {
                    ConfigTreeNodeUtilities.removeChild((ParseTree)LoggingBitsSubPage.this.loggingSectionHandler.getLastSectionRoot(), (ParseTree)LoggingBitsSubPage.this.selectedLogEntry.getFileMaskRoot());
                    LoggingBitsSubPage.this.selectedLogEntry.setFileMaskRoot(null);
                }
            }
        });
        this.fileMaskViewer.getTree().addListener(32, new Listener(){

            public void handleEvent(Event event) {
                TreeItem item = LoggingBitsSubPage.this.fileMaskViewer.getTree().getItem(new Point(event.x, event.y));
                if (item != null && item.getData() instanceof LoggingBit) {
                    LoggingBitsSubPage.this.fileMaskViewer.getTree().setToolTipText(((LoggingBit)item.getData()).getToolTip());
                    return;
                }
                LoggingBitsSubPage.this.fileMaskViewer.getTree().setToolTipText("");
            }
        });
        this.fileMaskViewer.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
            }

            public void treeExpanded(TreeExpansionEvent event) {
                LoggingBitsSubPage.this.evaluateSelection(LoggingBitsSubPage.this.fileMaskViewer, LoggingBitsSubPage.this.selectedLogEntry.getFileMaskBits());
            }
        });
        if (this.selectedLogEntry == null) {
            this.fileMaskViewer.getControl().setEnabled(false);
            this.fileMaskViewer.setInput(new EnumMap(LoggingBit.class));
        } else {
            this.fileMaskViewer.getControl().setEnabled(true);
            this.fileMaskViewer.setInput((Object)this.selectedLogEntry.getFileMaskBits());
            this.bitCompression(this.selectedLogEntry.getFileMaskBits(), this.selectedLogEntry.getFileMask());
            this.evaluateSelection(this.fileMaskViewer, this.selectedLogEntry.getFileMaskBits());
        }
    }

    private void createConsoleMaskRootNode(LoggingSectionHandler.LoggerTreeElement lte, LoggingSectionHandler.LogParamEntry logentry) {
        ParserRuleContext consoleMaskRoot = new ParserRuleContext();
        logentry.setConsoleMaskRoot((ParseTree)consoleMaskRoot);
        ConfigTreeNodeUtilities.addChild((ParseTree)consoleMaskRoot, (ParseTree)new AddedParseTree("\n"));
        StringBuilder name = new StringBuilder();
        lte.writeNamePrefix(name);
        name.append("ConsoleMask := ");
        AddedParseTree node = new AddedParseTree(name.toString());
        ConfigTreeNodeUtilities.addChild((ParseTree)consoleMaskRoot, (ParseTree)node);
        ParserRuleContext consoleMask = new ParserRuleContext();
        logentry.setConsoleMask((ParseTree)consoleMask);
        ConfigTreeNodeUtilities.addChild((ParseTree)consoleMaskRoot, (ParseTree)consoleMask);
        ConfigTreeNodeUtilities.addChild((ParseTree)this.loggingSectionHandler.getLastSectionRoot(), (ParseTree)consoleMaskRoot);
    }

    private void createFileMaskRootNode(LoggingSectionHandler.LoggerTreeElement lte, LoggingSectionHandler.LogParamEntry logentry) {
        ParserRuleContext fileMaskRoot = new ParserRuleContext();
        logentry.setFileMaskRoot((ParseTree)fileMaskRoot);
        ConfigTreeNodeUtilities.addChild((ParseTree)fileMaskRoot, (ParseTree)new AddedParseTree("\n"));
        StringBuilder name = new StringBuilder();
        lte.writeNamePrefix(name);
        name.append("FileMask := ");
        AddedParseTree node = new AddedParseTree(name.toString());
        ConfigTreeNodeUtilities.addChild((ParseTree)fileMaskRoot, (ParseTree)node);
        ParserRuleContext fileMask = new ParserRuleContext();
        logentry.setFileMask((ParseTree)fileMask);
        ConfigTreeNodeUtilities.addChild((ParseTree)fileMaskRoot, (ParseTree)fileMask);
        ConfigTreeNodeUtilities.addChild((ParseTree)this.loggingSectionHandler.getLastSectionRoot(), (ParseTree)fileMaskRoot);
    }

    private void checkStateChangeHandler(Map<LoggingBit, ParseTree> bitMask, ParseTree bitmaskRoot, CheckStateChangedEvent event) {
        this.editor.setDirty();
        LoggingBit bit = (LoggingBit)event.getElement();
        if (LoggingBitHelper.hasChildren((LoggingBit)bit)) {
            LoggingBit[] children = LoggingBitHelper.getChildren((LoggingBit)bit);
            if (bitMask.containsKey(bit)) {
                this.removeLoggingBit(bitMask, bitmaskRoot, bit);
            } else {
                this.addLoggingBit(bitMask, bitmaskRoot, bit);
            }
            for (int i = 0; i < children.length; ++i) {
                if (!bitMask.containsKey(children[i])) continue;
                this.removeLoggingBit(bitMask, bitmaskRoot, children[i]);
            }
        } else if (bitMask.containsKey(bit)) {
            this.removeLoggingBit(bitMask, bitmaskRoot, bit);
        } else {
            LoggingBit parent = LoggingBitHelper.getParent((LoggingBit)bit);
            if (parent == null) {
                return;
            }
            LoggingBit[] children = LoggingBitHelper.getChildren((LoggingBit)parent);
            int elementCount = 0;
            for (LoggingBit child : children) {
                if (!bitMask.containsKey(child)) continue;
                ++elementCount;
            }
            if (bitMask.containsKey(parent)) {
                this.removeLoggingBit(bitMask, bitmaskRoot, parent);
                for (int i = 0; i < children.length; ++i) {
                    if (bitMask.containsKey(children[i]) || bit.equals((Object)children[i])) continue;
                    this.addLoggingBit(bitMask, bitmaskRoot, children[i]);
                }
            } else if (elementCount == children.length - 1) {
                this.addLoggingBit(bitMask, bitmaskRoot, parent);
                for (int i = 0; i < children.length; ++i) {
                    if (!bitMask.containsKey(children[i])) continue;
                    this.removeLoggingBit(bitMask, bitmaskRoot, children[i]);
                }
            } else {
                this.addLoggingBit(bitMask, bitmaskRoot, bit);
            }
        }
    }

    private void bitCompression(Map<LoggingBit, ParseTree> bitMask, ParseTree bitmaskRoot) {
        for (LoggingBit parent : LoggingBitHelper.getFirstLevelNodes()) {
            LoggingBit[] children = LoggingBitHelper.getChildren((LoggingBit)parent);
            if (bitMask.containsKey(parent)) {
                for (int i = 0; i < children.length; ++i) {
                    if (!bitMask.containsKey(children[i])) continue;
                    this.removeLoggingBit(bitMask, bitmaskRoot, children[i]);
                }
                continue;
            }
            int childCount = 0;
            for (LoggingBit child : children) {
                if (!bitMask.containsKey(child)) continue;
                ++childCount;
            }
            if (childCount != children.length) continue;
            this.addLoggingBit(bitMask, bitmaskRoot, parent);
            for (int i = 0; i < children.length; ++i) {
                if (!bitMask.containsKey(children[i])) continue;
                this.removeLoggingBit(bitMask, bitmaskRoot, children[i]);
            }
        }
    }

    private void addLoggingBit(Map<LoggingBit, ParseTree> bitMask, ParseTree bitmaskRoot, LoggingBit bit) {
        AddedParseTree newBit = new AddedParseTree(bit.getName());
        bitMask.put(bit, (ParseTree)newBit);
        if (bitMask.keySet().size() > 1) {
            AddedParseTree separator = new AddedParseTree("|");
            ConfigTreeNodeUtilities.addChild((ParseTree)bitmaskRoot, (ParseTree)separator);
        }
        ConfigTreeNodeUtilities.addChild((ParseTree)bitmaskRoot, (ParseTree)newBit);
    }

    private void removeLoggingBit(Map<LoggingBit, ParseTree> aBitMask, ParseTree aBitmaskRoot, LoggingBit aBit) {
        ParseTree removedBit = aBitMask.remove(aBit);
        ConfigTreeNodeUtilities.removeChildWithSeparator((ParseTree)aBitmaskRoot, (ParseTree)removedBit);
    }

    private void evaluateSelection(CheckboxTreeViewer viewer, Map<LoggingBit, ParseTree> bitMask) {
        LoggingBit[] firstLevelnodes = LoggingBitHelper.getFirstLevelNodes();
        ArrayList<LoggingBit> toBeGrayed = new ArrayList<LoggingBit>();
        ArrayList<LoggingBit> toBeSelected = new ArrayList<LoggingBit>();
        toBeSelected.addAll(bitMask.keySet());
        for (LoggingBit firstLevelnode : firstLevelnodes) {
            LoggingBit[] children = LoggingBitHelper.getChildren((LoggingBit)firstLevelnode);
            int count = 0;
            for (LoggingBit child : children) {
                if (!bitMask.containsKey(child)) continue;
                ++count;
            }
            if (count != 0) {
                toBeGrayed.add(firstLevelnode);
                toBeSelected.add(firstLevelnode);
            }
            if (!bitMask.containsKey(firstLevelnode)) continue;
            for (LoggingBit child : children) {
                toBeSelected.add(child);
            }
        }
        viewer.setGrayedElements(toBeGrayed.toArray());
        viewer.setCheckedElements(toBeSelected.toArray());
    }

    private void logAllHandler(Map<LoggingBit, ParseTree> bitMask, ParseTree bitmaskRoot) {
        if (bitMask.containsKey(LoggingBit.LOG_ALL)) {
            LoggingBit[] logAllBits;
            for (LoggingBit bit : logAllBits = LoggingBitHelper.getLogAllBits()) {
                if (bitMask.containsKey(bit)) continue;
                this.addLoggingBit(bitMask, bitmaskRoot, bit);
            }
            this.removeLoggingBit(bitMask, bitmaskRoot, LoggingBit.LOG_ALL);
        }
    }

    public void pluginRenamed() {
        ParseTree child;
        if (this.selectedLogEntry.getConsoleMaskRoot() != null) {
            child = this.selectedLogEntry.getConsoleMask().getChild(0);
            ConfigTreeNodeUtilities.removeChild((ParseTree)this.loggingSectionHandler.getLastSectionRoot(), (ParseTree)this.selectedLogEntry.getConsoleMaskRoot());
            this.createConsoleMaskRootNode(this.loggingPage.getSelectedTreeElement(), this.selectedLogEntry);
            if (child != null) {
                ConfigTreeNodeUtilities.addChild((ParseTree)this.selectedLogEntry.getConsoleMask(), (ParseTree)child, (int)0);
            }
        }
        if (this.selectedLogEntry.getFileMaskRoot() != null) {
            child = this.selectedLogEntry.getFileMask().getChild(0);
            ConfigTreeNodeUtilities.removeChild((ParseTree)this.loggingSectionHandler.getLastSectionRoot(), (ParseTree)this.selectedLogEntry.getFileMaskRoot());
            this.createFileMaskRootNode(this.loggingPage.getSelectedTreeElement(), this.selectedLogEntry);
            if (child != null) {
                ConfigTreeNodeUtilities.addChild((ParseTree)this.selectedLogEntry.getFileMask(), (ParseTree)child, (int)0);
            }
        }
    }

    private void internalRefresh() {
        this.consoleMaskViewer.setSubtreeChecked(this.consoleMaskViewer.getInput(), false);
        this.fileMaskViewer.setSubtreeChecked(this.fileMaskViewer.getInput(), false);
        if (this.selectedLogEntry == null) {
            this.consoleMaskViewer.getControl().setEnabled(false);
            this.fileMaskViewer.getControl().setEnabled(false);
        } else {
            Object[] expandedElements = this.consoleMaskViewer.getExpandedElements();
            this.consoleMaskViewer.setInput((Object)this.selectedLogEntry.getConsoleMaskBits());
            this.consoleMaskViewer.setExpandedElements(expandedElements);
            this.logAllHandler(this.selectedLogEntry.getConsoleMaskBits(), this.selectedLogEntry.getConsoleMask());
            this.consoleMaskViewer.getControl().setEnabled(true);
            this.bitCompression(this.selectedLogEntry.getConsoleMaskBits(), this.selectedLogEntry.getConsoleMask());
            this.evaluateSelection(this.consoleMaskViewer, this.selectedLogEntry.getConsoleMaskBits());
            expandedElements = this.fileMaskViewer.getExpandedElements();
            this.fileMaskViewer.setInput((Object)this.selectedLogEntry.getFileMaskBits());
            this.fileMaskViewer.setExpandedElements(expandedElements);
            this.logAllHandler(this.selectedLogEntry.getFileMaskBits(), this.selectedLogEntry.getFileMask());
            this.fileMaskViewer.getControl().setEnabled(true);
            this.bitCompression(this.selectedLogEntry.getFileMaskBits(), this.selectedLogEntry.getFileMask());
            this.evaluateSelection(this.fileMaskViewer, this.selectedLogEntry.getFileMaskBits());
        }
    }

    public void initializeEntry(LoggingSectionHandler.LoggerTreeElement lte, LoggingSectionHandler.LogParamEntry logentry) {
        this.createFileMaskRootNode(lte, logentry);
        this.addLoggingBit(logentry.getFileMaskBits(), logentry.getFileMask(), LoggingBit.LOG_ALL);
        this.logAllHandler(logentry.getConsoleMaskBits(), logentry.getConsoleMask());
        this.createConsoleMaskRootNode(lte, logentry);
        this.addLoggingBit(logentry.getConsoleMaskBits(), logentry.getConsoleMask(), LoggingBit.ERROR);
        this.addLoggingBit(logentry.getConsoleMaskBits(), logentry.getConsoleMask(), LoggingBit.WARNING);
        this.addLoggingBit(logentry.getConsoleMaskBits(), logentry.getConsoleMask(), LoggingBit.ACTION);
        this.addLoggingBit(logentry.getConsoleMaskBits(), logentry.getConsoleMask(), LoggingBit.TESTCASE);
        this.addLoggingBit(logentry.getConsoleMaskBits(), logentry.getConsoleMask(), LoggingBit.STATISTICS);
    }

    public void refreshData(LoggingSectionHandler loggingSectionHandler, LoggingSectionHandler.LogParamEntry logentry) {
        this.loggingSectionHandler = loggingSectionHandler;
        this.selectedLogEntry = logentry;
        if (this.consoleMaskViewer != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    LoggingBitsSubPage.this.internalRefresh();
                }
            });
        }
    }
}

