/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.controls;

import org.eclipse.jface.text.AbstractHoverInformationControlManager;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.titan.designer.editors.controls.Ttcn3HoverInfoControl;

public class OutlineHoverManager
extends AbstractHoverInformationControlManager {
    private Control parent;
    private int width = 600;
    private int height = 400;

    public OutlineHoverManager(IInformationControlCreator creator, Control control, MouseEvent e) {
        super(creator);
        this.install(control);
        this.getInformationControl();
        this.setCustomInformationControlCreator(creator);
        this.setAnchor(ANCHOR_TOP);
        this.parent = control;
        Point realLocation = control.getDisplay().map(control, null, e.x, e.y);
        Ttcn3HoverInfoControl infoControl = (Ttcn3HoverInfoControl)creator;
        infoControl.setSize(this.width, this.height);
        infoControl.setLocation(this.calculateTopLeft(realLocation));
    }

    protected void computeInformation() {
        this.setInformation(null, null);
    }

    public void presentInformation() {
        Rectangle rect = this.parent.getDisplay().getBounds();
        rect.x = this.width;
        rect.y = this.height;
        this.showInformationControl(rect);
    }

    private Point calculateTopLeft(Point mouse) {
        Rectangle screen = this.parent.getDisplay().getBounds();
        int x = mouse.x;
        int y = mouse.y;
        x = screen.width < x + this.width ? (x -= this.width + 20) : (x += 20);
        y = screen.height < y + this.height ? (y -= this.height + 20) : (y += 20);
        return new Point(x, y);
    }
}

