/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.ttcn3editor;

import java.text.MessageFormat;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.editors.ttcn3editor.CallHierarchyNode;
import org.eclipse.titan.designer.graphics.ImageCache;

public class CallHierarchyLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private static final String FUNCTION_ICON = "function.gif";
    private static final String TESTCASE_ICON = "testcase.gif";
    private static final String FUNCTION_EXTERNAL_ICON = "function_external.gif";
    private static final int COLUMN_ICON = 0;
    private static final int COLUMN_LINE = 1;
    private static final int COLUMN_INFO = 2;

    public Image getImage(Object element) {
        String iconName = "titan.gif";
        if (!(element instanceof CallHierarchyNode)) {
            return ImageCache.getImage(iconName);
        }
        CallHierarchyNode node = (CallHierarchyNode)element;
        switch (node.getNodeDefinition().getAssignmentType()) {
            case A_FUNCTION: 
            case A_FUNCTION_RVAL: 
            case A_FUNCTION_RTEMP: {
                iconName = FUNCTION_ICON;
                break;
            }
            case A_TESTCASE: {
                iconName = TESTCASE_ICON;
                break;
            }
            case A_EXT_FUNCTION: 
            case A_EXT_FUNCTION_RVAL: 
            case A_EXT_FUNCTION_RTEMP: {
                iconName = FUNCTION_EXTERNAL_ICON;
                break;
            }
        }
        return ImageCache.getImage(iconName);
    }

    public String getText(Object element) {
        if (!(element instanceof CallHierarchyNode)) {
            return "error";
        }
        CallHierarchyNode node = (CallHierarchyNode)element;
        int matches = node.getReferencesNumber();
        if (matches > 0) {
            String text = "{0}   -   ({1} matches)";
            return MessageFormat.format("{0}   -   ({1} matches)", node.getName().substring(1), matches);
        }
        return node.getName().substring(1);
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex != 0) {
            return null;
        }
        return ImageCache.getImage("match.gif");
    }

    public String getColumnText(Object element, int columnIndex) {
        if (!(element instanceof Reference)) {
            return null;
        }
        Reference reference = (Reference)element;
        switch (columnIndex) {
            case 1: {
                return String.valueOf(reference.getLocation().getLine());
            }
            case 2: {
                return reference.getDisplayName();
            }
        }
        return null;
    }
}

