/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.ttcn3editor;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.titan.designer.AST.IOutlineElement;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Extfunction;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Function;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Template;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Type;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Var_Template;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definitions;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Group;
import org.eclipse.titan.designer.AST.TTCN3.definitions.ICommentable;
import org.eclipse.titan.designer.AST.TTCN3.definitions.ImportModule;
import org.eclipse.titan.designer.Activator;
import org.eclipse.titan.designer.editors.OutlineViewSorter;
import org.eclipse.titan.designer.editors.controls.OutlineHoverManager;
import org.eclipse.titan.designer.editors.controls.Ttcn3HoverInfoControl;
import org.eclipse.titan.designer.editors.ttcn3editor.IUpdateSyntaxEventListener;
import org.eclipse.titan.designer.editors.ttcn3editor.OutlineContentProvider;
import org.eclipse.titan.designer.editors.ttcn3editor.OutlineStyledLabelProvider;
import org.eclipse.titan.designer.editors.ttcn3editor.UpdateSyntaxEvent;
import org.eclipse.titan.designer.graphics.ImageCache;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;
import org.eclipse.titan.designer.parsers.ProjectSourceSyntacticAnalyzer;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public final class OutlinePage
extends ContentOutlinePage
implements IUpdateSyntaxEventListener,
IPropertyChangeListener {
    private final AbstractTextEditor editor;
    private TreeViewer viewer;
    private ViewerFilter hideFunctionsFilter;
    private ViewerFilter hideTemplatesFilter;
    private ViewerFilter hideTypesFilter;
    private ViewerFilter hideImportsFilter;
    private ViewerFilter groupFilter;
    private ViewerFilter underGroupFilter;
    private ViewerFilter hideUncategorizedFilter;
    private static final String ACTION_SORT = "Sort";
    private static final String USE_CATEGORIES = "Categorise";
    private static final String ACTION_TOGGLE_GROUP_MODE = "Toggle Group Mode";
    private static final String ACTION_HIDE_FUNCTIONS = "Hide Functions";
    private static final String ACTION_HIDE_TEMPLATES = "Hide Templates";
    private static final String ACTION_HIDE_TYPES = "Hide Types";
    private static final String ACTION_HIDE_IMPORTS = "Hide Imports";
    private static final String ACTION_SHOW_UNCATEGORIZED = "Show uncategorized elements";
    private OutlineHoverManager fTextHoverManager;
    private HashSet<String> categories = new HashSet();
    private boolean showUncategorized = true;
    private Map<String, Boolean> enabledCategories = new HashMap<String, Boolean>();

    public OutlinePage(AbstractTextEditor editor) {
        this.editor = editor;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        final IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        this.viewer = this.getTreeViewer();
        this.viewer.setContentProvider((IContentProvider)new OutlineContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new OutlineStyledLabelProvider());
        OutlineViewSorter comperator = new OutlineViewSorter();
        comperator.setSortByName(store.getBoolean("org.eclipse.titan.designer.outline.sortAlphabetically"));
        comperator.setCategorizing(store.getBoolean("org.eclipse.titan.designer.outline.useCategories"));
        this.viewer.setComparator((ViewerComparator)comperator);
        ViewerFilter filterGroup = this.getGroupFilter();
        ViewerFilter filterUnderGroup = this.getUnderGroupFilter();
        if (store.getBoolean("org.eclipse.titan.designer.outline.useGroups")) {
            this.viewer.removeFilter(filterGroup);
            this.viewer.addFilter(filterUnderGroup);
        } else {
            this.viewer.removeFilter(filterUnderGroup);
            this.viewer.addFilter(filterGroup);
        }
        ViewerFilter filter = this.getHideFunctionsFilter();
        if (store.getBoolean("org.eclipse.titan.designer.outline.hideFunctions")) {
            this.viewer.addFilter(filter);
        } else {
            this.viewer.removeFilter(filter);
        }
        filter = this.getHideTemplatesFilter();
        if (store.getBoolean("org.eclipse.titan.designer.outline.hideTemplates")) {
            this.viewer.addFilter(filter);
        } else {
            this.viewer.removeFilter(filter);
        }
        filter = this.getHideTypesFilter();
        if (store.getBoolean("org.eclipse.titan.designer.outline.hideTypes")) {
            this.viewer.addFilter(filter);
        } else {
            this.viewer.removeFilter(filter);
        }
        this.viewer.setAutoExpandLevel(2);
        this.viewer.setInput((Object)this.getModule());
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        IActionBars bars = this.getSite().getActionBars();
        Action sortToggler = new Action(ACTION_SORT){

            public void run() {
                ViewerComparator comperator = OutlinePage.this.viewer.getComparator();
                if (comperator == null) {
                    comperator = new OutlineViewSorter();
                    OutlinePage.this.viewer.setComparator(comperator);
                }
                if (comperator instanceof OutlineViewSorter) {
                    store.setValue("org.eclipse.titan.designer.outline.sortAlphabetically", this.isChecked());
                    ((OutlineViewSorter)comperator).setSortByName(this.isChecked());
                }
                OutlinePage.this.viewer.refresh(false);
            }
        };
        sortToggler.setImageDescriptor(ImageCache.getImageDescriptor("sort_alphabetically.gif"));
        sortToggler.setChecked(store.getBoolean("org.eclipse.titan.designer.outline.sortAlphabetically"));
        bars.getToolBarManager().add((IAction)sortToggler);
        Action categorise = new Action(USE_CATEGORIES){

            public void run() {
                ViewerComparator comperator = OutlinePage.this.viewer.getComparator();
                if (comperator == null) {
                    comperator = new OutlineViewSorter();
                    OutlinePage.this.viewer.setComparator(comperator);
                }
                if (comperator instanceof OutlineViewSorter) {
                    store.setValue("org.eclipse.titan.designer.outline.useCategories", this.isChecked());
                    ((OutlineViewSorter)comperator).setCategorizing(this.isChecked());
                }
                OutlinePage.this.viewer.refresh(false);
            }
        };
        categorise.setImageDescriptor(ImageCache.getImageDescriptor("categorize.gif"));
        categorise.setChecked(store.getBoolean("org.eclipse.titan.designer.outline.useCategories"));
        bars.getToolBarManager().add((IAction)categorise);
        Action toggleGroupMode = new Action(ACTION_TOGGLE_GROUP_MODE){

            public void run() {
                ViewerFilter filterGroup = OutlinePage.this.getGroupFilter();
                ViewerFilter filterUnderGroup = OutlinePage.this.getUnderGroupFilter();
                store.setValue("org.eclipse.titan.designer.outline.useGroups", this.isChecked());
                if (this.isChecked()) {
                    OutlinePage.this.viewer.removeFilter(filterGroup);
                    OutlinePage.this.viewer.addFilter(filterUnderGroup);
                } else {
                    OutlinePage.this.viewer.removeFilter(filterUnderGroup);
                    OutlinePage.this.viewer.addFilter(filterGroup);
                }
                OutlinePage.this.viewer.refresh(false);
            }
        };
        toggleGroupMode.setImageDescriptor(ImageCache.getImageDescriptor("outline_group.gif"));
        toggleGroupMode.setChecked(store.getBoolean("org.eclipse.titan.designer.outline.useGroups"));
        bars.getToolBarManager().add((IAction)toggleGroupMode);
        Action hideFunctions = new Action(ACTION_HIDE_FUNCTIONS){

            public void run() {
                ViewerFilter filter = OutlinePage.this.getHideFunctionsFilter();
                store.setValue("org.eclipse.titan.designer.outline.hideFunctions", this.isChecked());
                if (this.isChecked()) {
                    OutlinePage.this.viewer.addFilter(filter);
                } else {
                    OutlinePage.this.viewer.removeFilter(filter);
                }
                OutlinePage.this.viewer.refresh(false);
            }
        };
        hideFunctions.setImageDescriptor(ImageCache.getImageDescriptor("filter_functions.gif"));
        hideFunctions.setChecked(store.getBoolean("org.eclipse.titan.designer.outline.hideFunctions"));
        bars.getToolBarManager().add((IAction)hideFunctions);
        Action hideTemplates = new Action(ACTION_HIDE_TEMPLATES){

            public void run() {
                ViewerFilter filter = OutlinePage.this.getHideTemplatesFilter();
                store.setValue("org.eclipse.titan.designer.outline.hideTemplates", this.isChecked());
                if (this.isChecked()) {
                    OutlinePage.this.viewer.addFilter(filter);
                } else {
                    OutlinePage.this.viewer.removeFilter(filter);
                }
                OutlinePage.this.viewer.refresh(false);
            }
        };
        hideTemplates.setImageDescriptor(ImageCache.getImageDescriptor("filter_templates.gif"));
        hideTemplates.setChecked(store.getBoolean("org.eclipse.titan.designer.outline.hideTemplates"));
        bars.getToolBarManager().add((IAction)hideTemplates);
        Action hideTypes = new Action(ACTION_HIDE_TYPES){

            public void run() {
                ViewerFilter filter = OutlinePage.this.getHideTypesFilter();
                store.setValue("org.eclipse.titan.designer.outline.hideTypes", this.isChecked());
                if (this.isChecked()) {
                    OutlinePage.this.viewer.addFilter(filter);
                } else {
                    OutlinePage.this.viewer.removeFilter(filter);
                }
                OutlinePage.this.viewer.refresh(false);
            }
        };
        hideTypes.setImageDescriptor(ImageCache.getImageDescriptor("filter_types.gif"));
        hideTypes.setChecked(store.getBoolean("org.eclipse.titan.designer.outline.hideTypes"));
        bars.getToolBarManager().add((IAction)hideTypes);
        Action hideImports = new Action(ACTION_HIDE_IMPORTS){

            public void run() {
                ViewerFilter filter = OutlinePage.this.getHideImportsFilter();
                store.setValue("org.eclipse.titan.designer.outline.hideImports", this.isChecked());
                if (this.isChecked()) {
                    OutlinePage.this.viewer.addFilter(filter);
                } else {
                    OutlinePage.this.viewer.removeFilter(filter);
                }
                OutlinePage.this.viewer.refresh();
            }
        };
        hideImports.setImageDescriptor(ImageCache.getImageDescriptor("filter_imports.gif"));
        hideImports.setChecked(store.getBoolean("org.eclipse.titan.designer.outline.hideImports"));
        bars.getToolBarManager().add((IAction)hideImports);
        Action showUncategorizedItems = new Action(ACTION_SHOW_UNCATEGORIZED){

            public void run() {
                OutlinePage.this.showUncategorized = !OutlinePage.this.showUncategorized;
                this.setChecked(OutlinePage.this.showUncategorized);
                OutlinePage.this.viewer.refresh();
            }
        };
        showUncategorizedItems.setChecked(this.showUncategorized);
        this.viewer.addFilter(this.getHideUncategorizedFilter());
        bars.getMenuManager().add((IAction)showUncategorizedItems);
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        ProjectSourceSyntacticAnalyzer.addSyntaxUpdateListener(this);
        this.viewer.getTree().addMouseTrackListener(new MouseTrackListener(){

            public void mouseHover(MouseEvent event) {
                IPreferencesService prefs = Platform.getPreferencesService();
                boolean isHoveringEnabled = prefs.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.enableOutlineHoverTooltip", false, null);
                if (!isHoveringEnabled) {
                    return;
                }
                Tree tree = OutlinePage.this.viewer.getTree();
                TreeItem item = tree.getItem(new Point(event.x, event.y));
                if (item != null && item.getData() instanceof Definition) {
                    Ttcn3HoverInfoControl control = new Ttcn3HoverInfoControl(OutlinePage.this.getControl().getShell());
                    Definition definition = (Definition)item.getData();
                    control.setInput(definition.getHoverContent(null));
                    OutlinePage.this.fTextHoverManager = new OutlineHoverManager(control, OutlinePage.this.viewer.getControl(), event);
                    OutlinePage.this.fTextHoverManager.presentInformation();
                }
            }

            public void mouseExit(MouseEvent e) {
            }

            public void mouseEnter(MouseEvent e) {
            }
        });
    }

    private ViewerFilter getGroupFilter() {
        if (this.groupFilter == null) {
            this.groupFilter = new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    return !(element instanceof Group);
                }
            };
        }
        return this.groupFilter;
    }

    private ViewerFilter getUnderGroupFilter() {
        if (this.underGroupFilter == null) {
            this.underGroupFilter = new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    if (element instanceof Definition && ((Definition)element).getParentGroup() != null && !(parentElement instanceof Group)) {
                        return false;
                    }
                    return !(element instanceof ImportModule) || ((ImportModule)element).getParentGroup() == null || parentElement instanceof Vector;
                }
            };
        }
        return this.underGroupFilter;
    }

    private ViewerFilter getHideFunctionsFilter() {
        if (this.hideFunctionsFilter == null) {
            this.hideFunctionsFilter = new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    return !(element instanceof Def_Function) && !(element instanceof Def_Extfunction);
                }
            };
        }
        return this.hideFunctionsFilter;
    }

    private ViewerFilter getHideTemplatesFilter() {
        if (this.hideTemplatesFilter == null) {
            this.hideTemplatesFilter = new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    return !(element instanceof Def_Template) && !(element instanceof Def_Var_Template);
                }
            };
        }
        return this.hideTemplatesFilter;
    }

    private ViewerFilter getHideTypesFilter() {
        if (this.hideTypesFilter == null) {
            this.hideTypesFilter = new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    return !(element instanceof Def_Type);
                }
            };
        }
        return this.hideTypesFilter;
    }

    private ViewerFilter getHideImportsFilter() {
        if (this.hideImportsFilter == null) {
            this.hideImportsFilter = new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    return !(element instanceof ImportModule);
                }
            };
        }
        return this.hideImportsFilter;
    }

    private ViewerFilter getHideUncategorizedFilter() {
        if (this.hideUncategorizedFilter == null) {
            this.hideUncategorizedFilter = new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    Object[] children;
                    if (element instanceof ICommentable) {
                        if (element instanceof Definitions) {
                            return true;
                        }
                        ICommentable commentable = (ICommentable)element;
                        if (commentable.hasDocumentComment() && commentable.getDocumentComment().hasCategory()) {
                            Boolean enabled = (Boolean)OutlinePage.this.enabledCategories.get(commentable.getDocumentComment().getCategory());
                            return enabled != null && enabled != false;
                        }
                    }
                    if (element instanceof Definition && (children = ((Definition)element).getOutlineChildren()) != null && children.length > 0) {
                        for (Object child : children) {
                            ICommentable cchild;
                            if (!(child instanceof ICommentable) || !(cchild = (ICommentable)child).hasDocumentComment() || !cchild.getDocumentComment().hasCategory()) continue;
                            Boolean enabled = (Boolean)OutlinePage.this.enabledCategories.get(cchild.getDocumentComment().getCategory());
                            return enabled != null && enabled != false;
                        }
                    }
                    return OutlinePage.this.showUncategorized;
                }
            };
        }
        return this.hideUncategorizedFilter;
    }

    public void update() {
        Control control = this.getControl();
        if (control != null && !control.isDisposed()) {
            control.setRedraw(false);
            this.getTreeViewer().setInput((Object)this.getModule());
            control.setRedraw(true);
        }
        HashSet<String> existing = new HashSet<String>(this.categories);
        TreeItem[] items = this.getTreeViewer().getTree().getItems();
        if (items.length == 0) {
            return;
        }
        TreeItem root = items[0];
        if (root == null) {
            return;
        }
        if (root.getData() instanceof Definitions) {
            this.categories = new HashSet();
            Definitions defs = (Definitions)root.getData();
            for (int i = 0; i < defs.getNofAssignments(); ++i) {
                Definition elemDef = defs.getAssignmentByIndex(i);
                this.collectDefinitionCategory(elemDef);
                Object[] children = elemDef.getOutlineChildren();
                if (children == null || children.length <= 0) continue;
                for (Object child : children) {
                    if (!(child instanceof Definition)) continue;
                    Definition childDef = (Definition)child;
                    this.collectDefinitionCategory(childDef);
                }
            }
        }
        IActionBars bars = this.getSite().getActionBars();
        IMenuManager menumanager = bars.getMenuManager();
        for (final String s : existing) {
            if (this.categories.contains(s)) continue;
            menumanager.remove(s);
            menumanager.update();
            this.enabledCategories.remove(s);
        }
        for (final String s : this.categories) {
            if (existing.contains(s)) continue;
            Action action = new Action(s){

                public void run() {
                    Boolean isChecked = (Boolean)OutlinePage.this.enabledCategories.get(s);
                    if (isChecked == null) {
                        return;
                    }
                    isChecked = isChecked == false;
                    OutlinePage.this.enabledCategories.put(s, isChecked);
                    this.setChecked(isChecked);
                    OutlinePage.this.viewer.refresh();
                }
            };
            action.setChecked(true);
            this.enabledCategories.put(s, true);
            action.setId(s);
            menumanager.add((IAction)action);
            menumanager.update();
        }
    }

    private void collectDefinitionCategory(Definition definition) {
        String category;
        Definition commentable;
        if (definition instanceof ICommentable && (commentable = definition).hasDocumentComment() && commentable.getDocumentComment().hasCategory() && !this.categories.contains(category = commentable.getDocumentComment().getCategory())) {
            this.categories.add(category);
        }
    }

    public void refresh() {
        Control control = this.getControl();
        if (control == null || control.isDisposed()) {
            return;
        }
        control.setRedraw(false);
        Module module = this.getModule();
        if (this.getTreeViewer().getInput() == module) {
            this.getTreeViewer().refresh();
            this.getTreeViewer().expandToLevel(2);
        } else {
            this.getTreeViewer().setInput((Object)this.getModule());
        }
        control.setRedraw(true);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        super.selectionChanged(event);
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (page == null) {
            return;
        }
        IWorkbenchPart part = page.getActivePart();
        ISelection selection = event.getSelection();
        if (part instanceof ContentOutline) {
            if (selection.isEmpty()) {
                return;
            }
            Object selectedElement = ((IStructuredSelection)selection).getFirstElement();
            Identifier identifier = null;
            if (selectedElement instanceof IOutlineElement) {
                identifier = ((IOutlineElement)selectedElement).getIdentifier();
            }
            if (identifier == null || identifier.getLocation() == null) {
                return;
            }
            Location location = identifier.getLocation();
            this.editor.selectAndReveal(location.getOffset(), location.getEndOffset() - location.getOffset());
        } else if (selection instanceof TreeSelection) {
            TreePath tp;
            TreeSelection treeSelection = (TreeSelection)selection;
            TreePath[] paths = treeSelection.getPaths();
            TreePath treePath = tp = paths.length > 0 ? paths[0] : null;
            if (tp != null) {
                this.getTreeViewer().setExpandedState((Object)tp, true);
            }
        }
    }

    private Module getModule() {
        IFile file = (IFile)this.editor.getEditorInput().getAdapter(IFile.class);
        if (file == null) {
            return null;
        }
        ProjectSourceParser sourceParser = GlobalParser.getProjectSourceParser(file.getProject());
        Module module = sourceParser.containedModule(file);
        if (module == null || module.getLastCompilationTimeStamp() == null) {
            return null;
        }
        return module;
    }

    public void dispose() {
        ProjectSourceSyntacticAnalyzer.removeUpdateSyntaxListener(this);
        Activator.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        super.dispose();
    }

    @Override
    public void afterSyntaxUpdate(UpdateSyntaxEvent e) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                OutlinePage.this.update();
            }
        });
    }

    @Override
    public void beforeSyntaxUpdate(UpdateSyntaxEvent e) {
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if ("org.eclipse.titan.designer.enableOutlineSemanticHighlighting".equals(property)) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    OutlinePage.this.update();
                }
            });
        }
    }
}

