/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.ttcn3editor.contentassist;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.attributes.Types;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_AbsFunction;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Function;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_FunctionBase;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Var;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definitions;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameter;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameterList;
import org.eclipse.titan.designer.AST.TTCN3.types.Class_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.Referenced_Type;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.ttcn3editor.contentassist.ProposalContext;
import org.eclipse.titan.designer.editors.ttcn3editor.contentassist.ProposalContextInfo;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReferenceAnalyzer;

public class FunctionParamContext
extends ProposalContext {
    public FunctionParamContext(ProposalContextInfo proposalContextInfo) {
        super(proposalContextInfo);
        this.doFallback = false;
    }

    @Override
    public void getProposals(ProposalCollector propCollector) {
        Matcher matcher = this.proposalContextInfo.matcher;
        String chain = matcher.group(1);
        if (chain.isEmpty()) {
            return;
        }
        String lastObject = chain.replaceAll("\\.$", "");
        String functionName = matcher.group(4);
        String parameters = matcher.group(5);
        int index = FunctionParamContext.countMatches(parameters, ',');
        String fullFunctionName = chain + functionName;
        CompilationTimeStamp timestamp = this.proposalContextInfo.module.getLastCompilationTimeStamp();
        Reference reference = TTCN3ReferenceAnalyzer.parseForCompletion(this.proposalContextInfo.file, lastObject);
        if (reference == null || this.proposalContextInfo.scope == null) {
            return;
        }
        Assignment assignment = this.proposalContextInfo.scope.getAssBySRef(timestamp, reference);
        if (assignment == null) {
            return;
        }
        String prefix = this.getPrefix();
        IType type = assignment.getType(timestamp);
        if (assignment instanceof Def_Var || assignment instanceof Def_Function) {
            if (type != null && reference.getSubreferences().size() > 1) {
                type = type.getFieldType(timestamp, reference, 1, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, null, false);
            }
            if (type instanceof Referenced_Type) {
                type = type.getTypeRefdLast(timestamp);
            }
            if (type instanceof Class_Type) {
                Def_FunctionBase f;
                FormalParameterList fpl;
                Class_Type classType = (Class_Type)type;
                ArrayList<Def_FunctionBase> result = new ArrayList<Def_FunctionBase>();
                FunctionParamContext.getClassFunction(classType, functionName, timestamp, result);
                if (result.size() > 0 && index < (fpl = (f = (Def_FunctionBase)result.get(0)).getFormalParameterList()).getNofParameters()) {
                    FormalParameter fp = fpl.getParameterByIndex(index);
                    Type paramType = fp.getType(timestamp);
                    this.addItemsByType(paramType, propCollector, prefix, null);
                }
            }
        }
    }

    private static int countMatches(String s, char c) {
        if (s == null) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != c) continue;
            ++count;
        }
        return count;
    }

    private static void getClassFunction(Class_Type classType, String functionName, CompilationTimeStamp timestamp, List<Def_FunctionBase> result) {
        Map<String, Def_AbsFunction> absFunctions = classType.getAbstractFunctions();
        for (Def_AbsFunction absFunction : absFunctions.values()) {
            String absFunctionName = absFunction.getIdentifier().getTtcnName();
            if (!functionName.equals(absFunctionName)) continue;
            result.add(absFunction);
        }
        Definitions members = classType.getMembers();
        Map<String, Definition> membersMap = members.getDefinitionMap();
        for (Definition member : membersMap.values()) {
            String memberName = member.getIdentifier().getTtcnName();
            if (!functionName.equals(memberName) || !(member instanceof Def_Function)) continue;
            Def_Function f = (Def_Function)member;
            result.add(f);
        }
        Class_Type baseClassType = classType.getBaseClass();
        if (baseClassType != null) {
            FunctionParamContext.getClassFunction(baseClassType, functionName, timestamp, result);
        }
        Types traitClasses = classType.getBaseTraits();
        for (int i = 0; i < traitClasses.getNofTypes(); ++i) {
            IType type = traitClasses.getType(i);
            if (type instanceof Referenced_Type) {
                type = type.getTypeRefdLast(timestamp);
            }
            if (!(type instanceof Class_Type)) continue;
            Class_Type traitClassType = (Class_Type)type;
            FunctionParamContext.getClassFunction(traitClassType, functionName, timestamp, result);
        }
    }
}

