/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.parsers;

import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.tree.ParseTree;
import org.eclipse.titan.common.parsers.IPrinter;
import org.eclipse.titan.common.parsers.ParserLogger;
import org.eclipse.titan.common.parsers.cfg.CfgParser;
import org.eclipse.titan.designer.parsers.TitanDebugConsolePrinter;
import org.eclipse.titan.designer.parsers.asn1parser.Asn1Parser;
import org.eclipse.titan.designer.parsers.extensionattributeparser.ExtensionAttributeParser;
import org.eclipse.titan.designer.parsers.ttcn3parser.PreprocessorDirectiveParser;
import org.eclipse.titan.designer.parsers.ttcn3parser.Ttcn3Parser;
import org.eclipse.titan.designer.parsers.ttcn3parser.Ttcn3Reparser;
import org.eclipse.titan.designer.preferences.SubscribedBoolean;

public class ParserUtilities {
    private static SubscribedBoolean sParseTreeLogged = new SubscribedBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.debug.console.parsetree", false);

    public static final boolean isParseTreeLogged() {
        return (Boolean)sParseTreeLogged.getValue();
    }

    public static final void setBuildParseTree(Parser aParser) {
        aParser.setBuildParseTree(ParserUtilities.isParseTreeLogged());
    }

    public static void logParseTree(ParseTree aRoot, Parser aParser) {
        if (!aParser.getBuildParseTree()) {
            return;
        }
        String description = ParserUtilities.getDescription(aParser);
        TitanDebugConsolePrinter p = TitanDebugConsolePrinter.INSTANCE;
        ParserLogger.log((ParseTree)aRoot, (Parser)aParser, (IPrinter)p, (String)description);
    }

    private static String getDescription(Parser aParser) {
        if (aParser == null) {
            return null;
        }
        if (aParser instanceof Ttcn3Parser) {
            return "TTCN-3";
        }
        if (aParser instanceof Ttcn3Reparser) {
            return "TTCN-3 incremental parsing";
        }
        if (aParser instanceof Asn1Parser) {
            return "ASN.1";
        }
        if (aParser instanceof ExtensionAttributeParser) {
            return "Extension Attribute";
        }
        if (aParser instanceof PreprocessorDirectiveParser) {
            return "Preprocessor Directive";
        }
        if (aParser instanceof CfgParser) {
            return "CFG";
        }
        return null;
    }
}

