/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.samples;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.utils.FileUtils;

public abstract class SampleProject {
    public void setupProject(IProject project, IFolder sourceFolder) {
        try {
            if (!sourceFolder.exists()) {
                sourceFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
            }
            this.preconfigure(project);
            this.setupFiles(this.getSourceFileContent(), (IContainer)sourceFolder);
            this.setupFiles(this.getOtherFileContent(), (IContainer)project);
            this.configure(project);
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)"Error while creating project", (Throwable)e);
        }
    }

    protected void preconfigure(IProject project) {
    }

    protected abstract void configure(IProject var1);

    private void setupFiles(Map<String, String> files, IContainer root) throws CoreException {
        for (Map.Entry<String, String> entry : files.entrySet()) {
            IFile file;
            int indexOfLastSlash = entry.getKey().lastIndexOf(47);
            String filename = entry.getKey().substring(indexOfLastSlash + 1);
            if (indexOfLastSlash != -1) {
                String dir = entry.getKey().substring(0, indexOfLastSlash);
                IFolder folder = root.getFolder((IPath)new Path(dir));
                if (!folder.exists()) {
                    this.createFolder(folder);
                }
                file = folder.getFile(filename);
            } else {
                file = root.getFile((IPath)new Path(entry.getKey()));
            }
            file.create((InputStream)new BufferedInputStream(new ByteArrayInputStream(entry.getValue().getBytes())), true, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    private void createFolder(IFolder folder) throws CoreException {
        FileUtils.createDir((IFolder)folder);
    }

    public abstract String getName();

    public abstract String getDescription();

    public abstract Map<String, String> getSourceFileContent();

    public Map<String, String> getOtherFileContent() {
        return new HashMap<String, String>();
    }
}

