/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.gui;

import java.util.Collection;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.titanium.error.GUIErrorHandler;
import org.eclipse.titanium.gui.Searchable;
import org.eclipse.titanium.swt.SWTResourceManager;

public class FindWindow<T extends Comparable>
extends Dialog {
    protected Shell shlFind;
    private final Searchable<T> view;
    private final Collection<T> totalSet;
    private Label lblResults;
    private Tree tree;
    private final SortedSet<T> treeItems;
    protected final GUIErrorHandler errorHandler = new GUIErrorHandler();

    public FindWindow(Shell parent, Searchable<T> view, Collection<T> totalList) throws IllegalArgumentException {
        super(parent);
        if (view == null) {
            throw new IllegalArgumentException("The totalList parameter of FindWindow's constructor mustn't be null!");
        }
        if (totalList == null) {
            throw new IllegalArgumentException("The totalList parameter of FindWindow's constructor mustn't be null!");
        }
        this.view = view;
        this.treeItems = new TreeSet<T>();
        this.totalSet = totalList;
        this.setText("Find");
    }

    public void open() {
        this.createContents();
        this.shlFind.open();
        Display display = this.getParent().getDisplay();
        while (!this.shlFind.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        this.view.clearResults();
    }

    public void close() {
        this.view.clearResults();
        if (!this.shlFind.isDisposed()) {
            this.shlFind.close();
        }
    }

    private void createContents() {
        this.shlFind = new Shell(this.getParent(), 112);
        this.shlFind.setModified(true);
        this.shlFind.setImage(SWTResourceManager.getImage("resources/icons/search_src.gif"));
        this.shlFind.setText("Find");
        this.shlFind.setMaximized(true);
        this.shlFind.setLayout((Layout)new GridLayout(1, false));
        Label nameLabel = new Label((Composite)this.shlFind, 0);
        nameLabel.setText("Name: ");
        final Text text = new Text((Composite)this.shlFind, 2048);
        text.setLayoutData((Object)new GridData(4, 0, false, false));
        text.setSize(120, 10);
        FillLayout fl = new FillLayout();
        Composite buttonsAndCheckBoxes = new Composite((Composite)this.shlFind, 0);
        buttonsAndCheckBoxes.setLayout((Layout)fl);
        buttonsAndCheckBoxes.setLayoutData((Object)new GridData(4, 0, true, false));
        Composite checkBoxes = new Composite(buttonsAndCheckBoxes, 0);
        GridLayout cbLayout = new GridLayout(1, false);
        cbLayout.verticalSpacing = 15;
        checkBoxes.setLayout((Layout)cbLayout);
        final Button btnExactMatch = new Button(checkBoxes, 32);
        btnExactMatch.setText("Exact match");
        final Button btnCaseSensitive = new Button(checkBoxes, 32);
        btnCaseSensitive.setText("Case sensitive");
        Composite buttons = new Composite(buttonsAndCheckBoxes, 0x4000000);
        GridLayout btLayout = new GridLayout(1, false);
        btLayout.verticalSpacing = 5;
        buttons.setLayout((Layout)btLayout);
        Button btnFind = new Button(buttons, 8);
        btnFind.setText("Find");
        Button btnClearResult = new Button(buttons, 8);
        btnClearResult.setText("Clear result");
        this.lblResults = new Label((Composite)this.shlFind, 0);
        this.lblResults.setText("Results:");
        this.tree = new Tree((Composite)this.shlFind, 2048);
        this.tree.setLayoutData((Object)new GridData(4, 4, true, true));
        this.tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindWindow.this.view.elemChosen((Comparable)FindWindow.this.tree.getSelection()[0].getData());
            }
        });
        btnFind.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String name = text.getText();
                boolean exactMatch = btnExactMatch.getSelection();
                boolean caseSensitive = btnCaseSensitive.getSelection();
                boolean noResult = true;
                if (!caseSensitive) {
                    name = name.toLowerCase();
                }
                for (Comparable actElem : FindWindow.this.totalSet) {
                    String elemName = actElem.toString();
                    if (!caseSensitive) {
                        elemName = elemName.toLowerCase();
                    }
                    if (!exactMatch && elemName.contains(name)) {
                        FindWindow.this.treeItems.add(actElem);
                        continue;
                    }
                    if (!exactMatch || !elemName.equals(name)) continue;
                    FindWindow.this.treeItems.add(actElem);
                }
                for (Comparable actElem : FindWindow.this.treeItems) {
                    TreeItem item = new TreeItem(FindWindow.this.tree, 0);
                    item.setText(actElem.toString());
                    item.setData((Object)actElem);
                    noResult = false;
                }
                if (noResult) {
                    FindWindow.this.errorHandler.reportInformation("The search hasn't found such node!");
                }
            }
        });
        btnClearResult.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindWindow.this.tree.removeAll();
                FindWindow.this.treeItems.clear();
                FindWindow.this.view.clearResults();
            }
        });
        this.shlFind.pack();
    }
}

