/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.markers.spotters.implementation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.statements.AltGuard;
import org.eclipse.titan.designer.AST.TTCN3.statements.AltGuards;
import org.eclipse.titan.designer.AST.TTCN3.statements.Alt_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.DoWhile_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.For_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.If_Clause;
import org.eclipse.titan.designer.AST.TTCN3.statements.If_Clauses;
import org.eclipse.titan.designer.AST.TTCN3.statements.If_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.SelectCase;
import org.eclipse.titan.designer.AST.TTCN3.statements.SelectCase_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.SelectCases;
import org.eclipse.titan.designer.AST.TTCN3.statements.StatementBlock;
import org.eclipse.titan.designer.AST.TTCN3.statements.While_Statement;
import org.eclipse.titan.designer.AST.TTCN3.values.Boolean_Value;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titanium.markers.spotters.BaseCodeSmellSpotter;
import org.eclipse.titanium.markers.spotters.BaseModuleCodeSmellSpotter;
import org.eclipse.titanium.markers.types.CodeSmellType;

public class UnnecessaryControl {
    private static final String ALWAYS_TRUE = "This control is unnecessary because the conditional expression evaluates to true";
    private static final String ALWAYS_FALSE = "This control is unnecessary because the conditional expression evaluates to false";
    private static final String UNREACHEBLE = "Control never reaches this code because the final condition evaluates to false";

    private UnnecessaryControl() {
    }

    public static class Alt
    extends Base {
        private static final String AFTER_ELSE = "Control never reaches this branch of alternative because of a previous [else] branch";

        @Override
        public void process(IVisitableNode node, BaseCodeSmellSpotter.Problems problems) {
            if (!(node instanceof Alt_Statement)) {
                return;
            }
            Alt_Statement s = (Alt_Statement)node;
            AltGuards altGuards = s.getAltGuards();
            if (altGuards == null) {
                return;
            }
            int size = altGuards.getNofAltguards();
            boolean unreachable = false;
            for (int i = 0; i < size; ++i) {
                AltGuard guard = altGuards.getAltguardByIndex(i);
                if (unreachable) {
                    problems.report(guard.getLocation(), AFTER_ELSE);
                }
                if (!AltGuard.altguard_type.AG_ELSE.equals((Object)guard.getType())) continue;
                unreachable = true;
            }
        }

        @Override
        public List<Class<? extends IVisitableNode>> getStartNode() {
            ArrayList<Class<? extends IVisitableNode>> ret = new ArrayList<Class<? extends IVisitableNode>>(1);
            ret.add(Alt_Statement.class);
            return ret;
        }
    }

    public static class If
    extends Base {
        private static final String HANDLED = "Control never reaches this code because of previous effective condition(s)";
        private static final String UNREACHABLE = "Control never reaches this code because the conditional expression evaluates to false";

        @Override
        public void process(IVisitableNode node, BaseCodeSmellSpotter.Problems problems) {
            if (!(node instanceof If_Statement)) {
                return;
            }
            If_Statement s = (If_Statement)node;
            If_Clauses clauses = s.getIfClauses();
            if (clauses == null) {
                return;
            }
            List ifclauses = clauses.getClauses();
            int size = ifclauses.size();
            boolean unreachable = false;
            for (int i = 0; i < size; ++i) {
                Value expression;
                If_Clause ic = (If_Clause)ifclauses.get(i);
                if (unreachable) {
                    problems.report(ic.getLocation(), HANDLED);
                }
                if ((expression = ic.getExpression()) == null) continue;
                IValue last = expression.getValueRefdLast(this.timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, null);
                IType.Type_type tempType = last.getExpressionReturntype(this.timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE);
                if (last.getIsErroneous(this.timestamp) || IType.Type_type.TYPE_UNDEFINED.equals((Object)tempType) || !IType.Type_type.TYPE_BOOL.equals((Object)tempType) || expression.isUnfoldable(this.timestamp)) continue;
                if (((Boolean_Value)last).getValue()) {
                    problems.report(expression.getLocation(), UnnecessaryControl.ALWAYS_TRUE);
                    unreachable = true;
                    continue;
                }
                problems.report(expression.getLocation(), UnnecessaryControl.ALWAYS_FALSE);
                problems.report(ic.getStatementBlock().getLocation(), UNREACHABLE);
            }
            if (s.getStatementBlock() != null && unreachable) {
                problems.report(s.getStatementBlock().getLocation(), HANDLED);
            }
        }

        @Override
        public List<Class<? extends IVisitableNode>> getStartNode() {
            ArrayList<Class<? extends IVisitableNode>> ret = new ArrayList<Class<? extends IVisitableNode>>(1);
            ret.add(If_Statement.class);
            return ret;
        }
    }

    public static class Select
    extends Base {
        private static final String UNREACHABLE = "Control never reaches this code because of previous effective cases(s)";

        @Override
        public void process(IVisitableNode node, BaseCodeSmellSpotter.Problems problems) {
            if (!(node instanceof SelectCase_Statement)) {
                return;
            }
            SelectCase_Statement s = (SelectCase_Statement)node;
            SelectCases cases = s.getSelectCases();
            if (cases == null) {
                return;
            }
            List selectcases = cases.getSelectCaseArray();
            int size = selectcases.size();
            boolean unreachable = false;
            for (int i = 0; i < size; ++i) {
                SelectCase sc = (SelectCase)selectcases.get(i);
                if (unreachable) {
                    problems.report(sc.getLocation(), UNREACHABLE);
                }
                if (!sc.hasElse()) continue;
                unreachable = true;
            }
        }

        @Override
        public List<Class<? extends IVisitableNode>> getStartNode() {
            ArrayList<Class<? extends IVisitableNode>> ret = new ArrayList<Class<? extends IVisitableNode>>(1);
            ret.add(SelectCase_Statement.class);
            return ret;
        }
    }

    public static class DoWhile
    extends Base {
        @Override
        public void process(IVisitableNode node, BaseCodeSmellSpotter.Problems problems) {
            if (!(node instanceof DoWhile_Statement)) {
                return;
            }
            DoWhile_Statement s = (DoWhile_Statement)node;
            Value expression = s.getExpression();
            IValue last = expression.getValueRefdLast(this.timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, null);
            IType.Type_type tempType = last.getExpressionReturntype(this.timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE);
            if (!last.getIsErroneous(this.timestamp)) {
                if (!IType.Type_type.TYPE_BOOL.equals((Object)tempType)) {
                    return;
                }
                if (!expression.isUnfoldable(this.timestamp) && !((Boolean_Value)last).getValue()) {
                    problems.report(expression.getLocation(), UnnecessaryControl.ALWAYS_FALSE);
                }
            }
        }

        @Override
        public List<Class<? extends IVisitableNode>> getStartNode() {
            ArrayList<Class<? extends IVisitableNode>> ret = new ArrayList<Class<? extends IVisitableNode>>(1);
            ret.add(DoWhile_Statement.class);
            return ret;
        }
    }

    public static class While
    extends Base {
        @Override
        public void process(IVisitableNode node, BaseCodeSmellSpotter.Problems problems) {
            if (!(node instanceof While_Statement)) {
                return;
            }
            While_Statement s = (While_Statement)node;
            Value expression = s.getExpression();
            if (expression == null) {
                return;
            }
            IValue last = expression.getValueRefdLast(this.timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, null);
            IType.Type_type tempType = last.getExpressionReturntype(this.timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE);
            if (!last.getIsErroneous(this.timestamp)) {
                if (!IType.Type_type.TYPE_BOOL.equals((Object)tempType)) {
                    return;
                }
                if (!expression.isUnfoldable(this.timestamp) && !((Boolean_Value)last).getValue()) {
                    problems.report(expression.getLocation(), UnnecessaryControl.UNREACHEBLE);
                }
            }
        }

        @Override
        public List<Class<? extends IVisitableNode>> getStartNode() {
            ArrayList<Class<? extends IVisitableNode>> ret = new ArrayList<Class<? extends IVisitableNode>>();
            ret.add(While_Statement.class);
            return ret;
        }
    }

    public static class For
    extends Base {
        private static final String ONE_SHOT = "This loop is executed at most once, because the body always returns";

        @Override
        public void process(IVisitableNode node, BaseCodeSmellSpotter.Problems problems) {
            StatementBlock statementblock;
            if (!(node instanceof For_Statement)) {
                return;
            }
            For_Statement s = (For_Statement)node;
            Value finalExpression = s.getFinalExpression();
            if (finalExpression == null) {
                return;
            }
            IValue lastValue = finalExpression.getValueRefdLast(this.timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, null);
            IType.Type_type temp = lastValue.getExpressionReturntype(this.timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE);
            if (IType.Type_type.TYPE_BOOL == temp && !lastValue.isUnfoldable(this.timestamp)) {
                if (((Boolean_Value)lastValue).getValue()) {
                    problems.report(finalExpression.getLocation(), UnnecessaryControl.ALWAYS_TRUE);
                } else {
                    problems.report(finalExpression.getLocation(), UnnecessaryControl.UNREACHEBLE);
                }
            }
            if ((statementblock = s.getStatementBlock()) != null && StatementBlock.ReturnStatus_type.RS_YES.equals((Object)statementblock.hasReturn(this.timestamp))) {
                problems.report(s.getLocation(), ONE_SHOT);
            }
        }

        @Override
        public List<Class<? extends IVisitableNode>> getStartNode() {
            ArrayList<Class<? extends IVisitableNode>> ret = new ArrayList<Class<? extends IVisitableNode>>(1);
            ret.add(For_Statement.class);
            return ret;
        }
    }

    public static abstract class Base
    extends BaseModuleCodeSmellSpotter {
        protected final CompilationTimeStamp timestamp = CompilationTimeStamp.getBaseTimestamp();

        public Base() {
            super(CodeSmellType.UNNECESSARY_CONTROLS);
        }
    }
}

