/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.metrics.topview;

import java.util.Set;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titanium.metrics.IMetricEnum;
import org.eclipse.titanium.metrics.utils.ModuleMetricsWrapper;

class Comparator
extends ViewerComparator {
    private final ModuleMetricsWrapper mw;
    private final Set<IMetricEnum> metrics;

    public Comparator(ModuleMetricsWrapper m, Set<IMetricEnum> ms) {
        this.mw = m;
        this.metrics = ms;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        if (!(e1 instanceof Module) || !(e2 instanceof Module)) {
            return 0;
        }
        Module m1 = (Module)e1;
        Module m2 = (Module)e2;
        double risk1 = 0.0;
        double risk2 = 0.0;
        for (IMetricEnum m : this.metrics) {
            risk1 += this.mw.getRiskValue(m, m1.getName());
            risk2 += this.mw.getRiskValue(m, m2.getName());
        }
        double r = risk2 - risk1;
        if (r < 1.0E-4) {
            return -1;
        }
        if (r > 1.0E-4) {
            return 1;
        }
        return 0;
    }
}

