/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.preferences.pages;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.titanium.metrics.IMetricEnum;
import org.eclipse.titanium.metrics.MetricGroup;
import org.eclipse.titanium.metrics.ModuleMetric;
import org.eclipse.titanium.metrics.preferences.IRiskEditorListener;
import org.eclipse.titanium.metrics.preferences.IRiskEditorPropertyListener;
import org.eclipse.titanium.metrics.preferences.IRiskFieldEditor;
import org.eclipse.titanium.metrics.preferences.InstabilityRiskFieldEditor;
import org.eclipse.titanium.metrics.preferences.PreferenceManager;
import org.eclipse.titanium.metrics.preferences.SimpleRiskFieldEditor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class MetricsLimitPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String DESCRIPTION = "Setting limits of metrics to warn";
    private final List<IRiskFieldEditor> editors = new ArrayList<IRiskFieldEditor>();

    public void init(IWorkbench workbench) {
        this.setDescription(DESCRIPTION);
        this.setPreferenceStore(PreferenceManager.getStore());
    }

    protected Control createContents(Composite parent) {
        final Composite page = new Composite(parent, 0);
        GridLayout l = new GridLayout();
        l.numColumns = 2;
        page.setLayout((Layout)l);
        for (MetricGroup type : MetricGroup.values()) {
            Label header = new Label(page, 0);
            header.setText(type.getGroupName() + " metrics");
            GridData headerData = new GridData();
            headerData.horizontalSpan = 2;
            header.setLayoutData((Object)headerData);
            Composite padding = new Composite(page, 0);
            padding.setLayoutData((Object)new GridData(25, 0));
            final Composite inner = new Composite(page, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            inner.setLayout((Layout)layout);
            IRiskEditorListener listener = new IRiskEditorListener(){

                @Override
                public void editorChanged() {
                    inner.layout();
                    page.layout();
                }
            };
            IRiskEditorPropertyListener propertyListener = new IRiskEditorPropertyListener(){

                @Override
                public void propertyChange(boolean valid) {
                    if (!valid) {
                        MetricsLimitPreferencePage.this.setValid(false);
                        MetricsLimitPreferencePage.this.updateApplyButton();
                    } else if (!MetricsLimitPreferencePage.this.isValid()) {
                        MetricsLimitPreferencePage.this.checkState();
                    }
                }
            };
            for (IMetricEnum metric : type.getMetrics()) {
                Label name = new Label(inner, 0);
                name.setText(metric.getName());
                name.setToolTipText(metric.getHint());
                IRiskFieldEditor editor = MetricsLimitPreferencePage.getRiskEditor(inner, metric);
                editor.addRiskEditorListener(listener);
                editor.setPropListener(propertyListener);
                editor.load();
                this.editors.add(editor);
            }
        }
        this.checkState();
        return page;
    }

    protected void performDefaults() {
        for (IRiskFieldEditor editor : this.editors) {
            editor.loadDefault();
        }
        this.checkState();
    }

    protected void checkState() {
        boolean valid = true;
        for (IRiskFieldEditor ed : this.editors) {
            if (valid = valid && ed.isValid()) continue;
            break;
        }
        this.setValid(valid);
        this.updateApplyButton();
    }

    public boolean performOk() {
        for (IRiskFieldEditor ed : this.editors) {
            ed.store();
        }
        return true;
    }

    public void propertyChange(boolean valid) {
        if (!valid) {
            this.setValid(false);
            this.updateApplyButton();
        } else if (!this.isValid()) {
            this.checkState();
        }
    }

    private static IRiskFieldEditor getRiskEditor(Composite parent, IMetricEnum metric) {
        if (metric.equals(ModuleMetric.INSTABILITY)) {
            return new InstabilityRiskFieldEditor(parent, metric);
        }
        return new SimpleRiskFieldEditor(parent, metric);
    }
}

