/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.importexport.files;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.internal.importexport.RemoteImportExportResources;
import org.eclipse.rse.internal.importexport.files.Debug;
import org.eclipse.rse.internal.importexport.files.UniFilePlus;
import org.eclipse.rse.services.clientserver.messages.SimpleSystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileUtility;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.swt.widgets.Shell;

public class Utilities {
    public static final String IMPORT_DESCRIPTION_EXTENSION = "rimpfd";
    public static final String EXPORT_DESCRIPTION_EXTENSION = "rexpfd";
    static /* synthetic */ Class class$0;

    public static IRemoteFile getIRemoteFile(IHost c, String path) {
        IRemoteFile ret = null;
        if (c != null) {
            try {
                IRemoteFileSubSystem ss = RemoteFileUtility.getFileSubSystem((IHost)c);
                char sep = ss.getSeparatorChar();
                if (sep != '/') {
                    path = path.replace('/', sep);
                }
                ret = ss.getRemoteFileObject(path, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (SystemMessageException e) {
                Utilities.error((Exception)((Object)e));
            }
        }
        return ret;
    }

    public static String getAsString(IRemoteFile selectedDirectory) {
        return String.valueOf(selectedDirectory.getHost().getSystemProfileName()) + '.' + selectedDirectory.getHost().getAliasName() + ":" + selectedDirectory.getAbsolutePath();
    }

    public static String getAsString(UniFilePlus selectedDirectory) {
        return String.valueOf(selectedDirectory.remoteFile.getHost().getSystemProfileName()) + '.' + selectedDirectory.remoteFile.getHost().getAliasName() + ":" + selectedDirectory.getPath();
    }

    public static boolean isConnectionValid(String name, Shell s) {
        boolean ret = true;
        IHost sc = Utilities.parseForSystemConnection(name);
        if (sc == null) {
            ret = false;
            String msgTxt = RemoteImportExportResources.MSG_IMPORT_EXPORT_UNABLE_TO_USE_CONNECTION;
            String msgDetails = RemoteImportExportResources.MSG_IMPORT_EXPORT_UNABLE_TO_USE_CONNECTION_DETAILS;
            SimpleSystemMessage msg = new SimpleSystemMessage("org.eclipse.rse.importexport", "RSEF5101", 4, msgTxt, msgDetails);
            SystemMessageDialog.show((Shell)s, (SystemMessage)msg);
        }
        return ret;
    }

    public static IRemoteFile parseForIRemoteFile(String sel) {
        IHost c = Utilities.parseForSystemConnection(sel);
        if (c != null) {
            String path = Utilities.parseForPath(sel);
            return Utilities.getIRemoteFile(c, path);
        }
        return null;
    }

    public static String parseForPath(String sel) {
        return sel.indexOf(":") >= 0 ? sel.substring(sel.indexOf(":") + 1) : sel;
    }

    public static IHost getConnection(String profileName, String connectionName) {
        IHost[] connections = RSECorePlugin.getTheSystemRegistry().getHosts();
        if (profileName != null) {
            int loop = 0;
            while (loop < connections.length) {
                if (connections[loop].getAliasName().equalsIgnoreCase(connectionName) && connections[loop].getSystemProfileName().equalsIgnoreCase(profileName)) {
                    return connections[loop];
                }
                ++loop;
            }
        } else {
            int loop = 0;
            while (loop < connections.length) {
                if (connections[loop].getAliasName().equalsIgnoreCase(connectionName)) {
                    return connections[loop];
                }
                ++loop;
            }
        }
        return null;
    }

    public static IHost parseForSystemConnection(String sel) {
        try {
            String connectionName = sel.substring(0, sel.indexOf(":"));
            if (connectionName.indexOf(46) < 0) {
                return Utilities.getConnection(null, connectionName);
            }
            int dots = 0;
            int temp = 0;
            IHost sc = null;
            while (connectionName.indexOf(46, temp) >= 0) {
                ++dots;
                sc = Utilities.getConnection(connectionName.substring(0, (temp = connectionName.indexOf(46, temp) + 1) - 1), connectionName.substring(temp));
                if (sc == null) continue;
                return sc;
            }
            return Utilities.getConnection(null, connectionName);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void error(Exception e) {
        Class<?> clazz;
        Object[] o = null;
        Shell s = Utilities.getShell();
        try {
            s = SystemBasePlugin.getActiveWorkbenchWindow().getShell();
        }
        catch (Exception exception) {
            s = null;
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.services.clientserver.messages.SystemMessageException");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.isInstance(e)) {
            String mID = ((SystemMessageException)((Object)e)).getSystemMessage().getFullMessageID().substring(0, 8);
            Debug.out("About to issue SystemMessageException for  " + mID);
            if (mID.compareToIgnoreCase("EVFC9104") != 0 && mID.compareToIgnoreCase("EVFC9112") != 0 && s != null) {
                SystemMessageDialog d = new SystemMessageDialog(s, ((SystemMessageException)((Object)e)).getSystemMessage());
                d.open();
            }
        } else {
            o = new Object[]{e.getLocalizedMessage() == null ? e.toString() : e.getLocalizedMessage()};
            Utilities.logExceptionError(NLS.bind((String)RemoteImportExportResources.MSG_IMPORT_EXPORT_UNEXPECTED_EXCEPTION, (Object[])o), e);
            if (s != null) {
                String msgTxt = NLS.bind((String)RemoteImportExportResources.MSG_IMPORT_EXPORT_UNEXPECTED_EXCEPTION, (Object)o[0]);
                String msgDetails = RemoteImportExportResources.MSG_IMPORT_EXPORT_UNEXPECTED_EXCEPTION_DETAILS;
                SimpleSystemMessage msg = new SimpleSystemMessage("org.eclipse.rse.importexport", "RSEF5102", 4, msgTxt, msgDetails);
                SystemMessageDialog.show((Shell)s, (SystemMessage)msg);
            }
        }
    }

    public static Shell getShell() {
        Shell s = null;
        try {
            s = SystemBasePlugin.getActiveWorkbenchWindow().getShell();
        }
        catch (Exception exception) {
            s = null;
        }
        return s;
    }

    public static void logExceptionError(String msgTxt, Throwable exception) {
        SystemBasePlugin.logError((String)msgTxt, (Throwable)exception);
    }
}

